/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.datetime.local;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.LocaleUtils;
import com.googlecode.wicket.kendo.ui.form.datetime.local.LocalTextField;
import java.util.Locale;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.threeten.bp.LocalDate;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;

public class DatePicker
extends LocalTextField<LocalDate> {
    private static final long serialVersionUID = 1L;

    public DatePicker(String id) {
        this(id, new Options());
    }

    public DatePicker(String id, Options options) {
        this(id, null, null, "MM/dd/yyyy", options);
    }

    public DatePicker(String id, Locale locale) {
        this(id, locale, new Options());
    }

    public DatePicker(String id, Locale locale, Options options) {
        this(id, null, locale, LocaleUtils.getLocaleDatePattern((Locale)locale, (String)"MM/dd/yyyy"), options);
    }

    public DatePicker(String id, String pattern) {
        this(id, pattern, new Options());
    }

    public DatePicker(String id, String pattern, Options options) {
        this(id, null, null, pattern, options);
    }

    public DatePicker(String id, Locale locale, String pattern) {
        this(id, locale, pattern, new Options());
    }

    public DatePicker(String id, Locale locale, String pattern, Options options) {
        this(id, null, locale, pattern, options);
    }

    public DatePicker(String id, IModel<LocalDate> model) {
        this(id, model, new Options());
    }

    public DatePicker(String id, IModel<LocalDate> model, Options options) {
        this(id, model, null, "MM/dd/yyyy", options);
    }

    public DatePicker(String id, IModel<LocalDate> model, Locale locale) {
        this(id, model, locale, new Options());
    }

    public DatePicker(String id, IModel<LocalDate> model, Locale locale, Options options) {
        this(id, model, locale, LocaleUtils.getLocaleDatePattern((Locale)locale, (String)"MM/dd/yyyy"), options);
    }

    public DatePicker(String id, IModel<LocalDate> model, String pattern) {
        this(id, model, pattern, new Options());
    }

    public DatePicker(String id, IModel<LocalDate> model, String pattern, Options options) {
        this(id, model, null, pattern, options);
    }

    public DatePicker(String id, IModel<LocalDate> model, Locale locale, String pattern) {
        this(id, model, locale, pattern, new Options());
    }

    public DatePicker(String id, IModel<LocalDate> model, Locale locale, String pattern, Options options) {
        super(id, model, locale, pattern, options, LocalDate.class, DatePicker.newConverter(pattern));
    }

    @Override
    protected String getMethod() {
        return "kendoDatePicker";
    }

    protected String[] getInputTypes() {
        return new String[]{"text", "date"};
    }

    private static IConverter<LocalDate> newConverter(final String pattern) {
        return new IConverter<LocalDate>(){
            private static final long serialVersionUID = 1L;

            public LocalDate convertToObject(String value, Locale locale) {
                try {
                    return LocalDate.parse((CharSequence)value, (DateTimeFormatter)DateTimeFormatter.ofPattern((String)pattern, (Locale)locale));
                }
                catch (DateTimeParseException e) {
                    throw new ConversionException(e.getMessage(), (Throwable)e);
                }
            }

            public String convertToString(LocalDate date, Locale locale) {
                return date != null ? date.format(DateTimeFormatter.ofPattern((String)pattern, (Locale)locale)) : null;
            }
        };
    }
}

