/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.treeview;

import com.googlecode.wicket.jquery.core.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.core.utils.JQueryUtils;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.template.KendoTemplateBehavior;
import com.googlecode.wicket.kendo.ui.widget.treeview.AjaxTreeViewBehavior;
import com.googlecode.wicket.kendo.ui.widget.treeview.ITreeViewListener;
import com.googlecode.wicket.kendo.ui.widget.treeview.TreeNodeFactory;
import com.googlecode.wicket.kendo.ui.widget.treeview.TreeViewModel;
import com.googlecode.wicket.kendo.ui.widget.treeview.TreeViewModelBehavior;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class AjaxTreeView
extends JQueryContainer
implements ITreeViewListener {
    private static final long serialVersionUID = 1L;
    private TreeViewModelBehavior modelBehavior;
    private IJQueryTemplate template;
    private KendoTemplateBehavior templateBehavior = null;
    protected final Options options;

    public AjaxTreeView(String id, TreeViewModel model) {
        this(id, model, new Options());
    }

    public AjaxTreeView(String id, TreeViewModel model, Options options) {
        super(id, (IModel)model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoTreeView");
    }

    public void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("var $w = %s; if ($w) { $w.dataSource.read(); }", this.widget()));
        this.onRefresh(handler);
    }

    public void expandPath(IPartialPageRequestHandler handler, String path) {
        String statement = String.format("%s.expandPath(%s);", this.widget(), path);
        handler.appendJavaScript((CharSequence)JQueryUtils.trycatch((String)statement));
    }

    public void expandPaths(IPartialPageRequestHandler handler, List<String> paths) {
        for (String path : paths) {
            this.expandPath(handler, path);
        }
    }

    public TreeViewModel getModel() {
        return (TreeViewModel)this.getDefaultModel();
    }

    protected CharSequence getCallbackUrl() {
        return this.modelBehavior.getCallbackUrl();
    }

    public String getTemplateToken() {
        if (this.templateBehavior != null) {
            return this.templateBehavior.getToken();
        }
        return null;
    }

    @Override
    public boolean isChangeEventEnabled() {
        return false;
    }

    @Override
    public boolean isExpandEventEnabled() {
        return false;
    }

    @Override
    public boolean isDropEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.modelBehavior = this.newTreeViewModelBehavior(this.getModel(), this.newTreeNodeFactory());
        this.add(new Behavior[]{this.modelBehavior});
        this.template = this.newTemplate();
        if (this.template != null) {
            this.templateBehavior = new KendoTemplateBehavior(this.template);
            this.add(new Behavior[]{this.templateBehavior});
        }
    }

    public void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        behavior.setOption("dataUrlField", (Object)Options.asString((String)"url"));
        behavior.setOption("dataTextField", (Object)Options.asString((String)"text"));
        if (this.templateBehavior != null) {
            behavior.setOption("template", (Object)String.format("jQuery('#%s').html()", this.getTemplateToken()));
        }
    }

    protected void onConfigure(KendoDataSource.HierarchicalDataSource dataSource) {
        dataSource.set("schema", String.format("{ model: { id: '%s' } }", "nid"));
    }

    protected void onRefresh(IPartialPageRequestHandler handler) {
    }

    @Override
    public void onExpand(AjaxRequestTarget target, int nodeId) {
    }

    @Override
    public void onChange(AjaxRequestTarget target, int nodeId, String nodePath) {
    }

    @Override
    public void onDrop(AjaxRequestTarget target, int nodeId, int parentId, String position) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new AjaxTreeViewBehavior(selector, this.options, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getDataSourceUrl() {
                return AjaxTreeView.this.getCallbackUrl();
            }

            @Override
            protected void onConfigure(KendoDataSource.HierarchicalDataSource dataSource) {
                AjaxTreeView.this.onConfigure(dataSource);
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    protected TreeNodeFactory newTreeNodeFactory() {
        return new TreeNodeFactory();
    }

    protected TreeViewModelBehavior newTreeViewModelBehavior(TreeViewModel model, TreeNodeFactory factory) {
        return new TreeViewModelBehavior(model, factory);
    }

    public static class ExpandBehavior
    extends JQueryAbstractBehavior {
        private static final long serialVersionUID = 1L;
        private String widget;
        private final List<String> paths;

        public ExpandBehavior(String path) {
            this(Arrays.asList(path));
        }

        public ExpandBehavior(List<String> paths) {
            this.paths = paths;
        }

        public void bind(Component component) {
            super.bind(component);
            this.widget = KendoUIBehavior.widget(component, "kendoTreeView");
        }

        protected String getDataBoundCallback() {
            String statement = "";
            for (String path : this.paths) {
                statement = statement + String.format("this.expandPath(%s);", path);
            }
            return statement;
        }

        protected String $() {
            return String.format("var $w = %s; $w.bind('dataBound', function(e) { %s }); ", this.widget, this.getDataBoundCallback());
        }
    }
}

