/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.treeview;

import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.kendo.ui.widget.treeview.TreeNode;
import com.googlecode.wicket.kendo.ui.widget.treeview.TreeNodeFactory;
import com.googlecode.wicket.kendo.ui.widget.treeview.TreeViewModel;
import java.util.List;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.lang.Args;

public class TreeViewModelBehavior
extends AjaxCallbackBehavior {
    private static final long serialVersionUID = 1L;
    private final TreeViewModel model;
    private final TreeNodeFactory factory;

    public TreeViewModelBehavior(TreeViewModel model, TreeNodeFactory factory) {
        this.model = model;
        this.factory = (TreeNodeFactory)Args.notNull((Object)factory, (String)"factory");
    }

    public TreeNodeFactory getFactory() {
        return this.factory;
    }

    protected String getResponse(IRequestParameters parameters) {
        int nodeId = parameters.getParameterValue("nid").toInt(0);
        StringBuilder builder = new StringBuilder("[ ");
        if (this.model != null) {
            this.model.setNodeId(nodeId);
            List objects = (List)this.model.getObject();
            for (int index = 0; index < objects.size(); ++index) {
                TreeNode object = (TreeNode)objects.get(index);
                if (index > 0) {
                    builder.append(", ");
                }
                builder.append(this.factory.toJson(index, object));
            }
        }
        return builder.append(" ]").toString();
    }
}

