/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDValidatorBase;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DefaultAttrValue;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.ent.EntityDecl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputData;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputProblemReporter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.WordResolver;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidationContext;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public abstract class DTDAttribute {
    static final char CHAR_SPACE = ' ';
    public static final int TYPE_CDATA = 0;
    public static final int TYPE_ENUMERATED = 1;
    public static final int TYPE_ID = 2;
    public static final int TYPE_IDREF = 3;
    public static final int TYPE_IDREFS = 4;
    public static final int TYPE_ENTITY = 5;
    public static final int TYPE_ENTITIES = 6;
    public static final int TYPE_NOTATION = 7;
    public static final int TYPE_NMTOKEN = 8;
    public static final int TYPE_NMTOKENS = 9;
    static final String[] sTypes = new String[]{"CDATA", "ENUMERATED", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};
    protected final PrefixedName mName;
    protected final int mSpecialIndex;
    protected final DefaultAttrValue mDefValue;
    protected final boolean mCfgNsAware;
    protected final boolean mCfgXml11;

    public DTDAttribute(PrefixedName prefixedName, DefaultAttrValue defaultAttrValue, int n2, boolean bl2, boolean bl3) {
        this.mName = prefixedName;
        this.mDefValue = defaultAttrValue;
        this.mSpecialIndex = n2;
        this.mCfgNsAware = bl2;
        this.mCfgXml11 = bl3;
    }

    public abstract DTDAttribute cloneWith(int var1);

    public final PrefixedName getName() {
        return this.mName;
    }

    public final String toString() {
        return this.mName.toString();
    }

    public final String getDefaultValue(ValidationContext validationContext, XMLValidator xMLValidator) throws XMLStreamException {
        String string = this.mDefValue.getValueIfOk();
        if (string == null) {
            this.mDefValue.reportUndeclared(validationContext, xMLValidator);
            string = this.mDefValue.getValue();
        }
        return string;
    }

    public final int getSpecialIndex() {
        return this.mSpecialIndex;
    }

    public final boolean needsValidation() {
        return this.getValueType() != 0;
    }

    public final boolean isFixed() {
        return this.mDefValue.isFixed();
    }

    public final boolean isRequired() {
        return this.mDefValue.isRequired();
    }

    public final boolean isSpecial() {
        return this.mDefValue.isSpecial();
    }

    public final boolean hasDefaultValue() {
        return this.mDefValue.hasDefaultValue();
    }

    public int getValueType() {
        return 0;
    }

    public String getValueTypeString() {
        return sTypes[this.getValueType()];
    }

    public boolean typeIsId() {
        return false;
    }

    public boolean typeIsNotation() {
        return false;
    }

    public abstract String validate(DTDValidatorBase var1, char[] var2, int var3, int var4, boolean var5) throws XMLStreamException;

    public String validate(DTDValidatorBase dTDValidatorBase, String string, boolean bl2) throws XMLStreamException {
        int n2 = string.length();
        char[] cArray = dTDValidatorBase.getTempAttrValueBuffer(string.length());
        if (n2 > 0) {
            string.getChars(0, n2, cArray, 0);
        }
        return this.validate(dTDValidatorBase, cArray, 0, n2, bl2);
    }

    public abstract void validateDefault(InputProblemReporter var1, boolean var2) throws XMLStreamException;

    public String normalize(DTDValidatorBase dTDValidatorBase, char[] cArray, int n2, int n3) {
        return StringUtil.normalizeSpaces(cArray, n2, n3);
    }

    public void normalizeDefault() {
        char[] cArray;
        String string;
        String string2 = this.mDefValue.getValue();
        if (string2.length() > 0 && (string = StringUtil.normalizeSpaces(cArray = string2.toCharArray(), 0, cArray.length)) != null) {
            this.mDefValue.setValue(string);
        }
    }

    protected String validateDefaultName(InputProblemReporter inputProblemReporter, boolean bl2) throws XMLStreamException {
        int n2;
        String string = this.mDefValue.getValue();
        String string2 = string.trim();
        if (string2.length() == 0) {
            this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string2 + "'; empty String is not a valid name");
        }
        if ((n2 = WstxInputData.findIllegalNameChar(string2, this.mCfgNsAware, this.mCfgXml11)) >= 0) {
            if (n2 == 0) {
                this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string2 + "'; character " + WstxInputData.getCharDesc(string2.charAt(0)) + ") not valid first character of a name");
            } else {
                this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string2 + "'; character #" + n2 + " (" + WstxInputData.getCharDesc(string2.charAt(n2)) + ") not valid name character");
            }
        }
        return bl2 ? string2 : string;
    }

    protected String validateDefaultNames(InputProblemReporter inputProblemReporter, boolean bl2) throws XMLStreamException {
        String string = this.mDefValue.getValue().trim();
        int n2 = string.length();
        StringBuilder stringBuilder = null;
        int n3 = 0;
        int n4 = 0;
        block0: while (n4 < n2) {
            int n5;
            char c2 = string.charAt(n4);
            while (WstxInputData.isSpaceChar(c2)) {
                if (++n4 >= n2) break block0;
                c2 = string.charAt(n4);
            }
            for (n5 = n4 + 1; n5 < n2 && !WstxInputData.isSpaceChar(string.charAt(n5)); ++n5) {
            }
            String string2 = string.substring(n4, n5);
            int n6 = WstxInputData.findIllegalNameChar(string2, this.mCfgNsAware, this.mCfgXml11);
            if (n6 >= 0) {
                if (n6 == 0) {
                    this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string + "'; character " + WstxInputData.getCharDesc(string.charAt(n4)) + ") not valid first character of a name token");
                } else {
                    this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string + "'; character " + WstxInputData.getCharDesc(c2) + ") not a valid name character");
                }
            }
            ++n3;
            if (bl2) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n5 - n4 + 32);
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string2);
            }
            n4 = n5 + 1;
        }
        if (n3 == 0) {
            return this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string + "'; empty String is not a valid name value");
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    protected String validateDefaultNmToken(InputProblemReporter inputProblemReporter, boolean bl2) throws XMLStreamException {
        int n2;
        String string = this.mDefValue.getValue();
        String string2 = string.trim();
        if (string2.length() == 0) {
            this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string2 + "'; empty String is not a valid NMTOKEN");
        }
        if ((n2 = WstxInputData.findIllegalNmtokenChar(string2, this.mCfgNsAware, this.mCfgXml11)) >= 0) {
            this.reportValidationProblem(inputProblemReporter, "Invalid default value '" + string2 + "'; character #" + n2 + " (" + WstxInputData.getCharDesc(string2.charAt(n2)) + ") not valid NMTOKEN character");
        }
        return bl2 ? string2 : string;
    }

    public String validateEnumValue(char[] cArray, int n2, int n3, boolean bl2, WordResolver wordResolver) {
        if (bl2) {
            while (n2 < n3 && cArray[n2] <= ' ') {
                ++n2;
            }
            while (--n3 > n2 && cArray[n3] <= ' ') {
            }
            ++n3;
        }
        if (n2 >= n3) {
            return null;
        }
        return wordResolver.find(cArray, n2, n3);
    }

    protected EntityDecl findEntityDecl(DTDValidatorBase dTDValidatorBase, char[] cArray, int n2, int n3) throws XMLStreamException {
        String string;
        Map<String, EntityDecl> map = dTDValidatorBase.getEntityMap();
        EntityDecl entityDecl = map.get(string = new String(cArray, n2, n3));
        if (entityDecl == null) {
            this.reportValidationProblem(dTDValidatorBase, "Referenced entity '" + string + "' not defined");
        } else if (entityDecl.isParsed()) {
            this.reportValidationProblem(dTDValidatorBase, "Referenced entity '" + string + "' is not an unparsed entity");
        }
        return entityDecl;
    }

    protected void checkEntity(InputProblemReporter inputProblemReporter, String string, EntityDecl entityDecl) throws XMLStreamException {
        if (entityDecl == null) {
            inputProblemReporter.reportValidationProblem("Referenced entity '" + string + "' not defined");
        } else if (entityDecl.isParsed()) {
            inputProblemReporter.reportValidationProblem("Referenced entity '" + string + "' is not an unparsed entity");
        }
    }

    protected String reportInvalidChar(DTDValidatorBase dTDValidatorBase, char c2, String string) throws XMLStreamException {
        this.reportValidationProblem(dTDValidatorBase, "Invalid character " + WstxInputData.getCharDesc(c2) + ": " + string);
        return null;
    }

    protected String reportValidationProblem(DTDValidatorBase dTDValidatorBase, String string) throws XMLStreamException {
        dTDValidatorBase.reportValidationProblem("Attribute '" + this.mName + "': " + string);
        return null;
    }

    protected String reportValidationProblem(InputProblemReporter inputProblemReporter, String string) throws XMLStreamException {
        inputProblemReporter.reportValidationProblem("Attribute definition '" + this.mName + "': " + string);
        return null;
    }
}

