/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BaseInputSource;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BaseReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputData;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputSource;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;

public class ReaderSource
extends BaseInputSource {
    final ReaderConfig mConfig;
    protected Reader mReader;
    final boolean mDoRealClose;
    int mInputProcessed = 0;
    int mInputRow = 1;
    int mInputRowStart = 0;

    public ReaderSource(ReaderConfig readerConfig, WstxInputSource wstxInputSource, String string, String string2, SystemId systemId, Reader reader, boolean bl2) {
        super(wstxInputSource, string, string2, systemId);
        this.mConfig = readerConfig;
        this.mReader = reader;
        this.mDoRealClose = bl2;
        int n2 = readerConfig.getInputBufferLength();
        this.mBuffer = readerConfig.allocFullCBuffer(n2);
    }

    public void setInputOffsets(int n2, int n3, int n4) {
        this.mInputProcessed = n2;
        this.mInputRow = n3;
        this.mInputRowStart = n4;
    }

    @Override
    protected void doInitInputLocation(WstxInputData wstxInputData) {
        wstxInputData.mCurrInputProcessed = this.mInputProcessed;
        wstxInputData.mCurrInputRow = this.mInputRow;
        wstxInputData.mCurrInputRowStart = this.mInputRowStart;
    }

    @Override
    public boolean fromInternalEntity() {
        return false;
    }

    @Override
    public int readInto(WstxInputData wstxInputData) throws IOException, XMLStreamException {
        if (this.mBuffer == null) {
            return -1;
        }
        int n2 = this.mReader.read(this.mBuffer, 0, this.mBuffer.length);
        if (n2 < 1) {
            this.mInputLast = 0;
            wstxInputData.mInputPtr = 0;
            wstxInputData.mInputEnd = 0;
            if (n2 == 0) {
                throw new WstxException("Reader (of type " + this.mReader.getClass().getName() + ") returned 0 characters, even when asked to read up to " + this.mBuffer.length, this.getLocation());
            }
            return -1;
        }
        wstxInputData.mInputBuffer = this.mBuffer;
        wstxInputData.mInputPtr = 0;
        this.mInputLast = n2;
        wstxInputData.mInputEnd = n2;
        return n2;
    }

    @Override
    public boolean readMore(WstxInputData wstxInputData, int n2) throws IOException, XMLStreamException {
        if (this.mBuffer == null) {
            return false;
        }
        int n3 = wstxInputData.mInputPtr;
        int n4 = this.mInputLast - n3;
        wstxInputData.mCurrInputProcessed += (long)n3;
        wstxInputData.mCurrInputRowStart -= n3;
        if (n4 > 0) {
            System.arraycopy(this.mBuffer, n3, this.mBuffer, 0, n4);
            n2 -= n4;
        }
        wstxInputData.mInputBuffer = this.mBuffer;
        wstxInputData.mInputPtr = 0;
        this.mInputLast = n4;
        while (n2 > 0) {
            int n5 = this.mBuffer.length - n4;
            int n6 = this.mReader.read(this.mBuffer, n4, n5);
            if (n6 < 1) {
                if (n6 == 0) {
                    throw new WstxException("Reader (of type " + this.mReader.getClass().getName() + ") returned 0 characters, even when asked to read up to " + n5, this.getLocation());
                }
                wstxInputData.mInputEnd = this.mInputLast = n4;
                return false;
            }
            n4 += n6;
            n2 -= n6;
        }
        wstxInputData.mInputEnd = this.mInputLast = n4;
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.mBuffer != null) {
            this.closeAndRecycle(this.mDoRealClose);
        }
    }

    @Override
    public void closeCompletely() throws IOException {
        if (this.mReader != null) {
            this.closeAndRecycle(true);
        }
    }

    private void closeAndRecycle(boolean bl2) throws IOException {
        char[] cArray = this.mBuffer;
        if (cArray != null) {
            this.mBuffer = null;
            this.mConfig.freeFullCBuffer(cArray);
        }
        if (this.mReader != null) {
            if (this.mReader instanceof BaseReader) {
                ((BaseReader)this.mReader).freeBuffers();
            }
            if (bl2) {
                Reader reader = this.mReader;
                this.mReader = null;
                reader.close();
            }
        }
    }
}

