/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.jarv;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Schema;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierConfigurationException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Grammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.XMLSchemaGrammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.IVerifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.Verifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity.IDConstraintChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.jarv.SchemaImpl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.REDocumentDeclaration;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.util.ErrorHandlerImpl;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public abstract class FactoryImpl
extends VerifierFactory {
    protected final SAXParserFactory factory;
    private boolean usePanicMode = true;
    private EntityResolver resolver;

    protected FactoryImpl(SAXParserFactory sAXParserFactory) {
        this.factory = sAXParserFactory;
    }

    protected FactoryImpl() {
        this.factory = SAXParserFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://www.sun.com/xmlns/msv/features/panicMode")) {
            this.usePanicMode = bl2;
        } else {
            super.setFeature(string, bl2);
        }
    }

    public boolean isFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://www.sun.com/xmlns/msv/features/panicMode")) {
            return this.usePanicMode;
        }
        return super.isFeature(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    protected abstract Grammar parse(InputSource var1, GrammarReaderController var2) throws SAXException, VerifierConfigurationException;

    public Schema compileSchema(InputSource inputSource) throws VerifierConfigurationException, SAXException {
        try {
            Grammar grammar = this.parse(inputSource, new ThrowController());
            if (grammar == null) {
                throw new VerifierConfigurationException("unable to parse the schema");
            }
            return new SchemaImpl(grammar, this.factory, this.usePanicMode);
        }
        catch (WrapperException wrapperException) {
            throw wrapperException.e;
        }
        catch (Exception exception) {
            throw new VerifierConfigurationException(exception);
        }
    }

    static IVerifier createVerifier(Grammar grammar) {
        if (grammar instanceof XMLSchemaGrammar) {
            return new IDConstraintChecker((XMLSchemaGrammar)grammar, (ErrorHandler)new ErrorHandlerImpl());
        }
        return new Verifier(new REDocumentDeclaration(grammar), new ErrorHandlerImpl());
    }

    private class ThrowController
    implements GrammarReaderController {
        private ThrowController() {
        }

        public void warning(Locator[] locatorArray, String string) {
        }

        public void error(Locator[] locatorArray, String string, Exception exception) {
            for (int i2 = 0; i2 < locatorArray.length; ++i2) {
                if (locatorArray[i2] == null) continue;
                throw new WrapperException(new SAXParseException(string, locatorArray[i2], exception));
            }
            throw new WrapperException(new SAXException(string, exception));
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (FactoryImpl.this.resolver == null) {
                return null;
            }
            return FactoryImpl.this.resolver.resolveEntity(string, string2);
        }
    }

    private static class WrapperException
    extends RuntimeException {
        public final SAXException e;

        WrapperException(SAXException sAXException) {
            super(sAXException.getMessage());
            this.e = sAXException;
        }
    }
}

