/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;

public abstract class EncodingXmlWriter
extends XmlWriter {
    static final int DEFAULT_BUFFER_SIZE = 4000;
    static final byte BYTE_SPACE = 32;
    static final byte BYTE_COLON = 58;
    static final byte BYTE_SEMICOLON = 59;
    static final byte BYTE_LBRACKET = 91;
    static final byte BYTE_RBRACKET = 93;
    static final byte BYTE_QMARK = 63;
    static final byte BYTE_EQ = 61;
    static final byte BYTE_SLASH = 47;
    static final byte BYTE_HASH = 35;
    static final byte BYTE_HYPHEN = 45;
    static final byte BYTE_LT = 60;
    static final byte BYTE_GT = 62;
    static final byte BYTE_AMP = 38;
    static final byte BYTE_QUOT = 34;
    static final byte BYTE_APOS = 39;
    static final byte BYTE_A = 97;
    static final byte BYTE_G = 103;
    static final byte BYTE_L = 108;
    static final byte BYTE_M = 109;
    static final byte BYTE_O = 111;
    static final byte BYTE_P = 112;
    static final byte BYTE_Q = 113;
    static final byte BYTE_S = 115;
    static final byte BYTE_T = 116;
    static final byte BYTE_U = 117;
    static final byte BYTE_X = 120;
    private final OutputStream mOut;
    protected byte[] mOutputBuffer;
    protected int mOutputPtr;
    protected int mSurrogate = 0;

    public EncodingXmlWriter(OutputStream outputStream, WriterConfig writerConfig, String string, boolean bl2) throws IOException {
        super(writerConfig, string, bl2);
        this.mOut = outputStream;
        this.mOutputBuffer = writerConfig.allocFullBBuffer(4000);
        this.mOutputPtr = 0;
    }

    @Override
    protected int getOutputPtr() {
        return this.mOutputPtr;
    }

    @Override
    protected final OutputStream getOutputStream() {
        return this.mOut;
    }

    @Override
    protected final Writer getWriter() {
        return null;
    }

    @Override
    public void close(boolean bl2) throws IOException {
        this.flush();
        byte[] byArray = this.mOutputBuffer;
        if (byArray != null) {
            this.mOutputBuffer = null;
            this.mConfig.freeFullBBuffer(byArray);
        }
        if (bl2 || this.mAutoCloseOutput) {
            this.mOut.close();
        }
    }

    @Override
    public final void flush() throws IOException {
        this.flushBuffer();
        this.mOut.flush();
    }

    @Override
    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void writeRaw(String var1, int var2, int var3) throws IOException;

    @Override
    public final void writeCDataStart() throws IOException {
        this.writeAscii("<![CDATA[");
    }

    @Override
    public final void writeCDataEnd() throws IOException {
        this.writeAscii("]]>");
    }

    @Override
    public final void writeCommentStart() throws IOException {
        this.writeAscii("<!--");
    }

    @Override
    public final void writeCommentEnd() throws IOException {
        this.writeAscii("-->");
    }

    @Override
    public final void writePIStart(String string, boolean bl2) throws IOException {
        this.writeAscii((byte)60, (byte)63);
        this.writeRaw(string);
        if (bl2) {
            this.writeAscii((byte)32);
        }
    }

    @Override
    public final void writePIEnd() throws IOException {
        this.writeAscii((byte)63, (byte)62);
    }

    @Override
    public int writeCData(String string) throws IOException {
        this.writeAscii("<![CDATA[");
        int n2 = this.writeCDataContent(string);
        if (n2 >= 0) {
            return n2;
        }
        this.writeAscii("]]>");
        return -1;
    }

    @Override
    public int writeCData(char[] cArray, int n2, int n3) throws IOException {
        this.writeAscii("<![CDATA[");
        int n4 = this.writeCDataContent(cArray, n2, n3);
        if (n4 >= 0) {
            return n4;
        }
        this.writeAscii("]]>");
        return -1;
    }

    @Override
    public final void writeCharacters(String string) throws IOException {
        if (this.mTextWriter != null) {
            this.mTextWriter.write(string);
        } else {
            this.writeTextContent(string);
        }
    }

    @Override
    public final void writeCharacters(char[] cArray, int n2, int n3) throws IOException {
        if (this.mTextWriter != null) {
            this.mTextWriter.write(cArray, n2, n3);
        } else {
            this.writeTextContent(cArray, n2, n3);
        }
    }

    @Override
    public int writeComment(String string) throws IOException {
        this.writeAscii("<!--");
        int n2 = this.writeCommentContent(string);
        if (n2 >= 0) {
            return n2;
        }
        this.writeAscii("-->");
        return -1;
    }

    @Override
    public void writeDTD(String string) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        this.writeRaw(string, 0, string.length());
    }

    @Override
    public void writeDTD(String string, String string2, String string3, String string4) throws IOException, XMLStreamException {
        this.writeAscii("<!DOCTYPE ");
        this.writeAscii(string);
        if (string2 != null) {
            if (string3 != null) {
                this.writeAscii(" PUBLIC \"");
                this.writeRaw(string3, 0, string3.length());
                this.writeAscii("\" \"");
            } else {
                this.writeAscii(" SYSTEM \"");
            }
            this.writeRaw(string2, 0, string2.length());
            this.writeAscii((byte)34);
        }
        if (string4 != null && string4.length() > 0) {
            this.writeAscii((byte)32, (byte)91);
            this.writeRaw(string4, 0, string4.length());
            this.writeAscii((byte)93);
        }
        this.writeAscii((byte)62);
    }

    @Override
    public void writeEntityReference(String string) throws IOException, XMLStreamException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        this.writeAscii((byte)38);
        this.writeName(string);
        this.writeAscii((byte)59);
    }

    @Override
    public void writeXmlDeclaration(String string, String string2, String string3) throws IOException {
        byte by2 = this.mUseDoubleQuotesInXmlDecl ? (byte)34 : 39;
        this.writeAscii("<?xml version=");
        this.writeAscii(by2);
        this.writeAscii(string);
        this.writeAscii(by2);
        if (string2 != null && string2.length() > 0) {
            this.writeAscii(" encoding=");
            this.writeAscii(by2);
            this.writeRaw(string2, 0, string2.length());
            this.writeAscii(by2);
        }
        if (string3 != null) {
            this.writeAscii(" standalone=");
            this.writeAscii(by2);
            this.writeAscii(string3);
            this.writeAscii(by2);
        }
        this.writeAscii((byte)63, (byte)62);
    }

    @Override
    public int writePI(String string, String string2) throws IOException, XMLStreamException {
        this.writeAscii((byte)60, (byte)63);
        this.writeName(string);
        if (string2 != null && string2.length() > 0) {
            this.writeAscii((byte)32);
            int n2 = this.writePIData(string2);
            if (n2 >= 0) {
                return n2;
            }
        }
        this.writeAscii((byte)63, (byte)62);
        return -1;
    }

    @Override
    public void writeStartTagStart(String string) throws IOException, XMLStreamException {
        this.writeAscii((byte)60);
        this.writeName(string);
    }

    @Override
    public void writeStartTagStart(String string, String string2) throws IOException, XMLStreamException {
        if (string == null || string.length() == 0) {
            this.writeStartTagStart(string2);
            return;
        }
        this.writeAscii((byte)60);
        this.writeName(string);
        this.writeAscii((byte)58);
        this.writeName(string2);
    }

    @Override
    public void writeStartTagEnd() throws IOException {
        this.writeAscii((byte)62);
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        if (this.mAddSpaceAfterEmptyElem) {
            this.writeAscii(" />");
        } else {
            this.writeAscii((byte)47, (byte)62);
        }
    }

    @Override
    public void writeEndTag(String string) throws IOException {
        this.writeAscii((byte)60, (byte)47);
        this.writeNameUnchecked(string);
        this.writeAscii((byte)62);
    }

    @Override
    public void writeEndTag(String string, String string2) throws IOException {
        this.writeAscii((byte)60, (byte)47);
        if (string != null && string.length() > 0) {
            this.writeNameUnchecked(string);
            this.writeAscii((byte)58);
        }
        this.writeNameUnchecked(string2);
        this.writeAscii((byte)62);
    }

    @Override
    public void writeAttribute(String string, String string2) throws IOException, XMLStreamException {
        this.writeAscii((byte)32);
        this.writeName(string);
        this.writeAscii((byte)61, (byte)34);
        int n2 = string2.length();
        if (n2 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(string2, 0, n2);
            } else {
                this.writeAttrValue(string2);
            }
        }
        this.writeAscii((byte)34);
    }

    @Override
    public void writeAttribute(String string, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        this.writeAscii((byte)32);
        this.writeName(string);
        this.writeAscii((byte)61, (byte)34);
        if (n3 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(cArray, n2, n3);
            } else {
                this.writeAttrValue(cArray, n2, n3);
            }
        }
        this.writeAscii((byte)34);
    }

    @Override
    public void writeAttribute(String string, String string2, String string3) throws IOException, XMLStreamException {
        this.writeAscii((byte)32);
        this.writeName(string);
        this.writeAscii((byte)58);
        this.writeName(string2);
        this.writeAscii((byte)61, (byte)34);
        int n2 = string3.length();
        if (n2 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(string3, 0, n2);
            } else {
                this.writeAttrValue(string3);
            }
        }
        this.writeAscii((byte)34);
    }

    @Override
    public void writeAttribute(String string, String string2, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        this.writeAscii((byte)32);
        this.writeName(string);
        this.writeAscii((byte)58);
        this.writeName(string2);
        this.writeAscii((byte)61, (byte)34);
        if (n3 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(cArray, n2, n3);
            } else {
                this.writeAttrValue(cArray, n2, n3);
            }
        }
        this.writeAscii((byte)34);
    }

    @Override
    public final void writeTypedElement(AsciiValueEncoder asciiValueEncoder) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (asciiValueEncoder.bufferNeedsFlush(this.mOutputBuffer.length - this.mOutputPtr)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBuffer.length);
            if (asciiValueEncoder.isCompleted()) break;
            this.flush();
        }
    }

    @Override
    public final void writeTypedElement(AsciiValueEncoder asciiValueEncoder, XMLValidator xMLValidator, char[] cArray) throws IOException, XMLStreamException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int n2 = cArray.length;
        do {
            int n3 = asciiValueEncoder.encodeMore(cArray, 0, n2);
            xMLValidator.validateText(cArray, 0, n3, false);
            this.writeRawAscii(cArray, 0, n3);
        } while (!asciiValueEncoder.isCompleted());
    }

    @Override
    public void writeTypedAttribute(String string, AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        this.writeAscii((byte)32);
        this.writeName(string);
        this.writeAscii((byte)61, (byte)34);
        if (asciiValueEncoder.bufferNeedsFlush(this.mOutputBuffer.length - this.mOutputPtr)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBuffer.length);
            if (asciiValueEncoder.isCompleted()) break;
            this.flush();
        }
        this.writeAscii((byte)34);
    }

    @Override
    public void writeTypedAttribute(String string, String string2, AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        System.err.println("DEBUG: write typed attr/0 '" + string2 + "'");
        this.writeAscii((byte)32);
        this.writeName(string);
        this.writeAscii((byte)58);
        this.writeName(string2);
        this.writeAscii((byte)61, (byte)34);
        if (asciiValueEncoder.bufferNeedsFlush(this.mOutputBuffer.length - this.mOutputPtr)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = asciiValueEncoder.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBuffer.length);
            if (asciiValueEncoder.isCompleted()) break;
            this.flush();
        }
        this.writeAscii((byte)34);
    }

    @Override
    public void writeTypedAttribute(String string, String string2, String string3, AsciiValueEncoder asciiValueEncoder, XMLValidator xMLValidator, char[] cArray) throws IOException, XMLStreamException {
        boolean bl2;
        boolean bl3 = bl2 = string != null && string.length() > 0;
        if (string3 == null) {
            string3 = "";
        }
        System.err.println("DEBUG: write typed attr/1 '" + string2 + "', vld == " + xMLValidator);
        this.writeAscii((byte)32);
        if (bl2) {
            this.writeName(string);
            this.writeAscii((byte)58);
        }
        this.writeName(string2);
        this.writeAscii((byte)61, (byte)34);
        int n2 = cArray.length;
        int n3 = asciiValueEncoder.encodeMore(cArray, 0, n2);
        this.writeRawAscii(cArray, 0, n3);
        if (asciiValueEncoder.isCompleted()) {
            xMLValidator.validateAttribute(string2, string3, string, cArray, 0, n3);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 << 1);
        stringBuilder.append(cArray, 0, n3);
        do {
            n3 = asciiValueEncoder.encodeMore(cArray, 0, n2);
            this.writeRawAscii(cArray, 0, n3);
            stringBuilder.append(cArray, 0, n3);
        } while (!asciiValueEncoder.isCompleted());
        this.writeAscii((byte)34);
        String string4 = stringBuilder.toString();
        xMLValidator.validateAttribute(string2, string3, string, string4);
    }

    protected final void flushBuffer() throws IOException {
        if (this.mOutputPtr > 0 && this.mOutputBuffer != null) {
            int n2 = this.mOutputPtr;
            this.mOutputPtr = 0;
            this.mOut.write(this.mOutputBuffer, 0, n2);
        }
    }

    protected final void writeAscii(byte by2) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this.mOutputPtr >= this.mOutputBuffer.length) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = by2;
    }

    protected final void writeAscii(byte by2, byte by3) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this.mOutputPtr + 1 >= this.mOutputBuffer.length) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = by2;
        this.mOutputBuffer[this.mOutputPtr++] = by3;
    }

    protected final void writeAscii(String string) throws IOException {
        byte[] byArray;
        int n2;
        int n3;
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n3 = this.mOutputPtr) + (n2 = string.length()) >= (byArray = this.mOutputBuffer).length) {
            if (n2 > byArray.length) {
                this.writeRaw(string, 0, n2);
                return;
            }
            this.flushBuffer();
            n3 = this.mOutputPtr;
        }
        this.mOutputPtr += n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[n3++] = (byte)string.charAt(i2);
        }
    }

    @Override
    public final void writeRawAscii(char[] cArray, int n2, int n3) throws IOException {
        byte[] byArray;
        int n4;
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n4 = this.mOutputPtr) + n3 >= (byArray = this.mOutputBuffer).length) {
            if (n3 > byArray.length) {
                this.writeRaw(cArray, n2, n3);
                return;
            }
            this.flushBuffer();
            n4 = this.mOutputPtr;
        }
        this.mOutputPtr += n3;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n4 + i2] = (byte)cArray[n2 + i2];
        }
    }

    protected final int writeAsEntity(int n2) throws IOException {
        int n3 = this.mOutputPtr;
        byte[] byArray = this.mOutputBuffer;
        if (n3 + 10 >= byArray.length) {
            this.flushBuffer();
            n3 = this.mOutputPtr;
        }
        byArray[n3++] = 38;
        if (n2 < 256) {
            if (n2 == 38) {
                byArray[n3++] = 97;
                byArray[n3++] = 109;
                byArray[n3++] = 112;
            } else if (n2 == 60) {
                byArray[n3++] = 108;
                byArray[n3++] = 116;
            } else if (n2 == 62) {
                byArray[n3++] = 103;
                byArray[n3++] = 116;
            } else if (n2 == 39) {
                byArray[n3++] = 97;
                byArray[n3++] = 112;
                byArray[n3++] = 111;
                byArray[n3++] = 115;
            } else if (n2 == 34) {
                byArray[n3++] = 113;
                byArray[n3++] = 117;
                byArray[n3++] = 111;
                byArray[n3++] = 116;
            } else {
                byArray[n3++] = 35;
                byArray[n3++] = 120;
                if (n2 >= 16) {
                    int n4 = n2 >> 4;
                    byArray[n3++] = (byte)(n4 < 10 ? 48 + n4 : 87 + n4);
                    n2 &= 0xF;
                }
                byArray[n3++] = (byte)(n2 < 10 ? 48 + n2 : 87 + n2);
            }
        } else {
            byArray[n3++] = 35;
            byArray[n3++] = 120;
            int n5 = 20;
            int n6 = n3;
            do {
                int n7;
                if ((n7 = n2 >> n5 & 0xF) <= 0 && n3 == n6) continue;
                byArray[n3++] = (byte)(n7 < 10 ? 48 + n7 : 87 + n7);
            } while ((n5 -= 4) > 0);
            byArray[n3++] = (byte)((n2 &= 0xF) < 10 ? 48 + n2 : 87 + n2);
        }
        byArray[n3++] = 59;
        this.mOutputPtr = n3;
        return n3;
    }

    protected final void writeName(String string) throws IOException, XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(string, this.mNsAware);
        }
        this.writeRaw(string, 0, string.length());
    }

    protected final void writeNameUnchecked(String string) throws IOException {
        this.writeRaw(string, 0, string.length());
    }

    protected final int calcSurrogate(int n2) throws IOException {
        int n3;
        int n4 = this.mSurrogate;
        this.mSurrogate = 0;
        if (n4 < 55296 || n4 > 56319) {
            this.throwUnpairedSurrogate(n4);
        }
        if (n2 < 56320 || n2 > 57343) {
            this.throwUnpairedSurrogate(n2);
        }
        if ((n3 = 65536 + (n4 - 55296 << 10) + (n2 - 56320)) > 0x10FFFF) {
            throw new IOException("Illegal surrogate character pair, resulting code 0x" + Integer.toHexString(n3) + " above legal XML character range");
        }
        return n3;
    }

    protected final void throwUnpairedSurrogate() throws IOException {
        int n2 = this.mSurrogate;
        this.mSurrogate = 0;
        this.throwUnpairedSurrogate(n2);
    }

    protected final void throwUnpairedSurrogate(int n2) throws IOException {
        this.flush();
        throw new IOException("Unpaired surrogate character (0x" + Integer.toHexString(n2) + ")");
    }

    protected abstract void writeAttrValue(String var1) throws IOException;

    protected abstract void writeAttrValue(char[] var1, int var2, int var3) throws IOException;

    protected abstract int writeCDataContent(String var1) throws IOException;

    protected abstract int writeCDataContent(char[] var1, int var2, int var3) throws IOException;

    protected abstract int writeCommentContent(String var1) throws IOException;

    protected abstract int writePIData(String var1) throws IOException, XMLStreamException;

    protected abstract void writeTextContent(String var1) throws IOException;

    protected abstract void writeTextContent(char[] var1, int var2, int var3) throws IOException;
}

