/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.doubleparser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.doubleparser.FastDoubleMath;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import java.math.BigInteger;

class FftMultiplier {
    public static final double COS_0_25 = Math.cos(0.7853981633974483);
    public static final double SIN_0_25 = Math.sin(0.7853981633974483);
    private static volatile ComplexVector[] ROOTS2_CACHE = new ComplexVector[20];
    private static volatile ComplexVector[] ROOTS3_CACHE = new ComplexVector[20];

    FftMultiplier() {
    }

    static int bitsPerFftPoint(int n2) {
        if (n2 <= 9728) {
            return 19;
        }
        if (n2 <= 18432) {
            return 18;
        }
        if (n2 <= 69632) {
            return 17;
        }
        if (n2 <= 262144) {
            return 16;
        }
        if (n2 <= 983040) {
            return 15;
        }
        if (n2 <= 0x380000) {
            return 14;
        }
        if (n2 <= 0xD00000) {
            return 13;
        }
        if (n2 <= 0x1800000) {
            return 12;
        }
        if (n2 <= 0x5800000) {
            return 11;
        }
        if (n2 <= 0x14000000) {
            return 10;
        }
        if (n2 <= 0x48000000) {
            return 9;
        }
        return 8;
    }

    private static ComplexVector calculateRootsOfUnity(int n2) {
        if (n2 == 1) {
            ComplexVector complexVector = new ComplexVector(1);
            complexVector.real(0, 1.0);
            complexVector.imag(0, 0.0);
            return complexVector;
        }
        ComplexVector complexVector = new ComplexVector(n2);
        complexVector.set(0, 1.0, 0.0);
        double d2 = COS_0_25;
        double d3 = SIN_0_25;
        complexVector.set(n2 / 2, d2, d3);
        double d4 = 1.5707963267948966 / (double)n2;
        for (int i2 = 1; i2 < n2 / 2; ++i2) {
            double d5 = d4 * (double)i2;
            d2 = Math.cos(d5);
            d3 = Math.sin(d5);
            complexVector.set(i2, d2, d3);
            complexVector.set(n2 - i2, d3, d2);
        }
        return complexVector;
    }

    private static void fft(ComplexVector complexVector, ComplexVector[] complexVectorArray) {
        int n2;
        int n3 = complexVector.length;
        int n4 = 31 - Integer.numberOfLeadingZeros(n3);
        MutableComplex mutableComplex = new MutableComplex();
        MutableComplex mutableComplex2 = new MutableComplex();
        MutableComplex mutableComplex3 = new MutableComplex();
        MutableComplex mutableComplex4 = new MutableComplex();
        MutableComplex mutableComplex5 = new MutableComplex();
        MutableComplex mutableComplex6 = new MutableComplex();
        for (n2 = n4; n2 >= 2; n2 -= 2) {
            ComplexVector complexVector2 = complexVectorArray[n2 - 2];
            int n5 = 1 << n2;
            for (int i2 = 0; i2 < n3; i2 += n5) {
                for (int i3 = 0; i3 < n5 / 4; ++i3) {
                    mutableComplex5.set(complexVector2, i3);
                    mutableComplex5.squareInto(mutableComplex6);
                    int n6 = i2 + i3;
                    int n7 = i2 + i3 + n5 / 4;
                    int n8 = i2 + i3 + n5 / 2;
                    int n9 = i2 + i3 + n5 * 3 / 4;
                    complexVector.addInto(n6, complexVector, n7, mutableComplex);
                    mutableComplex.add(complexVector, n8);
                    mutableComplex.add(complexVector, n9);
                    complexVector.subtractTimesIInto(n6, complexVector, n7, mutableComplex2);
                    mutableComplex2.subtract(complexVector, n8);
                    mutableComplex2.addTimesI(complexVector, n9);
                    mutableComplex2.multiplyConjugate(mutableComplex5);
                    complexVector.subtractInto(n6, complexVector, n7, mutableComplex3);
                    mutableComplex3.add(complexVector, n8);
                    mutableComplex3.subtract(complexVector, n9);
                    mutableComplex3.multiplyConjugate(mutableComplex6);
                    complexVector.addTimesIInto(n6, complexVector, n7, mutableComplex4);
                    mutableComplex4.subtract(complexVector, n8);
                    mutableComplex4.subtractTimesI(complexVector, n9);
                    mutableComplex4.multiply(mutableComplex5);
                    mutableComplex.copyInto(complexVector, n6);
                    mutableComplex2.copyInto(complexVector, n7);
                    mutableComplex3.copyInto(complexVector, n8);
                    mutableComplex4.copyInto(complexVector, n9);
                }
            }
        }
        if (n2 > 0) {
            for (int i4 = 0; i4 < n3; i4 += 2) {
                complexVector.copyInto(i4, mutableComplex);
                complexVector.copyInto(i4 + 1, mutableComplex2);
                complexVector.add(i4, mutableComplex2);
                mutableComplex.subtractInto(mutableComplex2, complexVector, i4 + 1);
            }
        }
    }

    private static void fft3(ComplexVector complexVector, ComplexVector complexVector2, ComplexVector complexVector3, int n2, double d2) {
        double d3 = (double)n2 * -0.5 * Math.sqrt(3.0);
        for (int i2 = 0; i2 < complexVector.length; ++i2) {
            double d4 = complexVector.real(i2) + complexVector2.real(i2) + complexVector3.real(i2);
            double d5 = complexVector.imag(i2) + complexVector2.imag(i2) + complexVector3.imag(i2);
            double d6 = d3 * (complexVector3.imag(i2) - complexVector2.imag(i2));
            double d7 = d3 * (complexVector2.real(i2) - complexVector3.real(i2));
            double d8 = 0.5 * (complexVector2.real(i2) + complexVector3.real(i2));
            double d9 = 0.5 * (complexVector2.imag(i2) + complexVector3.imag(i2));
            double d10 = complexVector.real(i2) - d8 + d6;
            double d11 = complexVector.imag(i2) + d7 - d9;
            double d12 = complexVector.real(i2) - d8 - d6;
            double d13 = complexVector.imag(i2) - d7 - d9;
            complexVector.real(i2, d4 * d2);
            complexVector.imag(i2, d5 * d2);
            complexVector2.real(i2, d10 * d2);
            complexVector2.imag(i2, d11 * d2);
            complexVector3.real(i2, d12 * d2);
            complexVector3.imag(i2, d13 * d2);
        }
    }

    private static void fftMixedRadix(ComplexVector complexVector, ComplexVector[] complexVectorArray, ComplexVector complexVector2) {
        int n2;
        int n3 = complexVector.length / 3;
        ComplexVector complexVector3 = new ComplexVector(complexVector, 0, n3);
        ComplexVector complexVector4 = new ComplexVector(complexVector, n3, n3 * 2);
        ComplexVector complexVector5 = new ComplexVector(complexVector, n3 * 2, complexVector.length);
        FftMultiplier.fft3(complexVector3, complexVector4, complexVector5, 1, 1.0);
        MutableComplex mutableComplex = new MutableComplex();
        for (n2 = 0; n2 < complexVector.length / 4; ++n2) {
            mutableComplex.set(complexVector2, n2);
            complexVector4.multiplyConjugate(n2, mutableComplex);
            complexVector5.multiplyConjugate(n2, mutableComplex);
            complexVector5.multiplyConjugate(n2, mutableComplex);
        }
        for (n2 = complexVector.length / 4; n2 < n3; ++n2) {
            mutableComplex.set(complexVector2, n2 - complexVector.length / 4);
            complexVector4.multiplyConjugateTimesI(n2, mutableComplex);
            complexVector5.multiplyConjugateTimesI(n2, mutableComplex);
            complexVector5.multiplyConjugateTimesI(n2, mutableComplex);
        }
        FftMultiplier.fft(complexVector3, complexVectorArray);
        FftMultiplier.fft(complexVector4, complexVectorArray);
        FftMultiplier.fft(complexVector5, complexVectorArray);
    }

    static BigInteger fromFftVector(ComplexVector complexVector, int n2, int n3) {
        assert (n3 <= 25) : n3 + " does not fit into an int with slack";
        int n4 = (int)Math.min((long)complexVector.length, 0x80000000L / (long)n3 + 1L);
        int n5 = (int)(8L * ((long)n4 * (long)n3 + 31L) / 32L);
        byte[] byArray = new byte[n5];
        int n6 = 1 << n3;
        int n7 = n6 - 1;
        int n8 = 32 - n3;
        long l2 = 0L;
        int n9 = byArray.length * 8;
        int n10 = n9 - n3;
        int n11 = 0;
        int n12 = Math.min(Math.max(0, n10 >> 3), byArray.length - 4);
        for (int i2 = 0; i2 <= 1; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                long l3 = Math.round(complexVector.part(i3, i2)) + l2;
                l2 = l3 >> n3;
                int n13 = Math.min(Math.max(0, n10 >> 3), byArray.length - 4);
                n11 >>>= n12 - n13 << 3;
                int n14 = n8 - n10 + (n13 << 3);
                n11 = (int)((long)n11 | (l3 & (long)n7) << n14);
                FastDoubleSwar.writeIntBE(byArray, n13, n11);
                n12 = n13;
                n10 -= n3;
            }
        }
        return new BigInteger(n2, byArray);
    }

    private static ComplexVector[] getRootsOfUnity2(int n2) {
        ComplexVector[] complexVectorArray = new ComplexVector[n2 + 1];
        for (int i2 = n2; i2 >= 0; i2 -= 2) {
            if (i2 < 20) {
                if (ROOTS2_CACHE[i2] == null) {
                    FftMultiplier.ROOTS2_CACHE[i2] = FftMultiplier.calculateRootsOfUnity(1 << i2);
                }
                complexVectorArray[i2] = ROOTS2_CACHE[i2];
                continue;
            }
            complexVectorArray[i2] = FftMultiplier.calculateRootsOfUnity(1 << i2);
        }
        return complexVectorArray;
    }

    private static ComplexVector getRootsOfUnity3(int n2) {
        if (n2 < 20) {
            if (ROOTS3_CACHE[n2] == null) {
                FftMultiplier.ROOTS3_CACHE[n2] = FftMultiplier.calculateRootsOfUnity(3 << n2);
            }
            return ROOTS3_CACHE[n2];
        }
        return FftMultiplier.calculateRootsOfUnity(3 << n2);
    }

    private static void ifft(ComplexVector complexVector, ComplexVector[] complexVectorArray) {
        int n2 = complexVector.length;
        int n3 = 31 - Integer.numberOfLeadingZeros(n2);
        MutableComplex mutableComplex = new MutableComplex();
        MutableComplex mutableComplex2 = new MutableComplex();
        MutableComplex mutableComplex3 = new MutableComplex();
        MutableComplex mutableComplex4 = new MutableComplex();
        MutableComplex mutableComplex5 = new MutableComplex();
        MutableComplex mutableComplex6 = new MutableComplex();
        MutableComplex mutableComplex7 = new MutableComplex();
        MutableComplex mutableComplex8 = new MutableComplex();
        int n4 = 1;
        if (n3 % 2 != 0) {
            for (int i2 = 0; i2 < n2; i2 += 2) {
                complexVector.copyInto(i2 + 1, mutableComplex3);
                complexVector.copyInto(i2, mutableComplex);
                complexVector.add(i2, mutableComplex3);
                mutableComplex.subtractInto(mutableComplex3, complexVector, i2 + 1);
            }
            ++n4;
        }
        MutableComplex mutableComplex9 = new MutableComplex();
        MutableComplex mutableComplex10 = new MutableComplex();
        while (n4 <= n3) {
            ComplexVector complexVector2 = complexVectorArray[n4 - 1];
            int n5 = 1 << n4 + 1;
            for (int i3 = 0; i3 < n2; i3 += n5) {
                for (int i4 = 0; i4 < n5 / 4; ++i4) {
                    mutableComplex9.set(complexVector2, i4);
                    mutableComplex9.squareInto(mutableComplex10);
                    int n6 = i3 + i4;
                    int n7 = i3 + i4 + n5 / 4;
                    int n8 = i3 + i4 + n5 / 2;
                    int n9 = i3 + i4 + n5 * 3 / 4;
                    complexVector.copyInto(n6, mutableComplex);
                    complexVector.multiplyInto(n7, mutableComplex9, mutableComplex2);
                    complexVector.multiplyInto(n8, mutableComplex10, mutableComplex3);
                    complexVector.multiplyConjugateInto(n9, mutableComplex9, mutableComplex4);
                    mutableComplex.addInto(mutableComplex2, mutableComplex5);
                    mutableComplex5.add(mutableComplex3);
                    mutableComplex5.add(mutableComplex4);
                    mutableComplex.addTimesIInto(mutableComplex2, mutableComplex6);
                    mutableComplex6.subtract(mutableComplex3);
                    mutableComplex6.subtractTimesI(mutableComplex4);
                    mutableComplex.subtractInto(mutableComplex2, mutableComplex7);
                    mutableComplex7.add(mutableComplex3);
                    mutableComplex7.subtract(mutableComplex4);
                    mutableComplex.subtractTimesIInto(mutableComplex2, mutableComplex8);
                    mutableComplex8.subtract(mutableComplex3);
                    mutableComplex8.addTimesI(mutableComplex4);
                    mutableComplex5.copyInto(complexVector, n6);
                    mutableComplex6.copyInto(complexVector, n7);
                    mutableComplex7.copyInto(complexVector, n8);
                    mutableComplex8.copyInto(complexVector, n9);
                }
            }
            n4 += 2;
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            complexVector.timesTwoToThe(i5, -n3);
        }
    }

    private static void ifftMixedRadix(ComplexVector complexVector, ComplexVector[] complexVectorArray, ComplexVector complexVector2) {
        int n2;
        int n3 = complexVector.length / 3;
        ComplexVector complexVector3 = new ComplexVector(complexVector, 0, n3);
        ComplexVector complexVector4 = new ComplexVector(complexVector, n3, n3 * 2);
        ComplexVector complexVector5 = new ComplexVector(complexVector, n3 * 2, complexVector.length);
        FftMultiplier.ifft(complexVector3, complexVectorArray);
        FftMultiplier.ifft(complexVector4, complexVectorArray);
        FftMultiplier.ifft(complexVector5, complexVectorArray);
        MutableComplex mutableComplex = new MutableComplex();
        for (n2 = 0; n2 < complexVector.length / 4; ++n2) {
            mutableComplex.set(complexVector2, n2);
            complexVector4.multiply(n2, mutableComplex);
            complexVector5.multiply(n2, mutableComplex);
            complexVector5.multiply(n2, mutableComplex);
        }
        for (n2 = complexVector.length / 4; n2 < n3; ++n2) {
            mutableComplex.set(complexVector2, n2 - complexVector.length / 4);
            complexVector4.multiplyByIAnd(n2, mutableComplex);
            complexVector5.multiplyByIAnd(n2, mutableComplex);
            complexVector5.multiplyByIAnd(n2, mutableComplex);
        }
        FftMultiplier.fft3(complexVector3, complexVector4, complexVector5, -1, 0.3333333333333333);
    }

    static BigInteger multiply(BigInteger bigInteger, BigInteger bigInteger2) {
        int n2;
        assert (bigInteger != null) : "a==null";
        assert (bigInteger2 != null) : "b==null";
        if (bigInteger2.signum() == 0 || bigInteger.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger2 == bigInteger) {
            return FftMultiplier.square(bigInteger2);
        }
        int n3 = bigInteger.bitLength();
        if ((long)n3 + (long)(n2 = bigInteger2.bitLength()) > 0x80000000L) {
            throw new ArithmeticException("BigInteger would overflow supported range");
        }
        if (n3 > 1920 && n2 > 1920 && (n3 > 33220 || n2 > 33220)) {
            return FftMultiplier.multiplyFft(bigInteger, bigInteger2);
        }
        return bigInteger.multiply(bigInteger2);
    }

    static BigInteger multiplyFft(BigInteger bigInteger, BigInteger bigInteger2) {
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray;
        int n6 = bigInteger.signum() * bigInteger2.signum();
        byte[] byArray2 = (bigInteger.signum() < 0 ? bigInteger.negate() : bigInteger).toByteArray();
        int n7 = Math.max(byArray2.length, (byArray = (bigInteger2.signum() < 0 ? bigInteger2.negate() : bigInteger2).toByteArray()).length) * 8;
        int n8 = (n7 + (n5 = FftMultiplier.bitsPerFftPoint(n7)) - 1) / n5 + 1;
        if (n8 < (n4 = (n3 = 1 << (n2 = 32 - Integer.numberOfLeadingZeros(n8 - 1))) * 3 / 4) && n2 > 3) {
            ComplexVector[] complexVectorArray = FftMultiplier.getRootsOfUnity2(n2 - 2);
            ComplexVector complexVector = FftMultiplier.getRootsOfUnity3(n2 - 2);
            ComplexVector complexVector2 = FftMultiplier.getRootsOfUnity3(n2 - 4);
            ComplexVector complexVector3 = FftMultiplier.toFftVector(byArray2, n4, n5);
            complexVector3.applyWeights(complexVector);
            FftMultiplier.fftMixedRadix(complexVector3, complexVectorArray, complexVector2);
            ComplexVector complexVector4 = FftMultiplier.toFftVector(byArray, n4, n5);
            complexVector4.applyWeights(complexVector);
            FftMultiplier.fftMixedRadix(complexVector4, complexVectorArray, complexVector2);
            complexVector3.multiplyPointwise(complexVector4);
            FftMultiplier.ifftMixedRadix(complexVector3, complexVectorArray, complexVector2);
            complexVector3.applyInverseWeights(complexVector);
            return FftMultiplier.fromFftVector(complexVector3, n6, n5);
        }
        ComplexVector[] complexVectorArray = FftMultiplier.getRootsOfUnity2(n2);
        ComplexVector complexVector = FftMultiplier.toFftVector(byArray2, n3, n5);
        complexVector.applyWeights(complexVectorArray[n2]);
        FftMultiplier.fft(complexVector, complexVectorArray);
        ComplexVector complexVector5 = FftMultiplier.toFftVector(byArray, n3, n5);
        complexVector5.applyWeights(complexVectorArray[n2]);
        FftMultiplier.fft(complexVector5, complexVectorArray);
        complexVector.multiplyPointwise(complexVector5);
        FftMultiplier.ifft(complexVector, complexVectorArray);
        complexVector.applyInverseWeights(complexVectorArray[n2]);
        return FftMultiplier.fromFftVector(complexVector, n6, n5);
    }

    static BigInteger square(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return BigInteger.ZERO;
        }
        return bigInteger.bitLength() < 33220 ? bigInteger.multiply(bigInteger) : FftMultiplier.squareFft(bigInteger);
    }

    static BigInteger squareFft(BigInteger bigInteger) {
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray = bigInteger.toByteArray();
        int n6 = byArray.length * 8;
        int n7 = (n6 + (n5 = FftMultiplier.bitsPerFftPoint(n6)) - 1) / n5 + 1;
        if (n7 < (n4 = (n3 = 1 << (n2 = 32 - Integer.numberOfLeadingZeros(n7 - 1))) * 3 / 4)) {
            n7 = n4;
            ComplexVector complexVector = FftMultiplier.toFftVector(byArray, n7, n5);
            ComplexVector[] complexVectorArray = FftMultiplier.getRootsOfUnity2(n2 - 2);
            ComplexVector complexVector2 = FftMultiplier.getRootsOfUnity3(n2 - 2);
            ComplexVector complexVector3 = FftMultiplier.getRootsOfUnity3(n2 - 4);
            complexVector.applyWeights(complexVector2);
            FftMultiplier.fftMixedRadix(complexVector, complexVectorArray, complexVector3);
            complexVector.squarePointwise();
            FftMultiplier.ifftMixedRadix(complexVector, complexVectorArray, complexVector3);
            complexVector.applyInverseWeights(complexVector2);
            return FftMultiplier.fromFftVector(complexVector, 1, n5);
        }
        n7 = n3;
        ComplexVector complexVector = FftMultiplier.toFftVector(byArray, n7, n5);
        ComplexVector[] complexVectorArray = FftMultiplier.getRootsOfUnity2(n2);
        complexVector.applyWeights(complexVectorArray[n2]);
        FftMultiplier.fft(complexVector, complexVectorArray);
        complexVector.squarePointwise();
        FftMultiplier.ifft(complexVector, complexVectorArray);
        complexVector.applyInverseWeights(complexVectorArray[n2]);
        return FftMultiplier.fromFftVector(complexVector, 1, n5);
    }

    static ComplexVector toFftVector(byte[] byArray, int n2, int n3) {
        assert (n3 <= 25) : n3 + " does not fit into an int with slack";
        ComplexVector complexVector = new ComplexVector(n2);
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 4 - byArray.length, byArray.length);
            byArray = byArray2;
        }
        int n4 = 1 << n3;
        int n5 = n4 / 2;
        int n6 = n4 - 1;
        int n7 = 32 - n3;
        int n8 = byArray.length * 8;
        int n9 = 0;
        int n10 = 0;
        for (int i2 = n8 - n3; i2 > -n3; i2 -= n3) {
            int n11 = Math.min(Math.max(0, i2 >> 3), byArray.length - 4);
            int n12 = n7 - i2 + (n11 << 3);
            int n13 = FastDoubleSwar.readIntBE(byArray, n11) >>> n12 & n6;
            n9 = n5 - (n13 += n9) >>> 31;
            complexVector.real(n10, n13 -= n4 & -n9);
            ++n10;
        }
        if (n9 > 0) {
            complexVector.real(n10, n9);
        }
        return complexVector;
    }

    static final class ComplexVector {
        private final double[] a;
        private final int length;
        private final int offset;

        ComplexVector(int n2) {
            this.a = new double[n2 << 1];
            this.length = n2;
            this.offset = 0;
        }

        ComplexVector(ComplexVector complexVector, int n2, int n3) {
            this.length = n3 - n2;
            this.a = complexVector.a;
            this.offset = n2 << 1;
        }

        void add(int n2, MutableComplex mutableComplex) {
            int n3 = this.realIdx(n2);
            this.a[n3] = this.a[n3] + mutableComplex.real;
            int n4 = this.imagIdx(n2);
            this.a[n4] = this.a[n4] + mutableComplex.imag;
        }

        void addInto(int n2, ComplexVector complexVector, int n3, MutableComplex mutableComplex) {
            mutableComplex.real = this.a[this.realIdx(n2)] + complexVector.real(n3);
            mutableComplex.imag = this.a[this.imagIdx(n2)] + complexVector.imag(n3);
        }

        void addTimesIInto(int n2, ComplexVector complexVector, int n3, MutableComplex mutableComplex) {
            mutableComplex.real = this.a[this.realIdx(n2)] - complexVector.imag(n3);
            mutableComplex.imag = this.a[this.imagIdx(n2)] + complexVector.real(n3);
        }

        void applyInverseWeights(ComplexVector complexVector) {
            int n2 = complexVector.offset;
            double[] dArray = complexVector.a;
            int n3 = this.offset + this.length << 1;
            for (int i2 = this.offset; i2 < n3; i2 += 2) {
                double d2 = this.a[i2 + 0];
                double d3 = this.a[i2 + 1];
                this.a[i2] = FastDoubleSwar.fma(d2, dArray[n2 + 0], d3 * dArray[n2 + 1]);
                this.a[i2 + 1] = FastDoubleSwar.fma(-d2, dArray[n2 + 1], d3 * dArray[n2 + 0]);
                n2 += 2;
            }
        }

        void applyWeights(ComplexVector complexVector) {
            int n2 = complexVector.offset;
            double[] dArray = complexVector.a;
            int n3 = this.offset + this.length << 1;
            for (int i2 = this.offset; i2 < n3; i2 += 2) {
                double d2 = this.a[i2 + 0];
                this.a[i2 + 0] = d2 * dArray[n2 + 0];
                this.a[i2 + 1] = d2 * dArray[n2 + 1];
                n2 += 2;
            }
        }

        void copyInto(int n2, MutableComplex mutableComplex) {
            mutableComplex.real = this.a[this.realIdx(n2)];
            mutableComplex.imag = this.a[this.imagIdx(n2)];
        }

        double imag(int n2) {
            return this.a[(n2 << 1) + this.offset + 1];
        }

        void imag(int n2, double d2) {
            this.a[(n2 << 1) + this.offset + 1] = d2;
        }

        private int imagIdx(int n2) {
            return (n2 << 1) + this.offset + 1;
        }

        void multiply(int n2, MutableComplex mutableComplex) {
            int n3 = this.realIdx(n2);
            int n4 = this.imagIdx(n2);
            double d2 = this.a[n3];
            double d3 = this.a[n4];
            this.a[n3] = FastDoubleSwar.fma(d2, mutableComplex.real, -d3 * mutableComplex.imag);
            this.a[n4] = FastDoubleSwar.fma(d2, mutableComplex.imag, d3 * mutableComplex.real);
        }

        void multiplyByIAnd(int n2, MutableComplex mutableComplex) {
            int n3 = this.realIdx(n2);
            int n4 = this.imagIdx(n2);
            double d2 = this.a[n3];
            double d3 = this.a[n4];
            this.a[n3] = FastDoubleSwar.fma(-d2, mutableComplex.imag, -d3 * mutableComplex.real);
            this.a[n4] = FastDoubleSwar.fma(d2, mutableComplex.real, -d3 * mutableComplex.imag);
        }

        void multiplyConjugate(int n2, MutableComplex mutableComplex) {
            int n3 = this.realIdx(n2);
            int n4 = this.imagIdx(n2);
            double d2 = this.a[n3];
            double d3 = this.a[n4];
            this.a[n3] = FastDoubleSwar.fma(d2, mutableComplex.real, d3 * mutableComplex.imag);
            this.a[n4] = FastDoubleSwar.fma(-d2, mutableComplex.imag, d3 * mutableComplex.real);
        }

        void multiplyConjugateInto(int n2, MutableComplex mutableComplex, MutableComplex mutableComplex2) {
            double d2 = this.a[this.realIdx(n2)];
            double d3 = this.a[this.imagIdx(n2)];
            mutableComplex2.real = FastDoubleSwar.fma(d2, mutableComplex.real, d3 * mutableComplex.imag);
            mutableComplex2.imag = FastDoubleSwar.fma(-d2, mutableComplex.imag, d3 * mutableComplex.real);
        }

        void multiplyConjugateTimesI(int n2, MutableComplex mutableComplex) {
            int n3 = this.realIdx(n2);
            int n4 = this.imagIdx(n2);
            double d2 = this.a[n3];
            double d3 = this.a[n4];
            this.a[n3] = FastDoubleSwar.fma(-d2, mutableComplex.imag, d3 * mutableComplex.real);
            this.a[n4] = FastDoubleSwar.fma(-d2, mutableComplex.real, -d3 * mutableComplex.imag);
        }

        void multiplyInto(int n2, MutableComplex mutableComplex, MutableComplex mutableComplex2) {
            double d2 = this.a[this.realIdx(n2)];
            double d3 = this.a[this.imagIdx(n2)];
            mutableComplex2.real = FastDoubleSwar.fma(d2, mutableComplex.real, -d3 * mutableComplex.imag);
            mutableComplex2.imag = FastDoubleSwar.fma(d2, mutableComplex.imag, d3 * mutableComplex.real);
        }

        void multiplyPointwise(ComplexVector complexVector) {
            int n2 = complexVector.offset;
            double[] dArray = complexVector.a;
            int n3 = this.offset + this.length << 1;
            for (int i2 = this.offset; i2 < n3; i2 += 2) {
                double d2 = this.a[i2 + 0];
                double d3 = this.a[i2 + 1];
                double d4 = dArray[n2 + 0];
                double d5 = dArray[n2 + 1];
                this.a[i2 + 0] = FastDoubleSwar.fma(d2, d4, -d3 * d5);
                this.a[i2 + 1] = FastDoubleSwar.fma(d2, d5, d3 * d4);
                n2 += 2;
            }
        }

        double part(int n2, int n3) {
            return this.a[(n2 << 1) + n3];
        }

        double real(int n2) {
            return this.a[(n2 << 1) + this.offset];
        }

        void real(int n2, double d2) {
            this.a[(n2 << 1) + this.offset] = d2;
        }

        private int realIdx(int n2) {
            return (n2 << 1) + this.offset;
        }

        void set(int n2, double d2, double d3) {
            int n3 = this.realIdx(n2);
            this.a[n3] = d2;
            this.a[n3 + 1] = d3;
        }

        void squarePointwise() {
            int n2 = this.offset + this.length << 1;
            for (int i2 = this.offset; i2 < n2; i2 += 2) {
                double d2 = this.a[i2 + 0];
                double d3 = this.a[i2 + 1];
                this.a[i2 + 0] = FastDoubleSwar.fma(d2, d2, -d3 * d3);
                this.a[i2 + 1] = 2.0 * d2 * d3;
            }
        }

        void subtractInto(int n2, ComplexVector complexVector, int n3, MutableComplex mutableComplex) {
            mutableComplex.real = this.a[this.realIdx(n2)] - complexVector.real(n3);
            mutableComplex.imag = this.a[this.imagIdx(n2)] - complexVector.imag(n3);
        }

        void subtractTimesIInto(int n2, ComplexVector complexVector, int n3, MutableComplex mutableComplex) {
            mutableComplex.real = this.a[this.realIdx(n2)] + complexVector.imag(n3);
            mutableComplex.imag = this.a[this.imagIdx(n2)] - complexVector.real(n3);
        }

        void timesTwoToThe(int n2, int n3) {
            int n4 = this.realIdx(n2);
            int n5 = this.imagIdx(n2);
            double d2 = this.a[n4];
            double d3 = this.a[n5];
            this.a[n4] = FastDoubleMath.fastScalb(d2, n3);
            this.a[n5] = FastDoubleMath.fastScalb(d3, n3);
        }
    }

    static final class MutableComplex {
        double real;
        double imag;

        MutableComplex() {
        }

        void add(MutableComplex mutableComplex) {
            this.real += mutableComplex.real;
            this.imag += mutableComplex.imag;
        }

        void add(ComplexVector complexVector, int n2) {
            this.real += complexVector.real(n2);
            this.imag += complexVector.imag(n2);
        }

        void addInto(MutableComplex mutableComplex, MutableComplex mutableComplex2) {
            mutableComplex2.real = this.real + mutableComplex.real;
            mutableComplex2.imag = this.imag + mutableComplex.imag;
        }

        void addTimesI(MutableComplex mutableComplex) {
            this.real -= mutableComplex.imag;
            this.imag += mutableComplex.real;
        }

        void addTimesI(ComplexVector complexVector, int n2) {
            this.real -= complexVector.imag(n2);
            this.imag += complexVector.real(n2);
        }

        void addTimesIInto(MutableComplex mutableComplex, MutableComplex mutableComplex2) {
            mutableComplex2.real = this.real - mutableComplex.imag;
            mutableComplex2.imag = this.imag + mutableComplex.real;
        }

        void copyInto(ComplexVector complexVector, int n2) {
            complexVector.real(n2, this.real);
            complexVector.imag(n2, this.imag);
        }

        void multiply(MutableComplex mutableComplex) {
            double d2 = this.real;
            this.real = FastDoubleSwar.fma(d2, mutableComplex.real, -this.imag * mutableComplex.imag);
            this.imag = FastDoubleSwar.fma(d2, mutableComplex.imag, this.imag * mutableComplex.real);
        }

        void multiplyConjugate(MutableComplex mutableComplex) {
            double d2 = this.real;
            this.real = FastDoubleSwar.fma(d2, mutableComplex.real, this.imag * mutableComplex.imag);
            this.imag = FastDoubleSwar.fma(-d2, mutableComplex.imag, this.imag * mutableComplex.real);
        }

        void set(ComplexVector complexVector, int n2) {
            this.real = complexVector.real(n2);
            this.imag = complexVector.imag(n2);
        }

        void squareInto(MutableComplex mutableComplex) {
            mutableComplex.real = FastDoubleSwar.fma(this.real, this.real, -this.imag * this.imag);
            mutableComplex.imag = 2.0 * this.real * this.imag;
        }

        void subtract(MutableComplex mutableComplex) {
            this.real -= mutableComplex.real;
            this.imag -= mutableComplex.imag;
        }

        void subtract(ComplexVector complexVector, int n2) {
            this.real -= complexVector.real(n2);
            this.imag -= complexVector.imag(n2);
        }

        void subtractInto(MutableComplex mutableComplex, MutableComplex mutableComplex2) {
            mutableComplex2.real = this.real - mutableComplex.real;
            mutableComplex2.imag = this.imag - mutableComplex.imag;
        }

        void subtractInto(MutableComplex mutableComplex, ComplexVector complexVector, int n2) {
            complexVector.real(n2, this.real - mutableComplex.real);
            complexVector.imag(n2, this.imag - mutableComplex.imag);
        }

        void subtractTimesI(MutableComplex mutableComplex) {
            this.real += mutableComplex.imag;
            this.imag -= mutableComplex.real;
        }

        void subtractTimesI(ComplexVector complexVector, int n2) {
            this.real += complexVector.imag(n2);
            this.imag -= complexVector.real(n2);
        }

        void subtractTimesIInto(MutableComplex mutableComplex, MutableComplex mutableComplex2) {
            mutableComplex2.real = this.real + mutableComplex.imag;
            mutableComplex2.imag = this.imag - mutableComplex.real;
        }
    }
}

