/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.SimpleType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_STRING = String.class;
    private static final Class<?> CLS_JSON_NODE = JsonNode.class;
    protected static final BasicBeanDescription STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), AnnotatedClassResolver.createPrimordial(CLS_STRING));
    protected static final BasicBeanDescription BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), AnnotatedClassResolver.createPrimordial(Boolean.TYPE));
    protected static final BasicBeanDescription INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), AnnotatedClassResolver.createPrimordial(Integer.TYPE));
    protected static final BasicBeanDescription LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), AnnotatedClassResolver.createPrimordial(Long.TYPE));
    protected static final BasicBeanDescription OBJECT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Object.class), AnnotatedClassResolver.createPrimordial(CLS_OBJECT));

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(serializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(serializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType, mixInResolver, true));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(deserializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, BeanDescription beanDescription) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, mixInResolver, beanDescription, false));
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(deserializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(mapperConfig, javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mixInResolver));
        }
        return basicBeanDescription;
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl2) {
        AnnotatedClass annotatedClass = this._resolveAnnotatedClass(mapperConfig, javaType, mixInResolver);
        AccessorNamingStrategy accessorNamingStrategy = javaType.isRecordType() ? mapperConfig.getAccessorNaming().forRecord(mapperConfig, annotatedClass) : mapperConfig.getAccessorNaming().forPOJO(mapperConfig, annotatedClass);
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl2, accessorNamingStrategy);
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, BeanDescription beanDescription, boolean bl2) {
        AnnotatedClass annotatedClass = this._resolveAnnotatedClass(mapperConfig, javaType, mixInResolver);
        AccessorNamingStrategy accessorNamingStrategy = mapperConfig.getAccessorNaming().forBuilder(mapperConfig, annotatedClass, beanDescription);
        return this.constructPropertyCollector(mapperConfig, annotatedClass, javaType, bl2, accessorNamingStrategy);
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl2, AccessorNamingStrategy accessorNamingStrategy) {
        return new POJOPropertiesCollector(mapperConfig, bl2, javaType, annotatedClass, accessorNamingStrategy);
    }

    protected BasicBeanDescription _findStdTypeDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_DESC;
            }
            if (clazz == Long.TYPE) {
                return LONG_DESC;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_DESC;
            }
        } else if (ClassUtil.isJDKClass(clazz)) {
            if (clazz == CLS_OBJECT) {
                return OBJECT_DESC;
            }
            if (clazz == CLS_STRING) {
                return STRING_DESC;
            }
            if (clazz == Integer.class) {
                return INT_DESC;
            }
            if (clazz == Long.class) {
                return LONG_DESC;
            }
            if (clazz == Boolean.class) {
                return BOOLEAN_DESC;
            }
        } else if (CLS_JSON_NODE.isAssignableFrom(clazz)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, AnnotatedClassResolver.createPrimordial(clazz));
        }
        return null;
    }

    protected boolean _isStdJDKCollection(JavaType javaType) {
        if (!javaType.isContainerType() || javaType.isArrayType()) {
            return false;
        }
        Class<?> clazz = javaType.getRawClass();
        return ClassUtil.isJDKClass(clazz) && (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz));
    }

    protected BasicBeanDescription _findStdJdkCollectionDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        if (this._isStdJDKCollection(javaType)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mapperConfig));
        }
        return null;
    }

    protected AnnotatedClass _resolveAnnotatedClass(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolve(mapperConfig, javaType, mixInResolver);
    }
}

