/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Ascii;
import com.gradle.maven.extension.internal.dep.com.google.common.base.CharMatcher;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Converter;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"){

        @Override
        String normalizeWord(String string) {
            return Ascii.toLowerCase(string);
        }

        @Override
        String convert(CaseFormat caseFormat, String string) {
            if (caseFormat == LOWER_UNDERSCORE) {
                return string.replace('-', '_');
            }
            if (caseFormat == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(string.replace('-', '_'));
            }
            return super.convert(caseFormat, string);
        }
    }
    ,
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"){

        @Override
        String normalizeWord(String string) {
            return Ascii.toLowerCase(string);
        }

        @Override
        String convert(CaseFormat caseFormat, String string) {
            if (caseFormat == LOWER_HYPHEN) {
                return string.replace('_', '-');
            }
            if (caseFormat == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(string);
            }
            return super.convert(caseFormat, string);
        }
    }
    ,
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String string) {
            return CaseFormat.firstCharOnlyToUpper(string);
        }

        @Override
        String normalizeFirstWord(String string) {
            return Ascii.toLowerCase(string);
        }
    }
    ,
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String string) {
            return CaseFormat.firstCharOnlyToUpper(string);
        }
    }
    ,
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_"){

        @Override
        String normalizeWord(String string) {
            return Ascii.toUpperCase(string);
        }

        @Override
        String convert(CaseFormat caseFormat, String string) {
            if (caseFormat == LOWER_HYPHEN) {
                return Ascii.toLowerCase(string.replace('_', '-'));
            }
            if (caseFormat == LOWER_UNDERSCORE) {
                return Ascii.toLowerCase(string);
            }
            return super.convert(caseFormat, string);
        }
    };

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher charMatcher, String string2) {
        this.wordBoundary = charMatcher;
        this.wordSeparator = string2;
    }

    public final String to(CaseFormat caseFormat, String string) {
        Preconditions.checkNotNull(caseFormat);
        Preconditions.checkNotNull(string);
        return caseFormat == this ? string : this.convert(caseFormat, string);
    }

    String convert(CaseFormat caseFormat, String string) {
        StringBuilder stringBuilder = null;
        int n2 = 0;
        int n3 = -1;
        while (true) {
            ++n3;
            if ((n3 = this.wordBoundary.indexIn(string, n3)) == -1) break;
            if (n2 == 0) {
                stringBuilder = new StringBuilder(string.length() + 4 * caseFormat.wordSeparator.length());
                stringBuilder.append(caseFormat.normalizeFirstWord(string.substring(n2, n3)));
            } else {
                ((StringBuilder)Objects.requireNonNull(stringBuilder)).append(caseFormat.normalizeWord(string.substring(n2, n3)));
            }
            stringBuilder.append(caseFormat.wordSeparator);
            n2 = n3 + this.wordSeparator.length();
        }
        return n2 == 0 ? caseFormat.normalizeFirstWord(string) : ((StringBuilder)Objects.requireNonNull(stringBuilder)).append(caseFormat.normalizeWord(string.substring(n2))).toString();
    }

    public Converter<String, String> converterTo(CaseFormat caseFormat) {
        return new StringConverter(this, caseFormat);
    }

    abstract String normalizeWord(String var1);

    String normalizeFirstWord(String string) {
        return this.normalizeWord(string);
    }

    private static String firstCharOnlyToUpper(String string) {
        return string.isEmpty() ? string : Ascii.toUpperCase(string.charAt(0)) + Ascii.toLowerCase(string.substring(1));
    }

    private static final class StringConverter
    extends Converter<String, String>
    implements Serializable {
        private final CaseFormat sourceFormat;
        private final CaseFormat targetFormat;

        StringConverter(CaseFormat caseFormat, CaseFormat caseFormat2) {
            this.sourceFormat = Preconditions.checkNotNull(caseFormat);
            this.targetFormat = Preconditions.checkNotNull(caseFormat2);
        }

        @Override
        protected String doForward(String string) {
            return this.sourceFormat.to(this.targetFormat, string);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof StringConverter) {
                StringConverter stringConverter = (StringConverter)object;
                return this.sourceFormat.equals((Object)stringConverter.sourceFormat) && this.targetFormat.equals((Object)stringConverter.targetFormat);
            }
            return false;
        }

        public int hashCode() {
            return this.sourceFormat.hashCode() ^ this.targetFormat.hashCode();
        }

        public String toString() {
            return (Object)((Object)this.sourceFormat) + ".converterTo(" + (Object)((Object)this.targetFormat) + ")";
        }
    }
}

