/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.DuplicatedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledDuplicatedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledSlicedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.SwappedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.WrappedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.WrappedCompositeByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.maven.extension.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.RecyclableArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeByteBuf
extends AbstractReferenceCountedByteBuf
implements Iterable<ByteBuf> {
    private static final ByteBuffer EMPTY_NIO_BUFFER = Unpooled.EMPTY_BUFFER.nioBuffer();
    private static final Iterator<ByteBuf> EMPTY_ITERATOR = Collections.emptyList().iterator();
    private final ByteBufAllocator alloc;
    private final boolean direct;
    private final int maxNumComponents;
    private int componentCount;
    private Component[] components;
    private boolean freed;
    static final ByteWrapper<byte[]> BYTE_ARRAY_WRAPPER = new ByteWrapper<byte[]>(){};
    static final ByteWrapper<ByteBuffer> BYTE_BUFFER_WRAPPER = new ByteWrapper<ByteBuffer>(){};
    private Component lastAccessed;

    private CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl2, int n2, int n3) {
        super(Integer.MAX_VALUE);
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        if (n2 < 1) {
            throw new IllegalArgumentException("maxNumComponents: " + n2 + " (expected: >= 1)");
        }
        this.direct = bl2;
        this.maxNumComponents = n2;
        this.components = CompositeByteBuf.newCompArray(n3, n2);
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl2, int n2) {
        this(byteBufAllocator, bl2, n2, 0);
    }

    private static Component[] newCompArray(int n2, int n3) {
        int n4 = Math.min(16, n3);
        return new Component[Math.max(n2, n4)];
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator) {
        super(Integer.MAX_VALUE);
        this.alloc = byteBufAllocator;
        this.direct = false;
        this.maxNumComponents = 0;
        this.components = null;
    }

    public CompositeByteBuf addComponent(boolean bl2, ByteBuf byteBuf) {
        return this.addComponent(bl2, this.componentCount, byteBuf);
    }

    public CompositeByteBuf addComponent(boolean bl2, int n2, ByteBuf byteBuf) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        this.addComponent0(bl2, n2, byteBuf);
        this.consolidateIfNeeded();
        return this;
    }

    private static void checkForOverflow(int n2, int n3) {
        if (n2 + n3 < 0) {
            throw new IllegalArgumentException("Can't increase by " + n3 + " as capacity(" + n2 + ") would overflow " + Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addComponent0(boolean bl2, int n2, ByteBuf byteBuf) {
        assert (byteBuf != null);
        boolean bl3 = false;
        try {
            this.checkComponentIndex(n2);
            Component component = this.newComponent(CompositeByteBuf.ensureAccessible(byteBuf), 0);
            int n3 = component.length();
            CompositeByteBuf.checkForOverflow(this.capacity(), n3);
            this.addComp(n2, component);
            bl3 = true;
            if (n3 > 0 && n2 < this.componentCount - 1) {
                this.updateComponentOffsets(n2);
            } else if (n2 > 0) {
                component.reposition(this.components[n2 - 1].endOffset);
            }
            if (bl2) {
                this.writerIndex += n3;
            }
            int n4 = n2;
            return n4;
        }
        finally {
            if (!bl3) {
                byteBuf.release();
            }
        }
    }

    private static ByteBuf ensureAccessible(ByteBuf byteBuf) {
        if (checkAccessible && !byteBuf.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
        return byteBuf;
    }

    private Component newComponent(ByteBuf byteBuf, int n2) {
        int n3 = byteBuf.readerIndex();
        int n4 = byteBuf.readableBytes();
        ByteBuf byteBuf2 = byteBuf;
        int n5 = n3;
        while (byteBuf2 instanceof WrappedByteBuf || byteBuf2 instanceof SwappedByteBuf) {
            byteBuf2 = byteBuf2.unwrap();
        }
        if (byteBuf2 instanceof AbstractUnpooledSlicedByteBuf) {
            n5 += ((AbstractUnpooledSlicedByteBuf)byteBuf2).idx(0);
            byteBuf2 = byteBuf2.unwrap();
        } else if (byteBuf2 instanceof PooledSlicedByteBuf) {
            n5 += ((PooledSlicedByteBuf)byteBuf2).adjustment;
            byteBuf2 = byteBuf2.unwrap();
        } else if (byteBuf2 instanceof DuplicatedByteBuf || byteBuf2 instanceof PooledDuplicatedByteBuf) {
            byteBuf2 = byteBuf2.unwrap();
        }
        ByteBuf byteBuf3 = byteBuf.capacity() == n4 ? byteBuf : null;
        return new Component(byteBuf.order(ByteOrder.BIG_ENDIAN), n3, byteBuf2.order(ByteOrder.BIG_ENDIAN), n5, n2, n4, byteBuf3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeByteBuf addFlattenedComponents(boolean bl2, ByteBuf byteBuf) {
        int n2;
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        int n3 = byteBuf.readerIndex();
        int n4 = byteBuf.writerIndex();
        if (n3 == n4) {
            byteBuf.release();
            return this;
        }
        if (!(byteBuf instanceof CompositeByteBuf)) {
            this.addComponent0(bl2, this.componentCount, byteBuf);
            this.consolidateIfNeeded();
            return this;
        }
        CompositeByteBuf compositeByteBuf = byteBuf instanceof WrappedCompositeByteBuf ? (CompositeByteBuf)byteBuf.unwrap() : (CompositeByteBuf)byteBuf;
        compositeByteBuf.checkIndex(n3, n4 - n3);
        Component[] componentArray = compositeByteBuf.components;
        int n5 = this.componentCount;
        int n6 = this.writerIndex;
        try {
            int n7 = compositeByteBuf.toComponentIndex0(n3);
            n2 = this.capacity();
            while (true) {
                Component component = componentArray[n7];
                int n8 = component.offset;
                int n9 = Math.max(n3, n8);
                int n10 = Math.min(n4, component.endOffset);
                int n11 = n10 - n9;
                if (n11 > 0) {
                    this.addComp(this.componentCount, new Component(component.srcBuf.retain(), component.srcIdx(n9), component.buf, component.idx(n9), n2, n11, null));
                }
                if (n4 == n10) break;
                n2 += n11;
                ++n7;
            }
            if (bl2) {
                this.writerIndex = n6 + (n4 - n3);
            }
            this.consolidateIfNeeded();
            byteBuf.release();
            byteBuf = null;
            CompositeByteBuf compositeByteBuf2 = this;
            return compositeByteBuf2;
        }
        finally {
            if (byteBuf != null) {
                if (bl2) {
                    this.writerIndex = n6;
                }
                for (n2 = this.componentCount - 1; n2 >= n5; --n2) {
                    this.components[n2].free();
                    this.removeComp(n2);
                }
            }
        }
    }

    private void consolidateIfNeeded() {
        int n2 = this.componentCount;
        if (n2 > this.maxNumComponents) {
            this.consolidate0(0, n2);
        }
    }

    private void checkComponentIndex(int n2) {
        this.ensureAccessible();
        if (n2 < 0 || n2 > this.componentCount) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d (expected: >= 0 && <= numComponents(%d))", n2, this.componentCount));
        }
    }

    private void updateComponentOffsets(int n2) {
        int n3;
        int n4 = this.componentCount;
        if (n4 <= n2) {
            return;
        }
        int n5 = n3 = n2 > 0 ? this.components[n2 - 1].endOffset : 0;
        while (n2 < n4) {
            Component component = this.components[n2];
            component.reposition(n3);
            n3 = component.endOffset;
            ++n2;
        }
    }

    @Override
    public Iterator<ByteBuf> iterator() {
        this.ensureAccessible();
        return this.componentCount == 0 ? EMPTY_ITERATOR : new CompositeByteBufIterator();
    }

    @Override
    protected int forEachByteAsc0(int n2, int n3, ByteProcessor byteProcessor) throws Exception {
        if (n3 <= n2) {
            return -1;
        }
        int n4 = this.toComponentIndex0(n2);
        int n5 = n3 - n2;
        while (n5 > 0) {
            Component component = this.components[n4];
            if (component.offset != component.endOffset) {
                int n6;
                ByteBuf byteBuf = component.buf;
                int n7 = component.idx(n2);
                int n8 = Math.min(n5, component.endOffset - n2);
                int n9 = n6 = byteBuf instanceof AbstractByteBuf ? ((AbstractByteBuf)byteBuf).forEachByteAsc0(n7, n7 + n8, byteProcessor) : byteBuf.forEachByte(n7, n8, byteProcessor);
                if (n6 != -1) {
                    return n6 - component.adjustment;
                }
                n2 += n8;
                n5 -= n8;
            }
            ++n4;
        }
        return -1;
    }

    @Override
    public boolean isDirect() {
        int n2 = this.componentCount;
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.components[i2].buf.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasArray() {
        switch (this.componentCount) {
            case 0: {
                return true;
            }
            case 1: {
                return this.components[0].buf.hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.componentCount) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.components[0].buf.array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        switch (this.componentCount) {
            case 0: {
                return 0;
            }
            case 1: {
                Component component = this.components[0];
                return component.idx(component.buf.arrayOffset());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.components[0].buf.hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public long memoryAddress() {
        switch (this.componentCount) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                Component component = this.components[0];
                return component.buf.memoryAddress() + (long)component.adjustment;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        int n2 = this.componentCount;
        return n2 > 0 ? this.components[n2 - 1].endOffset : 0;
    }

    @Override
    public CompositeByteBuf capacity(int n2) {
        this.checkNewCapacity(n2);
        int n3 = this.componentCount;
        int n4 = this.capacity();
        if (n2 > n4) {
            int n5 = n2 - n4;
            ByteBuf byteBuf = this.allocBuffer(n5).setIndex(0, n5);
            this.addComponent0(false, n3, byteBuf);
            if (this.componentCount >= this.maxNumComponents) {
                this.consolidateIfNeeded();
            }
        } else if (n2 < n4) {
            int n6;
            this.lastAccessed = null;
            int n7 = n4 - n2;
            for (n6 = n3 - 1; n6 >= 0; --n6) {
                Component component = this.components[n6];
                int n8 = component.length();
                if (n7 < n8) {
                    component.endOffset -= n7;
                    ByteBuf byteBuf = component.slice;
                    if (byteBuf == null) break;
                    component.slice = byteBuf.slice(0, component.length());
                    break;
                }
                component.free();
                n7 -= n8;
            }
            this.removeCompRange(n6 + 1, n3);
            if (this.readerIndex() > n2) {
                this.setIndex0(n2, n2);
            } else if (this.writerIndex > n2) {
                this.writerIndex = n2;
            }
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public int numComponents() {
        return this.componentCount;
    }

    private int toComponentIndex0(int n2) {
        int n3;
        int n4 = this.componentCount;
        if (n2 == 0) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.components[n3].endOffset <= 0) continue;
                return n3;
            }
        }
        if (n4 <= 2) {
            return n4 == 1 || n2 < this.components[0].endOffset ? 0 : 1;
        }
        n3 = 0;
        int n5 = n4;
        while (n3 <= n5) {
            int n6 = n3 + n5 >>> 1;
            Component component = this.components[n6];
            if (n2 >= component.endOffset) {
                n3 = n6 + 1;
                continue;
            }
            if (n2 < component.offset) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        throw new Error("should not reach here");
    }

    @Override
    public byte getByte(int n2) {
        Component component = this.findComponent(n2);
        return component.buf.getByte(component.idx(n2));
    }

    @Override
    protected byte _getByte(int n2) {
        Component component = this.findComponent0(n2);
        return component.buf.getByte(component.idx(n2));
    }

    @Override
    protected short _getShort(int n2) {
        Component component = this.findComponent0(n2);
        if (n2 + 2 <= component.endOffset) {
            return component.buf.getShort(component.idx(n2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n2) & 0xFF) << 8 | this._getByte(n2 + 1) & 0xFF);
        }
        return (short)(this._getByte(n2) & 0xFF | (this._getByte(n2 + 1) & 0xFF) << 8);
    }

    @Override
    protected short _getShortLE(int n2) {
        Component component = this.findComponent0(n2);
        if (n2 + 2 <= component.endOffset) {
            return component.buf.getShortLE(component.idx(n2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(n2) & 0xFF | (this._getByte(n2 + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(n2) & 0xFF) << 8 | this._getByte(n2 + 1) & 0xFF);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        Component component = this.findComponent0(n2);
        if (n2 + 3 <= component.endOffset) {
            return component.buf.getUnsignedMedium(component.idx(n2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n2) & 0xFFFF) << 8 | this._getByte(n2 + 2) & 0xFF;
        }
        return this._getShort(n2) & 0xFFFF | (this._getByte(n2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        Component component = this.findComponent0(n2);
        if (n2 + 3 <= component.endOffset) {
            return component.buf.getUnsignedMediumLE(component.idx(n2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n2) & 0xFFFF | (this._getByte(n2 + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(n2) & 0xFFFF) << 8 | this._getByte(n2 + 2) & 0xFF;
    }

    @Override
    protected int _getInt(int n2) {
        Component component = this.findComponent0(n2);
        if (n2 + 4 <= component.endOffset) {
            return component.buf.getInt(component.idx(n2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n2) & 0xFFFF) << 16 | this._getShort(n2 + 2) & 0xFFFF;
        }
        return this._getShort(n2) & 0xFFFF | (this._getShort(n2 + 2) & 0xFFFF) << 16;
    }

    @Override
    protected int _getIntLE(int n2) {
        Component component = this.findComponent0(n2);
        if (n2 + 4 <= component.endOffset) {
            return component.buf.getIntLE(component.idx(n2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n2) & 0xFFFF | (this._getShortLE(n2 + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(n2) & 0xFFFF) << 16 | this._getShortLE(n2 + 2) & 0xFFFF;
    }

    @Override
    protected long _getLong(int n2) {
        Component component = this.findComponent0(n2);
        if (n2 + 8 <= component.endOffset) {
            return component.buf.getLong(component.idx(n2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n2) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n2 + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n2) & 0xFFFFFFFFL | ((long)this._getInt(n2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    protected long _getLongLE(int n2) {
        Component component = this.findComponent0(n2);
        if (n2 + 8 <= component.endOffset) {
            return component.buf.getLongLE(component.idx(n2));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(n2) & 0xFFFFFFFFL | ((long)this._getIntLE(n2 + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(n2) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE(n2 + 4) & 0xFFFFFFFFL;
    }

    @Override
    public CompositeByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex0(n2);
        while (n4 > 0) {
            Component component = this.components[n5];
            int n6 = Math.min(n4, component.endOffset - n2);
            component.buf.getBytes(component.idx(n2), byArray, n3, n6);
            n2 += n6;
            n3 += n6;
            n4 -= n6;
            ++n5;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.remaining();
        this.checkIndex(n2, n4);
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex0(n2);
        try {
            while (n4 > 0) {
                Component component = this.components[n5];
                int n6 = Math.min(n4, component.endOffset - n2);
                byteBuffer.limit(byteBuffer.position() + n6);
                component.buf.getBytes(component.idx(n2), byteBuffer);
                n2 += n6;
                n4 -= n6;
                ++n5;
            }
        }
        finally {
            byteBuffer.limit(n3);
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex0(n2);
        while (n4 > 0) {
            Component component = this.components[n5];
            int n6 = Math.min(n4, component.endOffset - n2);
            component.buf.getBytes(component.idx(n2), byteBuf, n3, n6);
            n2 += n6;
            n3 += n6;
            n4 -= n6;
            ++n5;
        }
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        int n4 = this.nioBufferCount();
        if (n4 == 1) {
            return gatheringByteChannel.write(this.internalNioBuffer(n2, n3));
        }
        long l2 = gatheringByteChannel.write(this.nioBuffers(n2, n3));
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public CompositeByteBuf setByte(int n2, int n3) {
        Component component = this.findComponent(n2);
        component.buf.setByte(component.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        Component component = this.findComponent0(n2);
        component.buf.setByte(component.idx(n2), n3);
    }

    @Override
    public CompositeByteBuf setShort(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShort(n2, n3);
        return this;
    }

    @Override
    protected void _setShort(int n2, int n3) {
        Component component = this.findComponent0(n2);
        if (n2 + 2 <= component.endOffset) {
            component.buf.setShort(component.idx(n2), n3);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(n2, (byte)(n3 >>> 8));
            this._setByte(n2 + 1, (byte)n3);
        } else {
            this._setByte(n2, (byte)n3);
            this._setByte(n2 + 1, (byte)(n3 >>> 8));
        }
    }

    @Override
    public CompositeByteBuf setMedium(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMedium(n2, n3);
        return this;
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        Component component = this.findComponent0(n2);
        if (n2 + 3 <= component.endOffset) {
            component.buf.setMedium(component.idx(n2), n3);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n2, (short)(n3 >> 8));
            this._setByte(n2 + 2, (byte)n3);
        } else {
            this._setShort(n2, (short)n3);
            this._setByte(n2 + 2, (byte)(n3 >>> 16));
        }
    }

    @Override
    public CompositeByteBuf setInt(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setInt(n2, n3);
        return this;
    }

    @Override
    protected void _setInt(int n2, int n3) {
        Component component = this.findComponent0(n2);
        if (n2 + 4 <= component.endOffset) {
            component.buf.setInt(component.idx(n2), n3);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n2, (short)(n3 >>> 16));
            this._setShort(n2 + 2, (short)n3);
        } else {
            this._setShort(n2, (short)n3);
            this._setShort(n2 + 2, (short)(n3 >>> 16));
        }
    }

    @Override
    public CompositeByteBuf setLong(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLong(n2, l2);
        return this;
    }

    @Override
    protected void _setLong(int n2, long l2) {
        Component component = this.findComponent0(n2);
        if (n2 + 8 <= component.endOffset) {
            component.buf.setLong(component.idx(n2), l2);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this._setInt(n2, (int)(l2 >>> 32));
            this._setInt(n2 + 4, (int)l2);
        } else {
            this._setInt(n2, (int)l2);
            this._setInt(n2 + 4, (int)(l2 >>> 32));
        }
    }

    @Override
    public CompositeByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex0(n2);
        while (n4 > 0) {
            Component component = this.components[n5];
            int n6 = Math.min(n4, component.endOffset - n2);
            component.buf.setBytes(component.idx(n2), byArray, n3, n6);
            n2 += n6;
            n3 += n6;
            n4 -= n6;
            ++n5;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.remaining();
        this.checkIndex(n2, n4);
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex0(n2);
        try {
            while (n4 > 0) {
                Component component = this.components[n5];
                int n6 = Math.min(n4, component.endOffset - n2);
                byteBuffer.limit(byteBuffer.position() + n6);
                component.buf.setBytes(component.idx(n2), byteBuffer);
                n2 += n6;
                n4 -= n6;
                ++n5;
            }
        }
        finally {
            byteBuffer.limit(n3);
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex0(n2);
        while (n4 > 0) {
            Component component = this.components[n5];
            int n6 = Math.min(n4, component.endOffset - n2);
            component.buf.setBytes(component.idx(n2), byteBuf, n3, n6);
            n2 += n6;
            n3 += n6;
            n4 -= n6;
            ++n5;
        }
        return this;
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return scatteringByteChannel.read(EMPTY_NIO_BUFFER);
        }
        int n4 = this.toComponentIndex0(n2);
        int n5 = 0;
        do {
            Component component = this.components[n4];
            int n6 = Math.min(n3, component.endOffset - n2);
            if (n6 == 0) {
                ++n4;
                continue;
            }
            int n7 = component.buf.setBytes(component.idx(n2), scatteringByteChannel, n6);
            if (n7 == 0) break;
            if (n7 < 0) {
                if (n5 != 0) break;
                return -1;
            }
            n2 += n7;
            n3 -= n7;
            n5 += n7;
            if (n7 != n6) continue;
            ++n4;
        } while (n3 > 0);
        return n5;
    }

    public ByteBuf internalComponent(int n2) {
        this.checkComponentIndex(n2);
        return this.components[n2].slice();
    }

    private Component findComponent(int n2) {
        Component component = this.lastAccessed;
        if (component != null && n2 >= component.offset && n2 < component.endOffset) {
            this.ensureAccessible();
            return component;
        }
        this.checkIndex(n2);
        return this.findIt(n2);
    }

    private Component findComponent0(int n2) {
        Component component = this.lastAccessed;
        if (component != null && n2 >= component.offset && n2 < component.endOffset) {
            return component;
        }
        return this.findIt(n2);
    }

    private Component findIt(int n2) {
        int n3 = 0;
        int n4 = this.componentCount;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            Component component = this.components[n5];
            if (component == null) {
                throw new IllegalStateException("No component found for offset. Composite buffer layout might be outdated, e.g. from a discardReadBytes call.");
            }
            if (n2 >= component.endOffset) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 < component.offset) {
                n4 = n5 - 1;
                continue;
            }
            this.lastAccessed = component;
            return component;
        }
        throw new Error("should not reach here");
    }

    @Override
    public int nioBufferCount() {
        int n2 = this.componentCount;
        switch (n2) {
            case 0: {
                return 1;
            }
            case 1: {
                return this.components[0].buf.nioBufferCount();
            }
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.components[i2].buf.nioBufferCount();
        }
        return n3;
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                return this.components[0].internalNioBuffer(n2, n3);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        Comparable<ByteBuf> comparable;
        ByteBuffer[] byteBufferArray;
        this.checkIndex(n2, n3);
        switch (this.componentCount) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                byteBufferArray = this.components[0];
                comparable = byteBufferArray.buf;
                if (((ByteBuf)comparable).nioBufferCount() != 1) break;
                return ((ByteBuf)comparable).nioBuffer(byteBufferArray.idx(n2), n3);
            }
        }
        byteBufferArray = this.nioBuffers(n2, n3);
        if (byteBufferArray.length == 1) {
            return byteBufferArray[0];
        }
        comparable = ByteBuffer.allocate(n3).order(this.order());
        for (ByteBuffer byteBuffer : byteBufferArray) {
            ((ByteBuffer)comparable).put(byteBuffer);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return new ByteBuffer[]{EMPTY_NIO_BUFFER};
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(this.componentCount);
        try {
            ByteBuffer[] byteBufferArray;
            int n4 = this.toComponentIndex0(n2);
            while (n3 > 0) {
                byteBufferArray = this.components[n4];
                ByteBuf byteBuf = byteBufferArray.buf;
                int n5 = Math.min(n3, byteBufferArray.endOffset - n2);
                switch (byteBuf.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        recyclableArrayList.add(byteBuf.nioBuffer(byteBufferArray.idx(n2), n5));
                        break;
                    }
                    default: {
                        Collections.addAll(recyclableArrayList, byteBuf.nioBuffers(byteBufferArray.idx(n2), n5));
                    }
                }
                n2 += n5;
                n3 -= n5;
                ++n4;
            }
            byteBufferArray = recyclableArrayList.toArray(EmptyArrays.EMPTY_BYTE_BUFFERS);
            return byteBufferArray;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    private void consolidate0(int n2, int n3) {
        if (n3 <= 1) {
            return;
        }
        int n4 = n2 + n3;
        int n5 = n2 != 0 ? this.components[n2].offset : 0;
        int n6 = this.components[n4 - 1].endOffset - n5;
        ByteBuf byteBuf = this.allocBuffer(n6);
        for (int i2 = n2; i2 < n4; ++i2) {
            this.components[i2].transferTo(byteBuf);
        }
        this.lastAccessed = null;
        this.removeCompRange(n2 + 1, n4);
        this.components[n2] = this.newComponent(byteBuf, 0);
        if (n2 != 0 || n3 != this.componentCount) {
            this.updateComponentOffsets(n2);
        }
    }

    public CompositeByteBuf discardReadComponents() {
        int n2;
        this.ensureAccessible();
        int n3 = this.readerIndex();
        if (n3 == 0) {
            return this;
        }
        int n4 = this.writerIndex();
        if (n3 == n4 && n4 == this.capacity()) {
            int n5 = this.componentCount;
            for (int i2 = 0; i2 < n5; ++i2) {
                this.components[i2].free();
            }
            this.lastAccessed = null;
            this.clearComps();
            this.setIndex(0, 0);
            this.adjustMarkers(n3);
            return this;
        }
        Component component = null;
        int n6 = this.componentCount;
        for (n2 = 0; n2 < n6; ++n2) {
            component = this.components[n2];
            if (component.endOffset > n3) break;
            component.free();
        }
        if (n2 == 0) {
            return this;
        }
        Component component2 = this.lastAccessed;
        if (component2 != null && component2.endOffset <= n3) {
            this.lastAccessed = null;
        }
        this.removeCompRange(0, n2);
        int n7 = component.offset;
        this.updateComponentOffsets(0);
        this.setIndex(n3 - n7, n4 - n7);
        this.adjustMarkers(n7);
        return this;
    }

    private ByteBuf allocBuffer(int n2) {
        return this.direct ? this.alloc().directBuffer(n2) : this.alloc().heapBuffer(n2);
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.componentCount + ')';
    }

    @Override
    public CompositeByteBuf readerIndex(int n2) {
        super.readerIndex(n2);
        return this;
    }

    @Override
    public CompositeByteBuf writerIndex(int n2) {
        super.writerIndex(n2);
        return this;
    }

    @Override
    public CompositeByteBuf setIndex(int n2, int n3) {
        super.setIndex(n2, n3);
        return this;
    }

    @Override
    public CompositeByteBuf clear() {
        super.clear();
        return this;
    }

    @Override
    public CompositeByteBuf markReaderIndex() {
        super.markReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf resetReaderIndex() {
        super.resetReaderIndex();
        return this;
    }

    @Override
    public CompositeByteBuf markWriterIndex() {
        super.markWriterIndex();
        return this;
    }

    @Override
    public CompositeByteBuf ensureWritable(int n2) {
        super.ensureWritable(n2);
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n2, byte[] byArray) {
        return this.getBytes(n2, byArray, 0, byArray.length);
    }

    @Override
    public CompositeByteBuf setBytes(int n2, byte[] byArray) {
        return this.setBytes(n2, byArray, 0, byArray.length);
    }

    @Override
    public CompositeByteBuf setZero(int n2, int n3) {
        super.setZero(n2, n3);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf) {
        super.readBytes(byteBuf, byteBuf.writableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n2) {
        super.readBytes(byteBuf, n2);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        super.readBytes(byteBuf, n2, n3);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray) {
        super.readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray, int n2, int n3) {
        super.readBytes(byArray, n2, n3);
        return this;
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuffer byteBuffer) {
        super.readBytes(byteBuffer);
        return this;
    }

    @Override
    public CompositeByteBuf skipBytes(int n2) {
        super.skipBytes(n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBoolean(boolean bl2) {
        this.writeByte(bl2 ? 1 : 0);
        return this;
    }

    @Override
    public CompositeByteBuf writeByte(int n2) {
        this.ensureWritable0(1);
        this._setByte(this.writerIndex++, n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeShort(int n2) {
        super.writeShort(n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeMedium(int n2) {
        super.writeMedium(n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeInt(int n2) {
        super.writeInt(n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeLong(long l2) {
        super.writeLong(l2);
        return this;
    }

    @Override
    public CompositeByteBuf writeChar(int n2) {
        super.writeShort(n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeFloat(float f2) {
        super.writeInt(Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public CompositeByteBuf writeDouble(double d2) {
        super.writeLong(Double.doubleToRawLongBits(d2));
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf) {
        super.writeBytes(byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        super.writeBytes(byteBuf, n2);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        super.writeBytes(byteBuf, n2, n3);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray) {
        super.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        super.writeBytes(byArray, n2, n3);
        return this;
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuffer byteBuffer) {
        super.writeBytes(byteBuffer);
        return this;
    }

    @Override
    public CompositeByteBuf retain() {
        super.retain();
        return this;
    }

    @Override
    public CompositeByteBuf touch(Object object) {
        return this;
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex(), this.readableBytes());
    }

    @Override
    public CompositeByteBuf discardSomeReadBytes() {
        return this.discardReadComponents();
    }

    @Override
    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        int n2 = this.componentCount;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.components[i2].free();
        }
    }

    @Override
    boolean isAccessible() {
        return !this.freed;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    private void clearComps() {
        this.removeCompRange(0, this.componentCount);
    }

    private void removeComp(int n2) {
        this.removeCompRange(n2, n2 + 1);
    }

    private void removeCompRange(int n2, int n3) {
        int n4;
        if (n2 >= n3) {
            return;
        }
        int n5 = this.componentCount;
        assert (n2 >= 0 && n3 <= n5);
        if (n3 < n5) {
            System.arraycopy(this.components, n3, this.components, n2, n5 - n3);
        }
        for (int i2 = n4 = n5 - n3 + n2; i2 < n5; ++i2) {
            this.components[i2] = null;
        }
        this.componentCount = n4;
    }

    private void addComp(int n2, Component component) {
        this.shiftComps(n2, 1);
        this.components[n2] = component;
    }

    private void shiftComps(int n2, int n3) {
        int n4 = this.componentCount;
        int n5 = n4 + n3;
        assert (n2 >= 0 && n2 <= n4 && n3 > 0);
        if (n5 > this.components.length) {
            Component[] componentArray;
            int n6 = Math.max(n4 + (n4 >> 1), n5);
            if (n2 == n4) {
                componentArray = (Component[])Arrays.copyOf(this.components, n6, Component[].class);
            } else {
                componentArray = new Component[n6];
                if (n2 > 0) {
                    System.arraycopy(this.components, 0, componentArray, 0, n2);
                }
                if (n2 < n4) {
                    System.arraycopy(this.components, n2, componentArray, n2 + n3, n4 - n2);
                }
            }
            this.components = componentArray;
        } else if (n2 < n4) {
            System.arraycopy(this.components, n2, this.components, n2 + n3, n4 - n2);
        }
        this.componentCount = n5;
    }

    private final class CompositeByteBufIterator
    implements Iterator<ByteBuf> {
        private final int size;
        private int index;

        private CompositeByteBufIterator() {
            this.size = CompositeByteBuf.this.numComponents();
        }

        @Override
        public boolean hasNext() {
            return this.size > this.index;
        }

        @Override
        public ByteBuf next() {
            if (this.size != CompositeByteBuf.this.numComponents()) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return CompositeByteBuf.this.components[this.index++].slice();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-Only");
        }
    }

    private static final class Component {
        final ByteBuf srcBuf;
        final ByteBuf buf;
        int srcAdjustment;
        int adjustment;
        int offset;
        int endOffset;
        private ByteBuf slice;

        Component(ByteBuf byteBuf, int n2, ByteBuf byteBuf2, int n3, int n4, int n5, ByteBuf byteBuf3) {
            this.srcBuf = byteBuf;
            this.srcAdjustment = n2 - n4;
            this.buf = byteBuf2;
            this.adjustment = n3 - n4;
            this.offset = n4;
            this.endOffset = n4 + n5;
            this.slice = byteBuf3;
        }

        int srcIdx(int n2) {
            return n2 + this.srcAdjustment;
        }

        int idx(int n2) {
            return n2 + this.adjustment;
        }

        int length() {
            return this.endOffset - this.offset;
        }

        void reposition(int n2) {
            int n3 = n2 - this.offset;
            this.endOffset += n3;
            this.srcAdjustment -= n3;
            this.adjustment -= n3;
            this.offset = n2;
        }

        void transferTo(ByteBuf byteBuf) {
            byteBuf.writeBytes(this.buf, this.idx(this.offset), this.length());
            this.free();
        }

        ByteBuf slice() {
            ByteBuf byteBuf = this.slice;
            if (byteBuf == null) {
                this.slice = byteBuf = this.srcBuf.slice(this.srcIdx(this.offset), this.length());
            }
            return byteBuf;
        }

        ByteBuffer internalNioBuffer(int n2, int n3) {
            return this.srcBuf.internalNioBuffer(this.srcIdx(n2), n3);
        }

        void free() {
            this.slice = null;
            this.srcBuf.release();
        }
    }

    static interface ByteWrapper<T> {
    }
}

