/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel.nio;

import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelException;
import com.gradle.maven.extension.internal.dep.io.netty.channel.EventLoopTaskQueueFactory;
import com.gradle.maven.extension.internal.dep.io.netty.channel.SelectStrategy;
import com.gradle.maven.extension.internal.dep.io.netty.channel.SingleThreadEventLoop;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.AbstractNioChannel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.NioEventLoopGroup;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.NioTask;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.SelectedSelectionKeySet;
import com.gradle.maven.extension.internal.dep.io.netty.channel.nio.SelectedSelectionKeySetSelector;
import com.gradle.maven.extension.internal.dep.io.netty.util.IntSupplier;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.RejectedExecutionHandler;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ReflectionUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public final class NioEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger;
    private static final boolean DISABLE_KEY_SET_OPTIMIZATION;
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        @Override
        public int get() throws Exception {
            return NioEventLoop.this.selectNow();
        }
    };
    private Selector selector;
    private Selector unwrappedSelector;
    private SelectedSelectionKeySet selectedKeys;
    private final SelectorProvider provider;
    private final AtomicLong nextWakeupNanos = new AtomicLong(-1L);
    private final SelectStrategy selectStrategy;
    private volatile int ioRatio = 50;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    NioEventLoop(NioEventLoopGroup nioEventLoopGroup, Executor executor, SelectorProvider selectorProvider, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory, EventLoopTaskQueueFactory eventLoopTaskQueueFactory2) {
        super(nioEventLoopGroup, executor, false, NioEventLoop.newTaskQueue(eventLoopTaskQueueFactory), NioEventLoop.newTaskQueue(eventLoopTaskQueueFactory2), rejectedExecutionHandler);
        this.provider = ObjectUtil.checkNotNull(selectorProvider, "selectorProvider");
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "selectStrategy");
        SelectorTuple selectorTuple = this.openSelector();
        this.selector = selectorTuple.selector;
        this.unwrappedSelector = selectorTuple.unwrappedSelector;
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        if (eventLoopTaskQueueFactory == null) {
            return NioEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    private SelectorTuple openSelector() {
        AbstractSelector abstractSelector;
        try {
            abstractSelector = this.provider.openSelector();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to open a new selector", iOException);
        }
        if (DISABLE_KEY_SET_OPTIMIZATION) {
            return new SelectorTuple(abstractSelector);
        }
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return Class.forName("sun.nio.ch.SelectorImpl", false, PlatformDependent.getSystemClassLoader());
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }
        });
        if (!(object instanceof Class) || !((Class)object).isAssignableFrom(abstractSelector.getClass())) {
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                logger.trace("failed to instrument a special java.util.Set into: {}", abstractSelector, throwable);
            }
            return new SelectorTuple(abstractSelector);
        }
        final Class clazz = (Class)object;
        final SelectedSelectionKeySet selectedSelectionKeySet = new SelectedSelectionKeySet();
        Object object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Throwable throwable;
                    Field field = clazz.getDeclaredField("selectedKeys");
                    Field field2 = clazz.getDeclaredField("publicSelectedKeys");
                    if (PlatformDependent.javaVersion() >= 9 && PlatformDependent.hasUnsafe()) {
                        long l2 = PlatformDependent.objectFieldOffset(field);
                        long l3 = PlatformDependent.objectFieldOffset(field2);
                        if (l2 != -1L && l3 != -1L) {
                            PlatformDependent.putObject(abstractSelector, l2, selectedSelectionKeySet);
                            PlatformDependent.putObject(abstractSelector, l3, selectedSelectionKeySet);
                            return null;
                        }
                    }
                    if ((throwable = ReflectionUtil.trySetAccessible(field, true)) != null) {
                        return throwable;
                    }
                    throwable = ReflectionUtil.trySetAccessible(field2, true);
                    if (throwable != null) {
                        return throwable;
                    }
                    field.set(abstractSelector, selectedSelectionKeySet);
                    field2.set(abstractSelector, selectedSelectionKeySet);
                    return null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return noSuchFieldException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return illegalAccessException;
                }
            }
        });
        if (object2 instanceof Exception) {
            this.selectedKeys = null;
            Exception exception = (Exception)object2;
            logger.trace("failed to instrument a special java.util.Set into: {}", abstractSelector, exception);
            return new SelectorTuple(abstractSelector);
        }
        this.selectedKeys = selectedSelectionKeySet;
        logger.trace("instrumented a special java.util.Set into: {}", abstractSelector);
        return new SelectorTuple(abstractSelector, new SelectedSelectionKeySetSelector(abstractSelector, selectedSelectionKeySet));
    }

    private static Queue<Runnable> newTaskQueue0(int n2) {
        return n2 == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(n2);
    }

    public void rebuildSelector() {
        if (!this.inEventLoop()) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    NioEventLoop.this.rebuildSelector0();
                }
            });
            return;
        }
        this.rebuildSelector0();
    }

    private void rebuildSelector0() {
        int n2;
        block11: {
            SelectorTuple selectorTuple;
            Selector selector = this.selector;
            if (selector == null) {
                return;
            }
            try {
                selectorTuple = this.openSelector();
            }
            catch (Exception exception) {
                logger.warn("Failed to create a new Selector.", exception);
                return;
            }
            n2 = 0;
            for (SelectionKey selectionKey : selector.keys()) {
                Object object;
                Object object2 = selectionKey.attachment();
                try {
                    if (!selectionKey.isValid() || selectionKey.channel().keyFor(selectorTuple.unwrappedSelector) != null) continue;
                    int n3 = selectionKey.interestOps();
                    selectionKey.cancel();
                    object = selectionKey.channel().register(selectorTuple.unwrappedSelector, n3, object2);
                    if (object2 instanceof AbstractNioChannel) {
                        ((AbstractNioChannel)object2).selectionKey = object;
                    }
                    ++n2;
                }
                catch (Exception exception) {
                    logger.warn("Failed to re-register a Channel to the new Selector.", exception);
                    if (object2 instanceof AbstractNioChannel) {
                        object = (AbstractNioChannel)object2;
                        ((AbstractNioChannel)object).unsafe().close(((AbstractNioChannel)object).unsafe().voidPromise());
                        continue;
                    }
                    object = (NioTask)object2;
                    NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)object, selectionKey, exception);
                }
            }
            this.selector = selectorTuple.selector;
            this.unwrappedSelector = selectorTuple.unwrappedSelector;
            try {
                selector.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn("Failed to close the old Selector.", throwable);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Migrated " + n2 + " channel(s) to the new Selector.");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[SWITCH], 17[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean unexpectedSelectorWakeup(int n2) {
        if (Thread.interrupted()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Selector.select() returned prematurely because Thread.currentThread().interrupt() was called. Use NioEventLoop.shutdownGracefully() to shutdown the NioEventLoop.");
            }
            return true;
        }
        if (SELECTOR_AUTO_REBUILD_THRESHOLD > 0 && n2 >= SELECTOR_AUTO_REBUILD_THRESHOLD) {
            logger.warn("Selector.select() returned prematurely {} times in a row; rebuilding Selector {}.", (Object)n2, (Object)this.selector);
            this.rebuildSelector();
            return true;
        }
        return false;
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processSelectedKeys() {
        if (this.selectedKeys != null) {
            this.processSelectedKeysOptimized();
        } else {
            this.processSelectedKeysPlain(this.selector.selectedKeys());
        }
    }

    @Override
    protected void cleanup() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
        }
    }

    void cancel(SelectionKey selectionKey) {
        selectionKey.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.needsToSelectAgain = true;
        }
    }

    private void processSelectedKeysPlain(Set<SelectionKey> set) {
        if (set.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> iterator = set.iterator();
        while (true) {
            SelectionKey selectionKey = iterator.next();
            Object object = selectionKey.attachment();
            iterator.remove();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                NioTask nioTask = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, nioTask);
            }
            if (!iterator.hasNext()) break;
            if (!this.needsToSelectAgain) continue;
            this.selectAgain();
            set = this.selector.selectedKeys();
            if (set.isEmpty()) break;
            iterator = set.iterator();
        }
    }

    private void processSelectedKeysOptimized() {
        for (int i2 = 0; i2 < this.selectedKeys.size; ++i2) {
            SelectionKey selectionKey = this.selectedKeys.keys[i2];
            this.selectedKeys.keys[i2] = null;
            Object object = selectionKey.attachment();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                NioTask nioTask = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, nioTask);
            }
            if (!this.needsToSelectAgain) continue;
            this.selectedKeys.reset(i2 + 1);
            this.selectAgain();
            i2 = -1;
        }
    }

    private void processSelectedKey(SelectionKey selectionKey, AbstractNioChannel abstractNioChannel) {
        AbstractNioChannel.NioUnsafe nioUnsafe = abstractNioChannel.unsafe();
        if (!selectionKey.isValid()) {
            NioEventLoop nioEventLoop;
            try {
                nioEventLoop = abstractNioChannel.eventLoop();
            }
            catch (Throwable throwable) {
                return;
            }
            if (nioEventLoop == this) {
                nioUnsafe.close(nioUnsafe.voidPromise());
            }
            return;
        }
        try {
            int n2 = selectionKey.readyOps();
            if ((n2 & 8) != 0) {
                int n3 = selectionKey.interestOps();
                selectionKey.interestOps(n3 &= 0xFFFFFFF7);
                nioUnsafe.finishConnect();
            }
            if ((n2 & 4) != 0) {
                nioUnsafe.forceFlush();
            }
            if ((n2 & 0x11) != 0 || n2 == 0) {
                nioUnsafe.read();
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            nioUnsafe.close(nioUnsafe.voidPromise());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSelectedKey(SelectionKey selectionKey, NioTask<SelectableChannel> nioTask) {
        int n2 = 0;
        try {
            nioTask.channelReady(selectionKey.channel(), selectionKey);
            n2 = 1;
        }
        catch (Exception exception) {
            try {
                selectionKey.cancel();
                NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, exception);
                n2 = 2;
            }
            catch (Throwable throwable) {
                switch (n2) {
                    case 0: {
                        selectionKey.cancel();
                        NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                        break;
                    }
                    case 1: {
                        if (selectionKey.isValid()) break;
                        NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                        break;
                    }
                }
                throw throwable;
            }
            switch (n2) {
                case 0: {
                    selectionKey.cancel();
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                    break;
                }
                case 1: {
                    if (!selectionKey.isValid()) {
                        NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                        break;
                    }
                }
            }
        }
        switch (n2) {
            case 0: {
                selectionKey.cancel();
                NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                break;
            }
            case 1: {
                if (!selectionKey.isValid()) {
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                }
                break;
            }
        }
    }

    private void closeAll() {
        this.selectAgain();
        Set<SelectionKey> set = this.selector.keys();
        ArrayList<AbstractNioChannel> arrayList = new ArrayList<AbstractNioChannel>(set.size());
        for (SelectionKey object : set) {
            Object object2 = object.attachment();
            if (object2 instanceof AbstractNioChannel) {
                arrayList.add((AbstractNioChannel)object2);
                continue;
            }
            object.cancel();
            NioTask nioTask = (NioTask)object2;
            NioEventLoop.invokeChannelUnregistered(nioTask, object, null);
        }
        for (AbstractNioChannel abstractNioChannel : arrayList) {
            abstractNioChannel.unsafe().close(abstractNioChannel.unsafe().voidPromise());
        }
    }

    private static void invokeChannelUnregistered(NioTask<SelectableChannel> nioTask, SelectionKey selectionKey, Throwable throwable) {
        try {
            nioTask.channelUnregistered(selectionKey.channel(), throwable);
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while running NioTask.channelUnregistered()", exception);
        }
    }

    @Override
    protected void wakeup(boolean bl2) {
        if (!bl2 && this.nextWakeupNanos.getAndSet(-1L) != -1L) {
            this.selector.wakeup();
        }
    }

    @Override
    protected boolean beforeScheduledTaskSubmitted(long l2) {
        return l2 < this.nextWakeupNanos.get();
    }

    @Override
    protected boolean afterScheduledTaskSubmitted(long l2) {
        return l2 < this.nextWakeupNanos.get();
    }

    Selector unwrappedSelector() {
        return this.unwrappedSelector;
    }

    int selectNow() throws IOException {
        return this.selector.selectNow();
    }

    private int select(long l2) throws IOException {
        if (l2 == Long.MAX_VALUE) {
            return this.selector.select();
        }
        long l3 = NioEventLoop.deadlineToDelayNanos(l2 + 995000L) / 1000000L;
        return l3 <= 0L ? this.selector.selectNow() : this.selector.select(l3);
    }

    private void selectAgain() {
        this.needsToSelectAgain = false;
        try {
            this.selector.selectNow();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to update SelectionKeys.", throwable);
        }
    }

    static {
        int n2;
        logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
        DISABLE_KEY_SET_OPTIMIZATION = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.noKeySetOptimization", false);
        if (PlatformDependent.javaVersion() < 7) {
            String string = "sun.nio.ch.bugLevel";
            String string2 = SystemPropertyUtil.get("sun.nio.ch.bugLevel");
            if (string2 == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            System.setProperty("sun.nio.ch.bugLevel", "");
                            return null;
                        }
                    });
                }
                catch (SecurityException securityException) {
                    logger.debug("Unable to get/set System Property: sun.nio.ch.bugLevel", securityException);
                }
            }
        }
        if ((n2 = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.selectorAutoRebuildThreshold", 512)) < 3) {
            n2 = 0;
        }
        SELECTOR_AUTO_REBUILD_THRESHOLD = n2;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noKeySetOptimization: {}", (Object)DISABLE_KEY_SET_OPTIMIZATION);
            logger.debug("-Dio.netty.selectorAutoRebuildThreshold: {}", (Object)SELECTOR_AUTO_REBUILD_THRESHOLD);
        }
    }

    private static final class SelectorTuple {
        final Selector unwrappedSelector;
        final Selector selector;

        SelectorTuple(Selector selector) {
            this.unwrappedSelector = selector;
            this.selector = selector;
        }

        SelectorTuple(Selector selector, Selector selector2) {
            this.unwrappedSelector = selector;
            this.selector = selector2;
        }
    }
}

