/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.base64.Base64;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PemReader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PemReader.class);
    private static final Pattern CERT_HEADER = Pattern.compile("-+BEGIN\\s[^-\\r\\n]*CERTIFICATE[^-\\r\\n]*-+(?:\\s|\\r|\\n)+");
    private static final Pattern CERT_FOOTER = Pattern.compile("-+END\\s[^-\\r\\n]*CERTIFICATE[^-\\r\\n]*-+(?:\\s|\\r|\\n)*");
    private static final Pattern KEY_HEADER = Pattern.compile("-+BEGIN\\s[^-\\r\\n]*PRIVATE\\s+KEY[^-\\r\\n]*-+(?:\\s|\\r|\\n)+");
    private static final Pattern KEY_FOOTER = Pattern.compile("-+END\\s[^-\\r\\n]*PRIVATE\\s+KEY[^-\\r\\n]*-+(?:\\s|\\r|\\n)*");
    private static final Pattern BODY = Pattern.compile("[a-z0-9+/=][a-z0-9+/=\\r\\n]*", 2);

    static ByteBuf[] readCertificates(File file) throws CertificateException {
        ByteBuf[] byteBufArray;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byteBufArray = PemReader.readCertificates(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                PemReader.safeClose(fileInputStream);
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CertificateException("could not find certificate file: " + file);
            }
        }
        PemReader.safeClose(fileInputStream);
        return byteBufArray;
    }

    static ByteBuf[] readCertificates(InputStream inputStream) throws CertificateException {
        String string;
        try {
            string = PemReader.readContent(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException("failed to read certificate input stream", iOException);
        }
        ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>();
        Matcher matcher = CERT_HEADER.matcher(string);
        int n2 = 0;
        while (matcher.find(n2)) {
            n2 = matcher.end();
            matcher.usePattern(BODY);
            if (!matcher.find(n2)) break;
            ByteBuf byteBuf = Unpooled.copiedBuffer(matcher.group(0), CharsetUtil.US_ASCII);
            n2 = matcher.end();
            matcher.usePattern(CERT_FOOTER);
            if (!matcher.find(n2)) break;
            ByteBuf byteBuf2 = Base64.decode(byteBuf);
            byteBuf.release();
            arrayList.add(byteBuf2);
            n2 = matcher.end();
            matcher.usePattern(CERT_HEADER);
        }
        if (arrayList.isEmpty()) {
            throw new CertificateException("found no certificates in input stream");
        }
        return arrayList.toArray(new ByteBuf[0]);
    }

    static ByteBuf readPrivateKey(File file) throws KeyException {
        ByteBuf byteBuf;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byteBuf = PemReader.readPrivateKey(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                PemReader.safeClose(fileInputStream);
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new KeyException("could not find key file: " + file);
            }
        }
        PemReader.safeClose(fileInputStream);
        return byteBuf;
    }

    static ByteBuf readPrivateKey(InputStream inputStream) throws KeyException {
        String string;
        try {
            string = PemReader.readContent(inputStream);
        }
        catch (IOException iOException) {
            throw new KeyException("failed to read key input stream", iOException);
        }
        int n2 = 0;
        Matcher matcher = KEY_HEADER.matcher(string);
        if (!matcher.find(n2)) {
            throw PemReader.keyNotFoundException();
        }
        n2 = matcher.end();
        matcher.usePattern(BODY);
        if (!matcher.find(n2)) {
            throw PemReader.keyNotFoundException();
        }
        ByteBuf byteBuf = Unpooled.copiedBuffer(matcher.group(0), CharsetUtil.US_ASCII);
        n2 = matcher.end();
        matcher.usePattern(KEY_FOOTER);
        if (!matcher.find(n2)) {
            throw PemReader.keyNotFoundException();
        }
        ByteBuf byteBuf2 = Base64.decode(byteBuf);
        byteBuf.release();
        return byteBuf2;
    }

    private static KeyException keyNotFoundException() {
        return new KeyException("could not find a PKCS #8 private key in input stream (see https://netty.io/wiki/sslcontextbuilder-and-private-key.html for more information)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readContent(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            String string = byteArrayOutputStream.toString(CharsetUtil.US_ASCII.name());
            return string;
        }
        finally {
            PemReader.safeClose(byteArrayOutputStream);
        }
    }

    private static void safeClose(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a stream.", iOException);
        }
    }

    private static void safeClose(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a stream.", iOException);
        }
    }

    private PemReader() {
    }
}

