/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class IOExceptionList
extends IOException
implements Iterable<Throwable> {
    private final List<? extends Throwable> causeList;

    public static void checkEmpty(List<? extends Throwable> list, Object object) throws IOExceptionList {
        if (!IOExceptionList.isEmpty(list)) {
            throw new IOExceptionList(Objects.toString(object, null), list);
        }
    }

    private static boolean isEmpty(List<? extends Throwable> list) {
        return IOExceptionList.size(list) == 0;
    }

    private static int size(List<? extends Throwable> list) {
        return list != null ? list.size() : 0;
    }

    private static String toMessage(List<? extends Throwable> list) {
        return String.format("%,d exception(s): %s", IOExceptionList.size(list), list);
    }

    public IOExceptionList(String string, List<? extends Throwable> list) {
        super(string != null ? string : IOExceptionList.toMessage(list), IOExceptionList.isEmpty(list) ? null : list.get(0));
        this.causeList = list == null ? Collections.emptyList() : list;
    }

    public <T extends Throwable> List<T> getCauseList() {
        return new ArrayList<Throwable>(this.causeList);
    }

    @Override
    public Iterator<Throwable> iterator() {
        return this.getCauseList().iterator();
    }
}

