/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.AbstractFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrFileFilter
extends AbstractFileFilter
implements Serializable {
    private final List<IOFileFilter> fileFilters;

    public OrFileFilter() {
        this(0);
    }

    private OrFileFilter(ArrayList<IOFileFilter> arrayList) {
        this.fileFilters = Objects.requireNonNull(arrayList, "initialList");
    }

    private OrFileFilter(int n2) {
        this(new ArrayList<IOFileFilter>(n2));
    }

    public OrFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        this(2);
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    @Override
    public boolean accept(File file) {
        return this.fileFilters.stream().anyMatch(iOFileFilter -> iOFileFilter.accept(file));
    }

    @Override
    public boolean accept(File file, String string) {
        return this.fileFilters.stream().anyMatch(iOFileFilter -> iOFileFilter.accept(file, string));
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return OrFileFilter.toDefaultFileVisitResult(this.fileFilters.stream().anyMatch(iOFileFilter -> iOFileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE));
    }

    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.fileFilters.add(Objects.requireNonNull(iOFileFilter, "fileFilter"));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        this.append(this.fileFilters, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

