/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.conn.ssl;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ssl.SubjectName;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.DnsUtils;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.DomainType;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.InetAddressUtils;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.PublicSuffixMatcher;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public final class DefaultHostnameVerifier
implements HostnameVerifier {
    private final Log log = LogFactory.getLog(this.getClass());
    private final PublicSuffixMatcher publicSuffixMatcher;

    public DefaultHostnameVerifier(PublicSuffixMatcher publicSuffixMatcher) {
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public DefaultHostnameVerifier() {
        this(null);
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            this.verify(string, x509Certificate);
            return true;
        }
        catch (SSLException sSLException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(sSLException.getMessage(), sSLException);
            }
            return false;
        }
    }

    public void verify(String string, X509Certificate x509Certificate) throws SSLException {
        HostNameType hostNameType = DefaultHostnameVerifier.determineHostFormat(string);
        List<SubjectName> list = DefaultHostnameVerifier.getSubjectAltNames(x509Certificate);
        if (list != null && !list.isEmpty()) {
            switch (hostNameType) {
                case IPv4: {
                    DefaultHostnameVerifier.matchIPAddress(string, list);
                    break;
                }
                case IPv6: {
                    DefaultHostnameVerifier.matchIPv6Address(string, list);
                    break;
                }
                default: {
                    DefaultHostnameVerifier.matchDNSName(string, list, this.publicSuffixMatcher);
                    break;
                }
            }
        } else {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            String string2 = DefaultHostnameVerifier.extractCN(x500Principal.getName("RFC2253"));
            if (string2 == null) {
                throw new SSLException("Certificate subject for <" + string + "> doesn't contain " + "a common name and does not have alternative names");
            }
            DefaultHostnameVerifier.matchCN(string, string2, this.publicSuffixMatcher);
        }
    }

    static void matchIPAddress(String string, List<SubjectName> list) throws SSLException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SubjectName subjectName = list.get(i2);
            if (subjectName.getType() != 7 || !string.equals(subjectName.getValue())) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any " + "of the subject alternative names: " + list);
    }

    static void matchIPv6Address(String string, List<SubjectName> list) throws SSLException {
        String string2 = DefaultHostnameVerifier.normaliseAddress(string);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string3;
            SubjectName subjectName = list.get(i2);
            if (subjectName.getType() != 7 || !string2.equals(string3 = DefaultHostnameVerifier.normaliseAddress(subjectName.getValue()))) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any " + "of the subject alternative names: " + list);
    }

    static void matchDNSName(String string, List<SubjectName> list, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        String string2 = DnsUtils.normalize(string);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string3;
            SubjectName subjectName = list.get(i2);
            if (subjectName.getType() != 2 || !DefaultHostnameVerifier.matchIdentityStrict(string2, string3 = DnsUtils.normalize(subjectName.getValue()), publicSuffixMatcher)) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any " + "of the subject alternative names: " + list);
    }

    static void matchCN(String string, String string2, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        String string3;
        String string4 = DnsUtils.normalize(string);
        if (!DefaultHostnameVerifier.matchIdentityStrict(string4, string3 = DnsUtils.normalize(string2), publicSuffixMatcher)) {
            throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match " + "common name of the certificate subject: " + string2);
        }
    }

    static boolean matchDomainRoot(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return string.endsWith(string2) && (string.length() == string2.length() || string.charAt(string.length() - string2.length() - 1) == '.');
    }

    private static boolean matchIdentity(String string, String string2, PublicSuffixMatcher publicSuffixMatcher, DomainType domainType, boolean bl2) {
        if (publicSuffixMatcher != null && string.contains(".") && !DefaultHostnameVerifier.matchDomainRoot(string, publicSuffixMatcher.getDomainRoot(string2, domainType))) {
            return false;
        }
        int n2 = string2.indexOf(42);
        if (n2 != -1) {
            String string3;
            String string4 = string2.substring(0, n2);
            String string5 = string2.substring(n2 + 1);
            if (!string4.isEmpty() && !string.startsWith(string4)) {
                return false;
            }
            if (!string5.isEmpty() && !string.endsWith(string5)) {
                return false;
            }
            return !bl2 || !(string3 = string.substring(string4.length(), string.length() - string5.length())).contains(".");
        }
        return string.equalsIgnoreCase(string2);
    }

    static boolean matchIdentityStrict(String string, String string2, PublicSuffixMatcher publicSuffixMatcher) {
        return DefaultHostnameVerifier.matchIdentity(string, string2, publicSuffixMatcher, null, true);
    }

    static String extractCN(String string) throws SSLException {
        if (string == null) {
            return null;
        }
        try {
            LdapName ldapName = new LdapName(string);
            List<Rdn> list = ldapName.getRdns();
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                Rdn rdn = list.get(i2);
                Attributes attributes = rdn.toAttributes();
                Attribute attribute = attributes.get("cn");
                if (attribute == null) continue;
                try {
                    Object object = attribute.get();
                    if (object == null) continue;
                    return object.toString();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (InvalidNameException invalidNameException) {
            throw new SSLException(string + " is not a valid X500 distinguished name");
        }
    }

    static HostNameType determineHostFormat(String string) {
        if (InetAddressUtils.isIPv4Address(string)) {
            return HostNameType.IPv4;
        }
        String string2 = string;
        if (string2.startsWith("[") && string2.endsWith("]")) {
            string2 = string.substring(1, string.length() - 1);
        }
        if (InetAddressUtils.isIPv6Address(string2)) {
            return HostNameType.IPv6;
        }
        return HostNameType.DNS;
    }

    static List<SubjectName> getSubjectAltNames(X509Certificate x509Certificate) {
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return Collections.emptyList();
            }
            ArrayList<SubjectName> arrayList = new ArrayList<SubjectName>();
            for (List<?> list : collection) {
                Integer n2 = list.size() >= 2 ? (Integer)list.get(0) : null;
                if (n2 == null || n2 != 2 && n2 != 7) continue;
                Object obj = list.get(1);
                if (obj instanceof String) {
                    arrayList.add(new SubjectName((String)obj, n2));
                    continue;
                }
                if (!(obj instanceof byte[])) continue;
            }
            return arrayList;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    static String normaliseAddress(String string) {
        if (string == null) {
            return string;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    static enum HostNameType {
        IPv4(7),
        IPv6(7),
        DNS(2);

        final int subjectType;

        private HostNameType(int n3) {
            this.subjectType = n3;
        }
    }
}

