/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.io;

import com.gradle.maven.extension.internal.dep.org.apache.http.Header;
import com.gradle.maven.extension.internal.dep.org.apache.http.HeaderIterator;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpException;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpMessage;
import com.gradle.maven.extension.internal.dep.org.apache.http.io.HttpMessageWriter;
import com.gradle.maven.extension.internal.dep.org.apache.http.io.SessionOutputBuffer;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.BasicLineFormatter;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.LineFormatter;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    public AbstractMessageWriter(SessionOutputBuffer sessionOutputBuffer, LineFormatter lineFormatter) {
        this.sessionBuffer = Args.notNull(sessionOutputBuffer, "Session input buffer");
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T t2) throws IOException, HttpException {
        Args.notNull(t2, "HTTP message");
        this.writeHeadLine(t2);
        HeaderIterator headerIterator = t2.headerIterator();
        while (headerIterator.hasNext()) {
            Header header = headerIterator.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

