/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.InternalParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.FloatLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.IntLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.LongLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.RealLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;

public abstract class Literal
extends SpelNodeImpl {
    private final String originalValue;

    public Literal(String string, int n2, int n3) {
        super(n2, n3, new SpelNodeImpl[0]);
        this.originalValue = string;
    }

    @Override
    public final TypedValue getValueInternal(ExpressionState expressionState) throws SpelEvaluationException {
        return this.getLiteralValue();
    }

    public String toString() {
        return String.valueOf(this.getLiteralValue().getValue());
    }

    @Override
    public String toStringAST() {
        return this.toString();
    }

    public abstract TypedValue getLiteralValue();

    public static Literal getIntLiteral(String string, int n2, int n3, int n4) {
        try {
            int n5 = Integer.parseInt(string, n4);
            return new IntLiteral(string, n2, n3, n5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InternalParseException(new SpelParseException(n2, (Throwable)numberFormatException, SpelMessage.NOT_AN_INTEGER, string));
        }
    }

    public static Literal getLongLiteral(String string, int n2, int n3, int n4) {
        try {
            long l2 = Long.parseLong(string, n4);
            return new LongLiteral(string, n2, n3, l2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InternalParseException(new SpelParseException(n2, (Throwable)numberFormatException, SpelMessage.NOT_A_LONG, string));
        }
    }

    public static Literal getRealLiteral(String string, int n2, int n3, boolean bl2) {
        try {
            if (bl2) {
                float f2 = Float.parseFloat(string);
                return new FloatLiteral(string, n2, n3, f2);
            }
            double d2 = Double.parseDouble(string);
            return new RealLiteral(string, n2, n3, d2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InternalParseException(new SpelParseException(n2, (Throwable)numberFormatException, SpelMessage.NOT_A_REAL, string));
        }
    }
}

