/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Opcodes;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.ExpressionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelNode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public abstract class SpelNodeImpl
implements Opcodes,
SpelNode {
    private static final SpelNodeImpl[] NO_CHILDREN = new SpelNodeImpl[0];
    private final int startPos;
    private final int endPos;
    protected SpelNodeImpl[] children = NO_CHILDREN;
    private SpelNodeImpl parent;
    protected volatile String exitTypeDescriptor;

    public SpelNodeImpl(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        this.startPos = n2;
        this.endPos = n3;
        if (!ObjectUtils.isEmpty(spelNodeImplArray)) {
            this.children = spelNodeImplArray;
            for (SpelNodeImpl spelNodeImpl : spelNodeImplArray) {
                Assert.notNull((Object)spelNodeImpl, "Operand must not be null");
                spelNodeImpl.parent = this;
            }
        }
    }

    protected boolean nextChildIs(Class<?> ... classArray) {
        if (this.parent != null) {
            SpelNodeImpl[] spelNodeImplArray = this.parent.children;
            int n2 = spelNodeImplArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this != spelNodeImplArray[i2]) continue;
                if (i2 + 1 >= n2) {
                    return false;
                }
                Class<?> clazz = spelNodeImplArray[i2 + 1].getClass();
                for (Class<?> clazz2 : classArray) {
                    if (clazz != clazz2) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public final Object getValue(ExpressionState expressionState) throws EvaluationException {
        return this.getValueInternal(expressionState).getValue();
    }

    @Override
    public final TypedValue getTypedValue(ExpressionState expressionState) throws EvaluationException {
        return this.getValueInternal(expressionState);
    }

    public TypedValue setValueInternal(ExpressionState expressionState, Supplier<TypedValue> supplier) throws EvaluationException {
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.SETVALUE_NOT_SUPPORTED, this.getClass());
    }

    public SpelNode getChild(int n2) {
        return this.children[n2];
    }

    public int getChildCount() {
        return this.children.length;
    }

    public Class<?> getObjectClass(Object object) {
        if (object == null) {
            return null;
        }
        return object instanceof Class ? (Class<?>)object : object.getClass();
    }

    @Override
    public int getStartPosition() {
        return this.startPos;
    }

    public int getEndPosition() {
        return this.endPos;
    }

    public boolean isCompilable() {
        return false;
    }

    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        throw new IllegalStateException(this.getClass().getName() + " has no generateCode(..) method");
    }

    public String getExitDescriptor() {
        return this.exitTypeDescriptor;
    }

    protected final <T> T getValue(ExpressionState expressionState, Class<T> clazz) throws EvaluationException {
        return ExpressionUtils.convertTypedValue(expressionState.getEvaluationContext(), this.getValueInternal(expressionState), clazz);
    }

    protected ValueRef getValueRef(ExpressionState expressionState) throws EvaluationException {
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.NOT_ASSIGNABLE, this.toStringAST());
    }

    public abstract TypedValue getValueInternal(ExpressionState var1) throws EvaluationException;

    protected static void generateCodeForArguments(MethodVisitor methodVisitor, CodeFlow codeFlow, Member member, SpelNodeImpl[] spelNodeImplArray) {
        Executable executable;
        String[] stringArray = null;
        boolean bl2 = false;
        if (member instanceof Constructor) {
            executable = (Constructor)member;
            stringArray = CodeFlow.toDescriptors(((Constructor)executable).getParameterTypes());
            bl2 = ((Constructor)executable).isVarArgs();
        } else {
            executable = (Method)member;
            stringArray = CodeFlow.toDescriptors(((Method)executable).getParameterTypes());
            bl2 = ((Method)executable).isVarArgs();
        }
        if (bl2) {
            int n2 = 0;
            int n3 = spelNodeImplArray.length;
            for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
                SpelNodeImpl.generateCodeForArgument(methodVisitor, codeFlow, spelNodeImplArray[n2], stringArray[n2]);
            }
            SpelNodeImpl spelNodeImpl = n3 == 0 ? null : spelNodeImplArray[n3 - 1];
            String string = stringArray[stringArray.length - 1];
            if (spelNodeImpl != null && string.equals(spelNodeImpl.getExitDescriptor())) {
                SpelNodeImpl.generateCodeForArgument(methodVisitor, codeFlow, spelNodeImpl, stringArray[n2]);
            } else {
                string = string.substring(1);
                CodeFlow.insertNewArrayCode(methodVisitor, n3 - n2, string);
                int n4 = 0;
                while (n2 < n3) {
                    SpelNodeImpl spelNodeImpl2 = spelNodeImplArray[n2];
                    methodVisitor.visitInsn(89);
                    CodeFlow.insertOptimalLoad(methodVisitor, n4++);
                    SpelNodeImpl.generateCodeForArgument(methodVisitor, codeFlow, spelNodeImpl2, string);
                    CodeFlow.insertArrayStore(methodVisitor, string);
                    ++n2;
                }
            }
        } else {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                SpelNodeImpl.generateCodeForArgument(methodVisitor, codeFlow, spelNodeImplArray[i2], stringArray[i2]);
            }
        }
    }

    protected static void generateCodeForArgument(MethodVisitor methodVisitor, CodeFlow codeFlow, SpelNodeImpl spelNodeImpl, String string) {
        codeFlow.enterCompilationScope();
        spelNodeImpl.generateCode(methodVisitor, codeFlow);
        String string2 = codeFlow.lastDescriptor();
        Assert.state(string2 != null, "No last descriptor");
        boolean bl2 = CodeFlow.isPrimitive(string2);
        if (bl2 && string.charAt(0) == 'L') {
            CodeFlow.insertBoxIfNecessary(methodVisitor, string2.charAt(0));
        } else if (string.length() == 1 && !bl2) {
            CodeFlow.insertUnboxInsns(methodVisitor, string.charAt(0), string2);
        } else if (!string.equals(string2)) {
            CodeFlow.insertCheckCast(methodVisitor, string);
        }
        codeFlow.exitCompilationScope();
    }
}

