/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.CollectionUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;

public abstract class ReflectionHelper {
    static ArgumentsMatchInfo compareArguments(List<TypeDescriptor> list, List<TypeDescriptor> list2, TypeConverter typeConverter) {
        Assert.isTrue(list.size() == list2.size(), "Expected argument types and supplied argument types should be arrays of same length");
        ArgumentsMatchKind argumentsMatchKind = ArgumentsMatchKind.EXACT;
        for (int i2 = 0; i2 < list.size() && argumentsMatchKind != null; ++i2) {
            TypeDescriptor typeDescriptor = list2.get(i2);
            TypeDescriptor typeDescriptor2 = list.get(i2);
            if (typeDescriptor == null) {
                if (!typeDescriptor2.isPrimitive()) continue;
                argumentsMatchKind = null;
                continue;
            }
            if (typeDescriptor2.equals(typeDescriptor)) continue;
            if (typeDescriptor.isAssignableTo(typeDescriptor2)) {
                if (argumentsMatchKind == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                argumentsMatchKind = ArgumentsMatchKind.CLOSE;
                continue;
            }
            argumentsMatchKind = typeConverter.canConvert(typeDescriptor, typeDescriptor2) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        return argumentsMatchKind != null ? new ArgumentsMatchInfo(argumentsMatchKind) : null;
    }

    public static int getTypeDifferenceWeight(List<TypeDescriptor> list, List<TypeDescriptor> list2) {
        int n2 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TypeDescriptor typeDescriptor;
            TypeDescriptor typeDescriptor2 = list.get(i2);
            TypeDescriptor typeDescriptor3 = typeDescriptor = i2 < list2.size() ? list2.get(i2) : null;
            if (typeDescriptor == null) {
                if (!typeDescriptor2.isPrimitive()) continue;
                return Integer.MAX_VALUE;
            }
            Class<Object> clazz = typeDescriptor2.getType();
            if (!ClassUtils.isAssignable(clazz, typeDescriptor.getType())) {
                return Integer.MAX_VALUE;
            }
            if (clazz.isPrimitive()) {
                clazz = Object.class;
            }
            Class<?> clazz2 = typeDescriptor.getType().getSuperclass();
            while (clazz2 != null) {
                if (clazz.equals(clazz2)) {
                    n2 += 2;
                    clazz2 = null;
                    continue;
                }
                if (ClassUtils.isAssignable(clazz, clazz2)) {
                    n2 += 2;
                    clazz2 = clazz2.getSuperclass();
                    continue;
                }
                clazz2 = null;
            }
            if (!clazz.isInterface()) continue;
            ++n2;
        }
        return n2;
    }

    static ArgumentsMatchInfo compareArgumentsVarargs(List<TypeDescriptor> list, List<TypeDescriptor> list2, TypeConverter typeConverter) {
        Serializable serializable;
        TypeDescriptor typeDescriptor;
        Assert.isTrue(!CollectionUtils.isEmpty(list), "Expected arguments must at least include one array (the varargs parameter)");
        Assert.isTrue(list.get(list.size() - 1).isArray(), "Final expected argument should be array type (the varargs parameter)");
        ArgumentsMatchKind argumentsMatchKind = ArgumentsMatchKind.EXACT;
        int n2 = list.size() - 1;
        for (int i2 = 0; i2 < n2 && argumentsMatchKind != null; ++i2) {
            typeDescriptor = list2.get(i2);
            serializable = list.get(i2);
            if (typeDescriptor == null) {
                if (!((TypeDescriptor)serializable).isPrimitive()) continue;
                argumentsMatchKind = null;
                continue;
            }
            if (((TypeDescriptor)serializable).equals(typeDescriptor)) continue;
            if (typeDescriptor.isAssignableTo((TypeDescriptor)serializable)) {
                if (argumentsMatchKind == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                argumentsMatchKind = ArgumentsMatchKind.CLOSE;
                continue;
            }
            argumentsMatchKind = typeConverter.canConvert(typeDescriptor, (TypeDescriptor)serializable) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        if (argumentsMatchKind == null) {
            return null;
        }
        if (list2.size() != list.size() || !list.get(list.size() - 1).equals(list2.get(list2.size() - 1))) {
            TypeDescriptor typeDescriptor2 = list.get(list.size() - 1);
            typeDescriptor = typeDescriptor2.getElementTypeDescriptor();
            Assert.state(typeDescriptor != null, "No element type");
            serializable = typeDescriptor.getType();
            for (int i3 = list.size() - 1; i3 < list2.size(); ++i3) {
                TypeDescriptor typeDescriptor3 = list2.get(i3);
                if (typeDescriptor3 == null) {
                    if (!((Class)serializable).isPrimitive()) continue;
                    argumentsMatchKind = null;
                    continue;
                }
                if (serializable == typeDescriptor3.getType()) continue;
                if (ClassUtils.isAssignable(serializable, typeDescriptor3.getType())) {
                    if (argumentsMatchKind == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                    argumentsMatchKind = ArgumentsMatchKind.CLOSE;
                    continue;
                }
                argumentsMatchKind = typeConverter.canConvert(typeDescriptor3, TypeDescriptor.valueOf(serializable)) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
            }
        }
        return argumentsMatchKind != null ? new ArgumentsMatchInfo(argumentsMatchKind) : null;
    }

    public static boolean convertAllArguments(TypeConverter typeConverter, Object[] objectArray, Method method) throws SpelEvaluationException {
        Integer n2 = method.isVarArgs() ? Integer.valueOf(method.getParameterCount() - 1) : null;
        return ReflectionHelper.convertArguments(typeConverter, objectArray, method, n2);
    }

    static boolean convertArguments(TypeConverter typeConverter, Object[] objectArray, Executable executable, Integer n2) throws EvaluationException {
        boolean bl2;
        block8: {
            MethodParameter methodParameter;
            Object object;
            block9: {
                Object object2;
                block7: {
                    bl2 = false;
                    if (n2 != null) break block7;
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        TypeDescriptor typeDescriptor = new TypeDescriptor(MethodParameter.forExecutable(executable, i2));
                        Object object3 = objectArray[i2];
                        objectArray[i2] = typeConverter.convertValue(object3, TypeDescriptor.forObject(object3), typeDescriptor);
                        bl2 |= object3 != objectArray[i2];
                    }
                    break block8;
                }
                for (int i3 = 0; i3 < n2; ++i3) {
                    object = new TypeDescriptor(MethodParameter.forExecutable(executable, i3));
                    object2 = objectArray[i3];
                    objectArray[i3] = typeConverter.convertValue(object2, TypeDescriptor.forObject(object2), (TypeDescriptor)object);
                    bl2 |= object2 != objectArray[i3];
                }
                methodParameter = MethodParameter.forExecutable(executable, n2);
                if (n2 != objectArray.length - 1) break block9;
                object = objectArray[n2];
                object2 = new TypeDescriptor(methodParameter);
                TypeDescriptor typeDescriptor = TypeDescriptor.forObject(object);
                if (object == null) {
                    if (((TypeDescriptor)object2).getElementTypeDescriptor().getObjectType() == Optional.class) {
                        objectArray[n2.intValue()] = Optional.empty();
                        bl2 = true;
                    }
                } else if (!typeDescriptor.equals(((TypeDescriptor)object2).getElementTypeDescriptor())) {
                    objectArray[n2.intValue()] = typeConverter.convertValue(object, typeDescriptor, (TypeDescriptor)object2);
                }
                if (object == objectArray[n2] || ReflectionHelper.isFirstEntryInArray(object, objectArray[n2])) break block8;
                bl2 = true;
                break block8;
            }
            object = new TypeDescriptor(methodParameter).getElementTypeDescriptor();
            Assert.state(object != null, "No element type");
            for (int i4 = n2.intValue(); i4 < objectArray.length; ++i4) {
                Object object4 = objectArray[i4];
                objectArray[i4] = typeConverter.convertValue(object4, TypeDescriptor.forObject(object4), (TypeDescriptor)object);
                bl2 |= object4 != objectArray[i4];
            }
        }
        return bl2;
    }

    private static boolean isFirstEntryInArray(Object object, Object object2) {
        if (object2 == null) {
            return false;
        }
        Class<?> clazz = object2.getClass();
        if (!clazz.isArray() || Array.getLength(object2) == 0 || !ClassUtils.isAssignableValue(clazz.getComponentType(), object)) {
            return false;
        }
        Object object3 = Array.get(object2, 0);
        return clazz.getComponentType().isPrimitive() ? object3.equals(object) : object3 == object;
    }

    public static Object[] setupArgumentsForVarargsInvocation(Class<?>[] classArray, Object ... objectArray) {
        int n2 = classArray.length;
        int n3 = objectArray.length;
        if (n2 != objectArray.length || classArray[n2 - 1] != (objectArray[n3 - 1] != null ? objectArray[n3 - 1].getClass() : null)) {
            Object[] objectArray2 = new Object[n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length - 1);
            int n4 = 0;
            if (n3 >= n2) {
                n4 = n3 - (n2 - 1);
            }
            Class<?> clazz = classArray[n2 - 1].getComponentType();
            Object object = Array.newInstance(clazz, n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                Array.set(object, i2, objectArray[n2 - 1 + i2]);
            }
            objectArray2[objectArray2.length - 1] = object;
            return objectArray2;
        }
        return objectArray;
    }

    static class ArgumentsMatchInfo {
        private final ArgumentsMatchKind kind;

        ArgumentsMatchInfo(ArgumentsMatchKind argumentsMatchKind) {
            this.kind = argumentsMatchKind;
        }

        public boolean isExactMatch() {
            return this.kind == ArgumentsMatchKind.EXACT;
        }

        public boolean isCloseMatch() {
            return this.kind == ArgumentsMatchKind.CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this.kind == ArgumentsMatchKind.REQUIRES_CONVERSION;
        }

        public String toString() {
            return "ArgumentMatchInfo: " + (Object)((Object)this.kind);
        }
    }

    static enum ArgumentsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;

    }
}

