/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;

public class IgnoringResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final ResourceFilter resourceFilter;

    public IgnoringResourceHasher(ResourceHasher resourceHasher, ResourceFilter resourceFilter) {
        this.delegate = resourceHasher;
        this.resourceFilter = resourceFilter;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
        this.resourceFilter.appendConfigurationToHasher(hasher);
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext regularFileSnapshotContext) throws IOException {
        return this.resourceFilter.shouldBeIgnored(regularFileSnapshotContext.getRelativePathSegments()) ? null : this.delegate.hash(regularFileSnapshotContext);
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return this.resourceFilter.shouldBeIgnored(zipEntryContext.getRelativePathSegments()) ? null : this.delegate.hash(zipEntryContext);
    }
}

