/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.service.BaseLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.operations.BuildCacheLocalLoadBuildOperationType;
import org.gradle.caching.internal.operations.BuildCacheLocalStoreBuildOperationType;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;

public class OpFiringLocalBuildCacheServiceHandle
extends BaseLocalBuildCacheServiceHandle {
    private static final BuildCacheLocalStoreBuildOperationType.Result LOCAL_STORE_RESULT = new BuildCacheLocalStoreBuildOperationType.Result(){

        @Override
        public boolean isStored() {
            return true;
        }
    };
    private final BuildOperationRunner buildOperationRunner;

    public OpFiringLocalBuildCacheServiceHandle(LocalBuildCacheService localBuildCacheService, boolean bl2, BuildOperationRunner buildOperationRunner) {
        super(localBuildCacheService, bl2);
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public Optional<BuildCacheLoadResult> maybeLoad(final BuildCacheKey buildCacheKey, final Function<File, BuildCacheLoadResult> function) {
        return this.buildOperationRunner.call(new CallableBuildOperation<Optional<BuildCacheLoadResult>>(){

            @Override
            public Optional<BuildCacheLoadResult> call(BuildOperationContext buildOperationContext) {
                AtomicReference<Long> atomicReference = new AtomicReference<Long>();
                Optional optional = OpFiringLocalBuildCacheServiceHandle.super.maybeLoad(buildCacheKey, file -> {
                    atomicReference.set(file.length());
                    return (BuildCacheLoadResult)function.apply(file);
                });
                buildOperationContext.setResult(new LocalLoadResult(optional, atomicReference));
                return optional;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Load entry " + buildCacheKey.getHashCode() + " from local build cache").details(new LocalLoadDetails(buildCacheKey));
            }
        });
    }

    @Override
    protected void storeInner(final BuildCacheKey buildCacheKey, final File file) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext buildOperationContext) throws Exception {
                OpFiringLocalBuildCacheServiceHandle.super.storeInner(buildCacheKey, file);
                buildOperationContext.setResult(LOCAL_STORE_RESULT);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Store entry " + buildCacheKey.getHashCode() + " in local build cache").details(new LocalStoreDetails(buildCacheKey, file));
            }
        });
    }

    private static class LocalStoreDetails
    implements BuildCacheLocalStoreBuildOperationType.Details {
        private final BuildCacheKey key;
        private final long archiveSize;

        public LocalStoreDetails(BuildCacheKey buildCacheKey, File file) {
            this.key = buildCacheKey;
            this.archiveSize = file.length();
        }

        @Override
        public String getCacheKey() {
            return this.key.getHashCode();
        }

        @Override
        public long getArchiveSize() {
            return this.archiveSize;
        }
    }

    private static class LocalLoadResult
    implements BuildCacheLocalLoadBuildOperationType.Result {
        private final Optional<BuildCacheLoadResult> result;
        private final AtomicReference<Long> archiveSize;

        public LocalLoadResult(Optional<BuildCacheLoadResult> optional, AtomicReference<Long> atomicReference) {
            this.result = optional;
            this.archiveSize = atomicReference;
        }

        @Override
        public boolean isHit() {
            return this.result.isPresent();
        }

        @Override
        public long getArchiveSize() {
            return this.archiveSize.get();
        }
    }

    private static class LocalLoadDetails
    implements BuildCacheLocalLoadBuildOperationType.Details {
        private final BuildCacheKey key;

        public LocalLoadDetails(BuildCacheKey buildCacheKey) {
            this.key = buildCacheKey;
        }

        @Override
        public String getCacheKey() {
            return this.key.getHashCode();
        }
    }
}

