/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file.impl;

import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;

public class DefaultFileMetadata
implements FileMetadata {
    private static final FileMetadata DIR = new DefaultFileMetadata(FileType.Directory, 0L, 0L, FileMetadata.AccessType.DIRECT);
    private static final FileMetadata DIR_ACCESSED_VIA_SYMLINK = new DefaultFileMetadata(FileType.Directory, 0L, 0L, FileMetadata.AccessType.VIA_SYMLINK);
    private static final FileMetadata MISSING = new DefaultFileMetadata(FileType.Missing, 0L, 0L, FileMetadata.AccessType.DIRECT);
    private static final FileMetadata BROKEN_SYMLINK = new DefaultFileMetadata(FileType.Missing, 0L, 0L, FileMetadata.AccessType.VIA_SYMLINK);
    private final FileType type;
    private final long lastModified;
    private final long length;
    private final FileMetadata.AccessType accessType;

    private DefaultFileMetadata(FileType fileType, long l2, long l3, FileMetadata.AccessType accessType) {
        this.type = fileType;
        this.lastModified = l2;
        this.length = l3;
        this.accessType = accessType;
    }

    public static FileMetadata file(long l2, long l3, FileMetadata.AccessType accessType) {
        return new DefaultFileMetadata(FileType.RegularFile, l2, l3, accessType);
    }

    @Override
    public FileMetadata.AccessType getAccessType() {
        return this.accessType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultFileMetadata defaultFileMetadata = (DefaultFileMetadata)object;
        return this.type == defaultFileMetadata.type && this.length == defaultFileMetadata.length && this.lastModified == defaultFileMetadata.lastModified && this.accessType == defaultFileMetadata.accessType;
    }

    public int hashCode() {
        int n2 = this.type.hashCode();
        n2 = 31 * n2 + (int)(this.lastModified ^ this.lastModified >>> 32);
        n2 = 31 * n2 + (int)(this.length ^ this.length >>> 32);
        n2 = 31 * n2 + this.accessType.hashCode();
        return n2;
    }
}

