/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;

public class DefaultFileSystemLocationFingerprint
implements FileSystemLocationFingerprint {
    private final HashCode normalizedContentHash;
    private final String normalizedPath;

    public DefaultFileSystemLocationFingerprint(String string, FileType fileType, HashCode hashCode) {
        this.normalizedContentHash = DefaultFileSystemLocationFingerprint.hashForType(fileType, hashCode);
        this.normalizedPath = string;
    }

    private static HashCode hashForType(FileType fileType, HashCode hashCode) {
        switch (fileType) {
            case Directory: {
                return DIR_SIGNATURE;
            }
            case Missing: {
                return MISSING_FILE_SIGNATURE;
            }
            case RegularFile: {
                return hashCode;
            }
        }
        throw new IllegalStateException("Unknown file type: " + (Object)((Object)fileType));
    }

    @Override
    public final void appendToHasher(Hasher hasher) {
        hasher.putString(this.getNormalizedPath());
        hasher.putHash(this.getNormalizedContentHash());
    }

    public FileType getType() {
        if (this.normalizedContentHash == DIR_SIGNATURE) {
            return FileType.Directory;
        }
        if (this.normalizedContentHash == MISSING_FILE_SIGNATURE) {
            return FileType.Missing;
        }
        return FileType.RegularFile;
    }

    @Override
    public String getNormalizedPath() {
        return this.normalizedPath;
    }

    @Override
    public HashCode getNormalizedContentHash() {
        return this.normalizedContentHash;
    }

    @Override
    public final int compareTo(FileSystemLocationFingerprint fileSystemLocationFingerprint) {
        int n2 = this.getNormalizedPath().compareTo(fileSystemLocationFingerprint.getNormalizedPath());
        if (n2 == 0) {
            n2 = this.getNormalizedContentHash().compareTo(fileSystemLocationFingerprint.getNormalizedContentHash());
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultFileSystemLocationFingerprint defaultFileSystemLocationFingerprint = (DefaultFileSystemLocationFingerprint)object;
        if (!this.normalizedContentHash.equals(defaultFileSystemLocationFingerprint.normalizedContentHash)) {
            return false;
        }
        return this.normalizedPath.equals(defaultFileSystemLocationFingerprint.normalizedPath);
    }

    public int hashCode() {
        int n2 = this.normalizedContentHash.hashCode();
        n2 = 31 * n2 + this.normalizedPath.hashCode();
        return n2;
    }

    public String toString() {
        return String.format("'%s' / %s", this.getNormalizedPath(), this.getHashOrTypeToDisplay());
    }

    private Object getHashOrTypeToDisplay() {
        switch (this.getType()) {
            case Directory: {
                return "DIR";
            }
            case Missing: {
                return "MISSING";
            }
        }
        return this.normalizedContentHash;
    }
}

