/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.Type;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.ParameterAnnotationMember;
import org.gradle.internal.normalization.java.impl.TypedMember;

public class MethodMember
extends TypedMember
implements Comparable<MethodMember> {
    private static final Ordering<Iterable<String>> LEXICOGRAPHICAL_ORDERING = Ordering.natural().lexicographical();
    private final SortedSet<String> exceptions = new TreeSet<String>();
    private final SortedSet<AnnotationMember> parameterAnnotations = new TreeSet<AnnotationMember>();

    public MethodMember(int n2, String string, String string2, String string3, String[] stringArray) {
        super(n2, string, string3, string2);
        if (stringArray != null && stringArray.length > 0) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
    }

    public SortedSet<String> getExceptions() {
        return ImmutableSortedSet.copyOf(this.exceptions);
    }

    public SortedSet<AnnotationMember> getParameterAnnotations() {
        return ImmutableSortedSet.copyOf(this.parameterAnnotations);
    }

    public void addParameterAnnotation(ParameterAnnotationMember parameterAnnotationMember) {
        this.parameterAnnotations.add(parameterAnnotationMember);
    }

    @Override
    public int compareTo(MethodMember methodMember) {
        return super.compare(methodMember).compare(this.exceptions, methodMember.exceptions, LEXICOGRAPHICAL_ORDERING).result();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Modifier.toString(this.getAccess())).append(" ");
        stringBuilder.append(Type.getReturnType(this.getTypeDesc()).getClassName()).append(" ");
        stringBuilder.append(this.getName());
        stringBuilder.append("(");
        Type[] typeArray = Type.getArgumentTypes(this.getTypeDesc());
        int n2 = typeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type = typeArray[i2];
            stringBuilder.append(type.getClassName());
            if (i2 >= n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

