/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.AbstractFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.ChildMapFactory;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class DirectorySnapshot
extends AbstractFileSystemLocationSnapshot {
    private final ChildMap<FileSystemLocationSnapshot> children;
    private final HashCode contentHash;

    public DirectorySnapshot(String string, String string2, FileMetadata.AccessType accessType, HashCode hashCode, List<FileSystemLocationSnapshot> list) {
        this(string, string2, accessType, hashCode, ChildMapFactory.childMapFromSorted(list.stream().map(fileSystemLocationSnapshot -> new ChildMap.Entry<FileSystemLocationSnapshot>(fileSystemLocationSnapshot.getName(), (FileSystemLocationSnapshot)fileSystemLocationSnapshot)).collect(Collectors.toList())));
    }

    public DirectorySnapshot(String string, String string2, FileMetadata.AccessType accessType, HashCode hashCode, ChildMap<FileSystemLocationSnapshot> childMap) {
        super(string, string2, accessType);
        this.contentHash = hashCode;
        this.children = childMap;
    }

    @Override
    public HashCode getHash() {
        return this.contentHash;
    }

    @Override
    public FileType getType() {
        return FileType.Directory;
    }

    @Override
    public SnapshotVisitResult accept(FileSystemSnapshotHierarchyVisitor fileSystemSnapshotHierarchyVisitor) {
        SnapshotVisitResult snapshotVisitResult = fileSystemSnapshotHierarchyVisitor.visitEntry(this);
        switch (snapshotVisitResult) {
            case CONTINUE: {
                fileSystemSnapshotHierarchyVisitor.enterDirectory(this);
                this.children.stream().map(ChildMap.Entry::getValue).forEach(fileSystemLocationSnapshot -> fileSystemLocationSnapshot.accept(fileSystemSnapshotHierarchyVisitor));
                fileSystemSnapshotHierarchyVisitor.leaveDirectory(this);
                return SnapshotVisitResult.CONTINUE;
            }
            case SKIP_SUBTREE: {
                return SnapshotVisitResult.CONTINUE;
            }
            case TERMINATE: {
                return SnapshotVisitResult.TERMINATE;
            }
        }
        throw new AssertionError();
    }

    @Override
    public SnapshotVisitResult accept(RelativePathTracker relativePathTracker, RelativePathTrackingFileSystemSnapshotHierarchyVisitor relativePathTrackingFileSystemSnapshotHierarchyVisitor) {
        relativePathTracker.enter(this.getName());
        try {
            SnapshotVisitResult snapshotVisitResult = relativePathTrackingFileSystemSnapshotHierarchyVisitor.visitEntry(this, relativePathTracker);
            switch (snapshotVisitResult) {
                case CONTINUE: {
                    relativePathTrackingFileSystemSnapshotHierarchyVisitor.enterDirectory(this, relativePathTracker);
                    this.children.stream().map(ChildMap.Entry::getValue).forEach(fileSystemLocationSnapshot -> fileSystemLocationSnapshot.accept(relativePathTracker, relativePathTrackingFileSystemSnapshotHierarchyVisitor));
                    relativePathTrackingFileSystemSnapshotHierarchyVisitor.leaveDirectory(this, relativePathTracker);
                    SnapshotVisitResult snapshotVisitResult2 = SnapshotVisitResult.CONTINUE;
                    return snapshotVisitResult2;
                }
                case SKIP_SUBTREE: {
                    SnapshotVisitResult snapshotVisitResult3 = SnapshotVisitResult.CONTINUE;
                    return snapshotVisitResult3;
                }
                case TERMINATE: {
                    SnapshotVisitResult snapshotVisitResult4 = SnapshotVisitResult.TERMINATE;
                    return snapshotVisitResult4;
                }
            }
            throw new AssertionError();
        }
        finally {
            relativePathTracker.leave();
        }
    }

    @Override
    public void accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor fileSystemLocationSnapshotVisitor) {
        fileSystemLocationSnapshotVisitor.visitDirectory(this);
    }

    @Override
    public <T> T accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<T> fileSystemLocationSnapshotTransformer) {
        return fileSystemLocationSnapshotTransformer.visitDirectory(this);
    }

    public ImmutableList<FileSystemLocationSnapshot> getChildren() {
        return this.children.stream().map(ChildMap.Entry::getValue).collect(ImmutableList.toImmutableList());
    }

    @Override
    public String toString() {
        return String.format("%s@%s/%s(%s)", super.toString(), this.contentHash, this.getName(), this.children);
    }
}

