/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathBidirRef;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.PriorityQueue;

public class DijkstraBidirectionRef
extends AbstractBidirAlgo {
    protected IntObjectMap<SPTEntry> bestWeightMapFrom;
    protected IntObjectMap<SPTEntry> bestWeightMapTo;
    protected IntObjectMap<SPTEntry> bestWeightMapOther;
    protected SPTEntry currFrom;
    protected SPTEntry currTo;
    protected PathBidirRef bestPath;
    PriorityQueue<SPTEntry> pqOpenSetFrom;
    PriorityQueue<SPTEntry> pqOpenSetTo;
    private boolean updateBestPath = true;

    public DijkstraBidirectionRef(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        int size = Math.min(Math.max(200, graph.getNodes() / 10), 150000);
        this.initCollections(size);
    }

    protected void initCollections(int size) {
        this.pqOpenSetFrom = new PriorityQueue(size);
        this.bestWeightMapFrom = new GHIntObjectHashMap(size);
        this.pqOpenSetTo = new PriorityQueue(size);
        this.bestWeightMapTo = new GHIntObjectHashMap(size);
    }

    @Override
    public void initFrom(int from, double weight) {
        this.currFrom = this.createSPTEntry(from, weight);
        this.pqOpenSetFrom.add(this.currFrom);
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapFrom.put(from, (Object)this.currFrom);
            if (this.currTo != null) {
                this.bestWeightMapOther = this.bestWeightMapTo;
                this.updateBestPath(GHUtility.getEdge(this.graph, from, this.currTo.adjNode), this.currTo, from);
            }
        } else if (this.currTo != null && this.currTo.adjNode == from) {
            this.bestPath.sptEntry = this.currFrom;
            this.bestPath.edgeTo = this.currTo;
            this.finishedFrom = true;
            this.finishedTo = true;
        }
    }

    @Override
    public void initTo(int to, double weight) {
        this.currTo = this.createSPTEntry(to, weight);
        this.pqOpenSetTo.add(this.currTo);
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapTo.put(to, (Object)this.currTo);
            if (this.currFrom != null) {
                this.bestWeightMapOther = this.bestWeightMapFrom;
                this.updateBestPath(GHUtility.getEdge(this.graph, this.currFrom.adjNode, to), this.currFrom, to);
            }
        } else if (this.currFrom != null && this.currFrom.adjNode == to) {
            this.bestPath.sptEntry = this.currFrom;
            this.bestPath.edgeTo = this.currTo;
            this.finishedFrom = true;
            this.finishedTo = true;
        }
    }

    @Override
    protected Path createAndInitPath() {
        this.bestPath = new PathBidirRef(this.graph, this.weighting);
        return this.bestPath;
    }

    @Override
    protected Path extractPath() {
        if (this.finished()) {
            return this.bestPath.extract();
        }
        return this.bestPath;
    }

    @Override
    protected double getCurrentFromWeight() {
        return this.currFrom.weight;
    }

    @Override
    protected double getCurrentToWeight() {
        return this.currTo.weight;
    }

    @Override
    public boolean fillEdgesFrom() {
        if (this.pqOpenSetFrom.isEmpty()) {
            return false;
        }
        this.currFrom = this.pqOpenSetFrom.poll();
        this.bestWeightMapOther = this.bestWeightMapTo;
        this.fillEdges(this.currFrom, this.pqOpenSetFrom, this.bestWeightMapFrom, this.outEdgeExplorer, false);
        ++this.visitedCountFrom;
        return true;
    }

    @Override
    public boolean fillEdgesTo() {
        if (this.pqOpenSetTo.isEmpty()) {
            return false;
        }
        this.currTo = this.pqOpenSetTo.poll();
        this.bestWeightMapOther = this.bestWeightMapFrom;
        this.fillEdges(this.currTo, this.pqOpenSetTo, this.bestWeightMapTo, this.inEdgeExplorer, true);
        ++this.visitedCountTo;
        return true;
    }

    @Override
    public boolean finished() {
        if (this.finishedFrom || this.finishedTo) {
            return true;
        }
        return this.currFrom.weight + this.currTo.weight >= this.bestPath.getWeight();
    }

    void fillEdges(SPTEntry currEdge, PriorityQueue<SPTEntry> prioQueue, IntObjectMap<SPTEntry> bestWeightMap, EdgeExplorer explorer, boolean reverse) {
        EdgeIterator iter = explorer.setBaseNode(currEdge.adjNode);
        while (iter.next()) {
            if (!this.accept(iter, currEdge.edge)) continue;
            int traversalId = this.traversalMode.createTraversalId(iter, reverse);
            double tmpWeight = this.weighting.calcWeight(iter, reverse, currEdge.edge) + currEdge.weight;
            if (Double.isInfinite(tmpWeight)) continue;
            SPTEntry ee = (SPTEntry)bestWeightMap.get(traversalId);
            if (ee == null) {
                ee = new SPTEntry(iter.getEdge(), iter.getAdjNode(), tmpWeight);
                ee.parent = currEdge;
                bestWeightMap.put(traversalId, (Object)ee);
                prioQueue.add(ee);
            } else {
                if (!(ee.weight > tmpWeight)) continue;
                prioQueue.remove(ee);
                ee.edge = iter.getEdge();
                ee.weight = tmpWeight;
                ee.parent = currEdge;
                prioQueue.add(ee);
            }
            if (!this.updateBestPath) continue;
            this.updateBestPath(iter, ee, traversalId);
        }
    }

    @Override
    protected void updateBestPath(EdgeIteratorState edgeState, SPTEntry entryCurrent, int traversalId) {
        SPTEntry entryOther = (SPTEntry)this.bestWeightMapOther.get(traversalId);
        if (entryOther == null) {
            return;
        }
        boolean reverse = this.bestWeightMapFrom == this.bestWeightMapOther;
        double newWeight = entryCurrent.weight + entryOther.weight;
        if (this.traversalMode.isEdgeBased()) {
            if (entryOther.edge != entryCurrent.edge) {
                throw new IllegalStateException("cannot happen for edge based execution of " + this.getName());
            }
            if (entryOther.adjNode != entryCurrent.adjNode) {
                entryCurrent = entryCurrent.parent;
                newWeight -= this.weighting.calcWeight(edgeState, reverse, -1);
            } else if (!this.traversalMode.hasUTurnSupport()) {
                return;
            }
        }
        if (newWeight < this.bestPath.getWeight()) {
            this.bestPath.setSwitchToFrom(reverse);
            this.bestPath.setSPTEntry(entryCurrent);
            this.bestPath.setWeight(newWeight);
            this.bestPath.setSPTEntryTo(entryOther);
        }
    }

    IntObjectMap<SPTEntry> getBestFromMap() {
        return this.bestWeightMapFrom;
    }

    IntObjectMap<SPTEntry> getBestToMap() {
        return this.bestWeightMapTo;
    }

    void setBestOtherMap(IntObjectMap<SPTEntry> other) {
        this.bestWeightMapOther = other;
    }

    void setFromDataStructures(DijkstraBidirectionRef dijkstra) {
        this.pqOpenSetFrom = dijkstra.pqOpenSetFrom;
        this.bestWeightMapFrom = dijkstra.bestWeightMapFrom;
        this.finishedFrom = dijkstra.finishedFrom;
        this.currFrom = dijkstra.currFrom;
        this.visitedCountFrom = dijkstra.visitedCountFrom;
    }

    void setToDataStructures(DijkstraBidirectionRef dijkstra) {
        this.pqOpenSetTo = dijkstra.pqOpenSetTo;
        this.bestWeightMapTo = dijkstra.bestWeightMapTo;
        this.finishedTo = dijkstra.finishedTo;
        this.currTo = dijkstra.currTo;
        this.visitedCountTo = dijkstra.visitedCountTo;
    }

    protected void setUpdateBestPath(boolean b) {
        this.updateBestPath = b;
    }

    void setBestPath(PathBidirRef bestPath) {
        this.bestPath = bestPath;
    }

    @Override
    public String getName() {
        return "dijkstrabi";
    }
}

