/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.InstructionsHelper;
import com.graphhopper.routing.util.DataFlagEncoder;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.List;

class InstructionsOutgoingEdges {
    final EdgeIteratorState prevEdge;
    final EdgeIteratorState currentEdge;
    final List<EdgeIteratorState> allowedOutgoingEdges;
    final List<EdgeIteratorState> allOutgoingEdges;
    final FlagEncoder encoder;
    final NodeAccess nodeAccess;

    public InstructionsOutgoingEdges(EdgeIteratorState prevEdge, EdgeIteratorState currentEdge, FlagEncoder encoder, EdgeExplorer crossingExplorer, NodeAccess nodeAccess, int prevNode, int baseNode, int adjNode) {
        this.prevEdge = prevEdge;
        this.currentEdge = currentEdge;
        this.encoder = encoder;
        this.nodeAccess = nodeAccess;
        this.allOutgoingEdges = new ArrayList<EdgeIteratorState>();
        this.allowedOutgoingEdges = new ArrayList<EdgeIteratorState>();
        EdgeIterator edgeIter = crossingExplorer.setBaseNode(baseNode);
        while (edgeIter.next()) {
            if (edgeIter.getAdjNode() == prevNode || edgeIter.getAdjNode() == adjNode) continue;
            EdgeIteratorState tmpEdge = edgeIter.detach(false);
            this.allOutgoingEdges.add(tmpEdge);
            if (!encoder.isForward(tmpEdge.getFlags())) continue;
            this.allowedOutgoingEdges.add(tmpEdge);
        }
    }

    public int nrOfAllowedOutgoingEdges() {
        return 1 + this.allowedOutgoingEdges.size();
    }

    public int nrOfAllOutgoingEdges() {
        return 1 + this.allOutgoingEdges.size();
    }

    public boolean outgoingEdgesAreSlowerByFactor(double factor) {
        double tmpSpeed = this.getSpeed(this.currentEdge);
        double pathSpeed = this.getSpeed(this.prevEdge);
        if (pathSpeed != tmpSpeed || pathSpeed < 1.0) {
            return false;
        }
        double maxSurroundingSpeed = -1.0;
        for (EdgeIteratorState edge : this.allOutgoingEdges) {
            tmpSpeed = this.getSpeed(edge);
            if (tmpSpeed < 1.0) {
                return false;
            }
            if (!(tmpSpeed > maxSurroundingSpeed)) continue;
            maxSurroundingSpeed = tmpSpeed;
        }
        return maxSurroundingSpeed * factor < pathSpeed;
    }

    private double getSpeed(EdgeIteratorState edge) {
        if (this.encoder instanceof DataFlagEncoder) {
            return ((DataFlagEncoder)this.encoder).getMaxspeed(edge, 0, false);
        }
        return this.encoder.getSpeed(edge.getFlags());
    }

    public EdgeIteratorState getOtherContinue(double prevLat, double prevLon, double prevOrientation) {
        for (EdgeIteratorState edge : this.allowedOutgoingEdges) {
            GHPoint point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess);
            int tmpSign = InstructionsHelper.calculateSign(prevLat, prevLon, point.getLat(), point.getLon(), prevOrientation);
            if (Math.abs(tmpSign) > 1) continue;
            return edge;
        }
        return null;
    }

    public boolean isLeavingCurrentStreet(String prevName, String name) {
        if (InstructionsHelper.isNameSimilar(name, prevName)) {
            return false;
        }
        boolean checkFlag = this.currentEdge.getFlags() != this.prevEdge.getFlags();
        for (EdgeIteratorState edge : this.allowedOutgoingEdges) {
            String edgeName = edge.getName();
            long edgeFlag = edge.getFlags();
            if (!this.isTheSameStreet(prevName, this.prevEdge.getFlags(), edgeName, edgeFlag, checkFlag) && !this.isTheSameStreet(name, this.currentEdge.getFlags(), edgeName, edgeFlag, checkFlag)) continue;
            return true;
        }
        return false;
    }

    private boolean isTheSameStreet(String name1, long flags1, String name2, long flags2, boolean checkFlag) {
        return InstructionsHelper.isNameSimilar(name1, name2) && (!checkFlag || flags1 == flags2);
    }
}

