/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.ch.PreparationWeighting;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.StopWatch;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class NodeContractor {
    private final GraphHopperStorage ghStorage;
    private final CHGraph prepareGraph;
    private final PreparationWeighting prepareWeighting;
    private final TraversalMode traversalMode;
    private final DataAccess originalEdges;
    private final Map<Shortcut, Shortcut> shortcuts = new HashMap<Shortcut, Shortcut>();
    private final AddShortcutHandler addScHandler = new AddShortcutHandler();
    private final CalcShortcutHandler calcScHandler = new CalcShortcutHandler();
    private CHEdgeExplorer vehicleInExplorer;
    private CHEdgeExplorer vehicleOutExplorer;
    private IgnoreNodeFilter ignoreNodeFilter;
    private DijkstraOneToMany prepareAlgo;
    private int addedShortcutsCount;
    private long dijkstraCount;
    private int maxVisitedNodes = Integer.MAX_VALUE;
    private StopWatch dijkstraSW = new StopWatch();
    private int maxEdgesCount;
    private int maxLevel;

    NodeContractor(Directory dir, GraphHopperStorage ghStorage, CHGraph prepareGraph, Weighting weighting, TraversalMode traversalMode) {
        if (traversalMode.isEdgeBased()) {
            throw new IllegalArgumentException("Contraction Hierarchies only support node based traversal so far, given: " + (Object)((Object)traversalMode));
        }
        this.ghStorage = ghStorage;
        this.prepareGraph = prepareGraph;
        this.prepareWeighting = new PreparationWeighting(weighting);
        this.traversalMode = traversalMode;
        this.originalEdges = dir.find("original_edges_" + AbstractWeighting.weightingToFileName(weighting));
        this.originalEdges.create(1000L);
    }

    void initFromGraph() {
        this.maxLevel = this.prepareGraph.getNodes() + 1;
        this.maxEdgesCount = this.ghStorage.getAllEdges().getMaxId();
        this.ignoreNodeFilter = new IgnoreNodeFilter(this.prepareGraph, this.maxLevel);
        FlagEncoder prepareFlagEncoder = this.prepareWeighting.getFlagEncoder();
        this.vehicleInExplorer = this.prepareGraph.createEdgeExplorer(new DefaultEdgeFilter(prepareFlagEncoder, true, false));
        this.vehicleOutExplorer = this.prepareGraph.createEdgeExplorer(new DefaultEdgeFilter(prepareFlagEncoder, false, true));
        this.prepareAlgo = new DijkstraOneToMany(this.prepareGraph, this.prepareWeighting, this.traversalMode);
    }

    void close() {
        this.prepareAlgo.close();
        this.originalEdges.close();
    }

    void setMaxVisitedNodes(int maxVisitedNodes) {
        this.maxVisitedNodes = maxVisitedNodes;
    }

    long contractNode(int node) {
        this.shortcuts.clear();
        long degree = this.findShortcuts(this.addScHandler.setNode(node));
        this.addedShortcutsCount += this.addShortcuts(this.shortcuts.keySet());
        return degree;
    }

    CalcShortcutsResult calcShortcutCount(int node) {
        this.findShortcuts(this.calcScHandler.setNode(node));
        return this.calcScHandler.calcShortcutsResult;
    }

    private long findShortcuts(ShortcutHandler sch) {
        long degree = 0L;
        CHEdgeIterator incomingEdges = this.vehicleInExplorer.setBaseNode(sch.getNode());
        while (incomingEdges.next()) {
            int fromNode = incomingEdges.getAdjNode();
            if (this.prepareGraph.getLevel(fromNode) != this.maxLevel) continue;
            double incomingEdgeDistance = incomingEdges.getDistance();
            double incomingEdgeWeight = this.prepareWeighting.calcWeight(incomingEdges, true, -1);
            int incomingEdge = incomingEdges.getEdge();
            int incomingEdgeOrigCount = this.getOrigEdgeCount(incomingEdge);
            CHEdgeIterator outgoingEdges = this.vehicleOutExplorer.setBaseNode(sch.getNode());
            this.prepareAlgo.clear();
            ++degree;
            while (outgoingEdges.next()) {
                int toNode = outgoingEdges.getAdjNode();
                if (this.prepareGraph.getLevel(toNode) != this.maxLevel || fromNode == toNode) continue;
                double existingDirectWeight = incomingEdgeWeight + this.prepareWeighting.calcWeight(outgoingEdges, false, incomingEdges.getEdge());
                if (Double.isNaN(existingDirectWeight)) {
                    throw new IllegalStateException("Weighting should never return NaN values, in:" + this.getCoords(incomingEdges, this.prepareGraph) + ", out:" + this.getCoords(outgoingEdges, this.prepareGraph) + ", dist:" + outgoingEdges.getDistance());
                }
                if (Double.isInfinite(existingDirectWeight)) continue;
                double existingDistSum = incomingEdgeDistance + outgoingEdges.getDistance();
                this.prepareAlgo.setWeightLimit(existingDirectWeight);
                this.prepareAlgo.setMaxVisitedNodes(this.maxVisitedNodes);
                this.prepareAlgo.setEdgeFilter(this.ignoreNodeFilter.setAvoidNode(sch.getNode()));
                this.dijkstraSW.start();
                ++this.dijkstraCount;
                int endNode = this.prepareAlgo.findEndNode(fromNode, toNode);
                this.dijkstraSW.stop();
                if (endNode == toNode && this.prepareAlgo.getWeight(endNode) <= existingDirectWeight) continue;
                sch.foundShortcut(fromNode, toNode, existingDirectWeight, existingDistSum, outgoingEdges.getEdge(), this.getOrigEdgeCount(outgoingEdges.getEdge()), incomingEdge, incomingEdgeOrigCount);
            }
        }
        return degree;
    }

    private int addShortcuts(Collection<Shortcut> shortcuts) {
        int tmpNewShortcuts = 0;
        block0: for (Shortcut sc : shortcuts) {
            boolean updatedInGraph = false;
            CHEdgeIterator iter = this.vehicleOutExplorer.setBaseNode(sc.from);
            while (iter.next()) {
                int status;
                if (!iter.isShortcut() || iter.getAdjNode() != sc.to || (status = iter.getMergeStatus(sc.flags)) == 0) continue;
                if (sc.weight >= this.prepareWeighting.calcWeight(iter, false, -1)) {
                    if (status != 2) continue block0;
                    break;
                }
                if (iter.getEdge() == sc.skippedEdge1 || iter.getEdge() == sc.skippedEdge2) {
                    throw new IllegalStateException("Shortcut cannot update itself! " + iter.getEdge() + ", skipEdge1:" + sc.skippedEdge1 + ", skipEdge2:" + sc.skippedEdge2 + ", edge " + iter + ":" + this.getCoords(iter, this.prepareGraph) + ", sc:" + sc + ", skippedEdge1: " + this.getCoords(this.prepareGraph.getEdgeIteratorState(sc.skippedEdge1, sc.from), this.prepareGraph) + ", skippedEdge2: " + this.getCoords(this.prepareGraph.getEdgeIteratorState(sc.skippedEdge2, sc.to), this.prepareGraph) + ", neighbors:" + GHUtility.getNeighbors(iter));
                }
                iter.setFlags(sc.flags);
                iter.setWeight(sc.weight);
                iter.setDistance(sc.dist);
                iter.setSkippedEdges(sc.skippedEdge1, sc.skippedEdge2);
                this.setOrigEdgeCount(iter.getEdge(), sc.originalEdges);
                updatedInGraph = true;
                break;
            }
            if (updatedInGraph) continue;
            CHEdgeIteratorState edgeState = this.prepareGraph.shortcut(sc.from, sc.to);
            edgeState.setFlags(sc.flags);
            edgeState.setWeight(sc.weight);
            edgeState.setDistance(sc.dist);
            edgeState.setSkippedEdges(sc.skippedEdge1, sc.skippedEdge2);
            this.setOrigEdgeCount(edgeState.getEdge(), sc.originalEdges);
            ++tmpNewShortcuts;
        }
        return tmpNewShortcuts;
    }

    private String getCoords(EdgeIteratorState edge, Graph graph) {
        NodeAccess na = graph.getNodeAccess();
        int base = edge.getBaseNode();
        int adj = edge.getAdjNode();
        return base + "->" + adj + " (" + edge.getEdge() + "); " + na.getLat(base) + "," + na.getLon(base) + " -> " + na.getLat(adj) + "," + na.getLon(adj);
    }

    int getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    private void setOrigEdgeCount(int edgeId, int value) {
        if ((edgeId -= this.maxEdgesCount) < 0) {
            if (value != 1) {
                throw new IllegalStateException("Trying to set original edge count for normal edge to a value = " + value + ", edge:" + (edgeId + this.maxEdgesCount) + ", max:" + this.maxEdgesCount + ", graph.max:" + this.prepareGraph.getAllEdges().getMaxId());
            }
            return;
        }
        long tmp = (long)edgeId * 4L;
        this.originalEdges.ensureCapacity(tmp + 4L);
        this.originalEdges.setInt(tmp, value);
    }

    private int getOrigEdgeCount(int edgeId) {
        if ((edgeId -= this.maxEdgesCount) < 0) {
            return 1;
        }
        long tmp = (long)edgeId * 4L;
        this.originalEdges.ensureCapacity(tmp + 4L);
        return this.originalEdges.getInt(tmp);
    }

    String getPrepareAlgoMemoryUsage() {
        return this.prepareAlgo.getMemoryUsageAsString();
    }

    long getDijkstraCount() {
        return this.dijkstraCount;
    }

    void resetDijkstraTime() {
        this.dijkstraSW = new StopWatch();
    }

    float getDijkstraSeconds() {
        return this.dijkstraSW.getSeconds();
    }

    static class CalcShortcutsResult {
        int originalEdgesCount;
        int shortcutsCount;

        CalcShortcutsResult() {
        }
    }

    class AddShortcutHandler
    implements ShortcutHandler {
        int node;

        AddShortcutHandler() {
        }

        @Override
        public int getNode() {
            return this.node;
        }

        public AddShortcutHandler setNode(int node) {
            NodeContractor.this.shortcuts.clear();
            this.node = node;
            return this;
        }

        @Override
        public void foundShortcut(int fromNode, int toNode, double existingDirectWeight, double existingDistSum, int outgoingEdge, int outgoingEdgeOrigCount, int incomingEdge, int incomingEdgeOrigCount) {
            Shortcut sc = new Shortcut(fromNode, toNode, existingDirectWeight, existingDistSum);
            if (NodeContractor.this.shortcuts.containsKey(sc)) {
                return;
            }
            Shortcut tmpSc = new Shortcut(toNode, fromNode, existingDirectWeight, existingDistSum);
            Shortcut tmpRetSc = (Shortcut)NodeContractor.this.shortcuts.get(tmpSc);
            if (tmpRetSc != null && tmpRetSc.skippedEdge2 == incomingEdge && tmpRetSc.skippedEdge1 == outgoingEdge) {
                tmpRetSc.flags = PrepareEncoder.getScDirMask();
                return;
            }
            Shortcut old = NodeContractor.this.shortcuts.put(sc, sc);
            if (old != null) {
                throw new IllegalStateException("Shortcut did not exist (" + sc + ") but was overwriting another one? " + old);
            }
            sc.skippedEdge1 = incomingEdge;
            sc.skippedEdge2 = outgoingEdge;
            sc.originalEdges = incomingEdgeOrigCount + outgoingEdgeOrigCount;
        }
    }

    class CalcShortcutHandler
    implements ShortcutHandler {
        int node;
        CalcShortcutsResult calcShortcutsResult = new CalcShortcutsResult();

        CalcShortcutHandler() {
        }

        @Override
        public int getNode() {
            return this.node;
        }

        public CalcShortcutHandler setNode(int node) {
            this.node = node;
            this.calcShortcutsResult.originalEdgesCount = 0;
            this.calcShortcutsResult.shortcutsCount = 0;
            return this;
        }

        @Override
        public void foundShortcut(int fromNode, int toNode, double existingDirectWeight, double distance, int outgoingEdge, int outgoingEdgeOrigCount, int incomingEdge, int incomingEdgeOrigCount) {
            ++this.calcShortcutsResult.shortcutsCount;
            this.calcShortcutsResult.originalEdgesCount += incomingEdgeOrigCount + outgoingEdgeOrigCount;
        }
    }

    static interface ShortcutHandler {
        public void foundShortcut(int var1, int var2, double var3, double var5, int var7, int var8, int var9, int var10);

        public int getNode();
    }

    static class Shortcut {
        int from;
        int to;
        int skippedEdge1;
        int skippedEdge2;
        double dist;
        double weight;
        int originalEdges;
        long flags = PrepareEncoder.getScFwdDir();

        public Shortcut(int from, int to, double weight, double dist) {
            this.from = from;
            this.to = to;
            this.weight = weight;
            this.dist = dist;
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + this.from;
            hash = 23 * hash + this.to;
            return 23 * hash + (int)(Double.doubleToLongBits(this.weight) ^ Double.doubleToLongBits(this.weight) >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Shortcut other = (Shortcut)obj;
            return this.from == other.from && this.to == other.to && Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
        }

        public String toString() {
            String str = this.flags == PrepareEncoder.getScDirMask() ? this.from + "<->" : this.from + "->";
            return str + this.to + ", weight:" + this.weight + " (" + this.skippedEdge1 + "," + this.skippedEdge2 + ")";
        }
    }

    static class IgnoreNodeFilter
    implements EdgeFilter {
        int avoidNode;
        int maxLevel;
        CHGraph graph;

        IgnoreNodeFilter(CHGraph chGraph, int maxLevel) {
            this.graph = chGraph;
            this.maxLevel = maxLevel;
        }

        IgnoreNodeFilter setAvoidNode(int node) {
            this.avoidNode = node;
            return this;
        }

        @Override
        public final boolean accept(EdgeIteratorState iter) {
            int node = iter.getAdjNode();
            return this.avoidNode != node && this.graph.getLevel(node) == this.maxLevel;
        }
    }
}

