/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactoryDecorator;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMAlgoFactoryDecorator
implements RoutingAlgorithmFactoryDecorator {
    private Logger LOGGER = LoggerFactory.getLogger(LMAlgoFactoryDecorator.class);
    private int landmarkCount = 16;
    private int activeLandmarkCount = 8;
    private final List<PrepareLandmarks> preparations = new ArrayList<PrepareLandmarks>();
    private final List<String> weightingsAsStrings = new ArrayList<String>();
    private final List<Weighting> weightings = new ArrayList<Weighting>();
    private final Map<String, Double> maximumWeights = new HashMap<String, Double>();
    private boolean enabled = false;
    private int minNodes = -1;
    private boolean disablingAllowed = false;
    private final List<String> lmSuggestionsLocations = new ArrayList<String>(5);
    private int preparationThreads;
    private ExecutorService threadPool;
    private boolean logDetails = false;

    public LMAlgoFactoryDecorator() {
        this.setPreparationThreads(1);
    }

    @Override
    public void init(CmdArgs args) {
        this.setPreparationThreads(args.getInt("prepare.lm.threads", this.getPreparationThreads()));
        this.landmarkCount = args.getInt("prepare.lm.landmarks", this.landmarkCount);
        this.activeLandmarkCount = args.getInt("routing.lm.active_landmarks", Math.min(8, this.landmarkCount));
        this.logDetails = args.getBool("prepare.lm.log_details", false);
        this.minNodes = args.getInt("prepare.lm.min_network_size", -1);
        for (String loc : args.get("prepare.lm.suggestions_location", "").split(",")) {
            if (loc.trim().isEmpty()) continue;
            this.lmSuggestionsLocations.add(loc.trim());
        }
        String lmWeightingsStr = args.get("prepare.lm.weightings", "");
        if (!lmWeightingsStr.isEmpty() && !lmWeightingsStr.equalsIgnoreCase("no")) {
            List<String> tmpLMWeightingList = Arrays.asList(lmWeightingsStr.split(","));
            this.setWeightingsAsStrings(tmpLMWeightingList);
        }
        boolean enableThis = !this.weightingsAsStrings.isEmpty();
        this.setEnabled(enableThis);
        if (enableThis) {
            this.setDisablingAllowed(args.getBool("routing.lm.disabling_allowed", this.isDisablingAllowed()));
        }
    }

    public int getLandmarks() {
        return this.landmarkCount;
    }

    public LMAlgoFactoryDecorator setDisablingAllowed(boolean disablingAllowed) {
        this.disablingAllowed = disablingAllowed;
        return this;
    }

    public final boolean isDisablingAllowed() {
        return this.disablingAllowed || !this.isEnabled();
    }

    public final LMAlgoFactoryDecorator setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public void setPreparationThreads(int preparationThreads) {
        this.preparationThreads = preparationThreads;
        this.threadPool = Executors.newFixedThreadPool(preparationThreads);
    }

    public LMAlgoFactoryDecorator setWeightingsAsStrings(List<String> weightingList) {
        if (weightingList.isEmpty()) {
            throw new IllegalArgumentException("It is not allowed to pass an emtpy weightingList");
        }
        this.weightingsAsStrings.clear();
        for (String strWeighting : weightingList) {
            strWeighting = Helper.toLowerCase(strWeighting);
            strWeighting = strWeighting.trim();
            this.addWeighting(strWeighting);
        }
        return this;
    }

    public List<String> getWeightingsAsStrings() {
        if (this.weightingsAsStrings.isEmpty()) {
            throw new IllegalStateException("Potential bug: weightingsAsStrings is empty");
        }
        return this.weightingsAsStrings;
    }

    public LMAlgoFactoryDecorator addWeighting(String weighting) {
        String[] str = weighting.split("\\|");
        double value = -1.0;
        if (str.length > 1) {
            PMap map = new PMap(weighting);
            value = map.getDouble("maximum", -1.0);
        }
        this.weightingsAsStrings.add(str[0]);
        this.maximumWeights.put(str[0], value);
        return this;
    }

    public LMAlgoFactoryDecorator addWeighting(Weighting weighting) {
        this.weightings.add(weighting);
        return this;
    }

    public LMAlgoFactoryDecorator addPreparation(PrepareLandmarks pch) {
        this.preparations.add(pch);
        int lastIndex = this.preparations.size() - 1;
        if (lastIndex >= this.weightings.size()) {
            throw new IllegalStateException("Cannot access weighting for PrepareLandmarks with " + pch.getWeighting() + ". Call add(Weighting) before");
        }
        if (this.preparations.get(lastIndex).getWeighting() != this.weightings.get(lastIndex)) {
            throw new IllegalArgumentException("Weighting of PrepareContractionHierarchies " + this.preparations.get(lastIndex).getWeighting() + " needs to be identical to previously added " + this.weightings.get(lastIndex));
        }
        return this;
    }

    public boolean hasWeightings() {
        return !this.weightings.isEmpty();
    }

    public boolean hasPreparations() {
        return !this.preparations.isEmpty();
    }

    public int size() {
        return this.preparations.size();
    }

    public List<Weighting> getWeightings() {
        return this.weightings;
    }

    public List<PrepareLandmarks> getPreparations() {
        return this.preparations;
    }

    @Override
    public RoutingAlgorithmFactory getDecoratedAlgorithmFactory(RoutingAlgorithmFactory defaultAlgoFactory, HintsMap map) {
        boolean disableCH = map.getBool("ch.disable", false);
        boolean disableLM = map.getBool("lm.disable", false);
        if (!this.isEnabled() || this.disablingAllowed && disableLM || !disableCH) {
            return defaultAlgoFactory;
        }
        if (this.preparations.isEmpty()) {
            throw new IllegalStateException("No preparations added to this decorator");
        }
        for (PrepareLandmarks p : this.preparations) {
            if (!p.getWeighting().matches(map)) continue;
            return new LMRAFactory(p, defaultAlgoFactory);
        }
        return defaultAlgoFactory;
    }

    public boolean loadOrDoWork(final StorableProperties properties) {
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(this.threadPool);
        int counter = 0;
        final AtomicBoolean prepared = new AtomicBoolean(false);
        for (final PrepareLandmarks plm : this.preparations) {
            final int tmpCounter = ++counter;
            final String name = AbstractWeighting.weightingToFileName(plm.getWeighting());
            completionService.submit(new Runnable(){

                @Override
                public void run() {
                    if (plm.loadExisting()) {
                        return;
                    }
                    LMAlgoFactoryDecorator.this.LOGGER.info(tmpCounter + "/" + LMAlgoFactoryDecorator.this.getPreparations().size() + " calling LM prepare.doWork for " + plm.getWeighting() + " ... (" + Helper.getMemInfo() + ")");
                    prepared.set(true);
                    Thread.currentThread().setName(name);
                    plm.doWork();
                    properties.put("prepare.lm.date." + name, Helper.createFormatter().format(new Date()));
                }
            }, name);
        }
        this.threadPool.shutdown();
        try {
            for (int i = 0; i < this.preparations.size(); ++i) {
                completionService.take().get();
            }
        }
        catch (Exception e) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(e);
        }
        return prepared.get();
    }

    public void createPreparations(GraphHopperStorage ghStorage, LocationIndex locationIndex) {
        if (!this.isEnabled() || !this.preparations.isEmpty()) {
            return;
        }
        if (this.weightings.isEmpty()) {
            throw new IllegalStateException("No landmark weightings found");
        }
        ArrayList<LandmarkSuggestion> lmSuggestions = new ArrayList<LandmarkSuggestion>(this.lmSuggestionsLocations.size());
        if (!this.lmSuggestionsLocations.isEmpty()) {
            try {
                for (String loc : this.lmSuggestionsLocations) {
                    lmSuggestions.add(LandmarkSuggestion.readLandmarks(loc, locationIndex));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        for (Weighting weighting : this.getWeightings()) {
            Double maximumWeight = this.maximumWeights.get(weighting.getName());
            if (maximumWeight == null) {
                throw new IllegalStateException("maximumWeight cannot be null. Default should be just negative. Couldn't find " + weighting.getName() + " in " + this.maximumWeights);
            }
            PrepareLandmarks tmpPrepareLM = new PrepareLandmarks(ghStorage.getDirectory(), ghStorage, weighting, this.landmarkCount, this.activeLandmarkCount).setLandmarkSuggestions(lmSuggestions).setMaximumWeight(maximumWeight).setLogDetails(this.logDetails);
            if (this.minNodes > 1) {
                tmpPrepareLM.setMinimumNodes(this.minNodes);
            }
            this.addPreparation(tmpPrepareLM);
        }
    }

    public static class LMRAFactory
    implements RoutingAlgorithmFactory {
        private RoutingAlgorithmFactory defaultAlgoFactory;
        private PrepareLandmarks p;

        public LMRAFactory(PrepareLandmarks p, RoutingAlgorithmFactory defaultAlgoFactory) {
            this.defaultAlgoFactory = defaultAlgoFactory;
            this.p = p;
        }

        public RoutingAlgorithmFactory getDefaultAlgoFactory() {
            return this.defaultAlgoFactory;
        }

        @Override
        public RoutingAlgorithm createAlgo(Graph g, AlgorithmOptions opts) {
            RoutingAlgorithm algo = this.defaultAlgoFactory.createAlgo(g, opts);
            return this.p.getDecoratedAlgorithm(g, algo, opts);
        }
    }
}

