/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.util.shapes.GHPoint;

public class Polygon {
    private final double[] lat;
    private final double[] lon;
    private double minLat;
    private double minLon;
    private double maxLat;
    private double maxLon;
    private final double epsilon;

    public Polygon(double[] lat, double[] lon) {
        if (lat.length != lon.length) {
            throw new IllegalArgumentException("Points must be of equal length but was " + lat.length + " vs. " + lon.length);
        }
        if (lat.length == 0) {
            throw new IllegalArgumentException("Points must not be empty");
        }
        this.lat = lat;
        this.lon = lon;
        for (int i = 0; i < lat.length; ++i) {
            if (i == 0) {
                this.minLat = lat[i];
                this.maxLat = lat[i];
                this.minLon = lon[i];
                this.maxLon = lon[i];
                continue;
            }
            if (lat[i] < this.minLat) {
                this.minLat = lat[i];
            } else if (lat[i] > this.maxLat) {
                this.maxLat = lat[i];
            }
            if (lon[i] < this.minLon) {
                this.minLon = lon[i];
                continue;
            }
            if (!(lon[i] > this.maxLon)) continue;
            this.maxLon = lon[i];
        }
        this.epsilon = (this.maxLat - this.minLat) / 10.0;
    }

    public static Polygon create(com.vividsolutions.jts.geom.Polygon polygon) {
        double[] lats = new double[polygon.getNumPoints()];
        double[] lons = new double[polygon.getNumPoints()];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            lats[i] = polygon.getCoordinates()[i].y;
            lons[i] = polygon.getCoordinates()[i].x;
        }
        return new Polygon(lats, lons);
    }

    public boolean contains(GHPoint point) {
        return this.contains(point.lat, point.lon);
    }

    public boolean contains(double lat, double lon) {
        if (lat < this.minLat || lat > this.maxLat || lon < this.minLon || lon > this.maxLon) {
            return false;
        }
        double rayStartLat = this.maxLat - this.minLat / 2.0;
        double rayStartLon = this.minLon - this.epsilon;
        boolean inside = false;
        int len = this.lat.length;
        for (int i = 0; i < len; ++i) {
            if (!this.edgesAreIntersecting(rayStartLon, rayStartLat, lon, lat, this.lon[i], this.lat[i], this.lon[(i + 1) % len], this.lat[(i + 1) % len])) continue;
            inside = !inside;
        }
        return inside;
    }

    private boolean edgesAreIntersecting(double v1x1, double v1y1, double v1x2, double v1y2, double v2x1, double v2y1, double v2x2, double v2y2) {
        double a1 = v1y2 - v1y1;
        double b1 = v1x1 - v1x2;
        double c1 = v1x2 * v1y1 - v1x1 * v1y2;
        double d1 = a1 * v2x1 + b1 * v2y1 + c1;
        double d2 = a1 * v2x2 + b1 * v2y2 + c1;
        if (d1 > 0.0 && d2 > 0.0) {
            return false;
        }
        if (d1 < 0.0 && d2 < 0.0) {
            return false;
        }
        double a2 = v2y2 - v2y1;
        double b2 = v2x1 - v2x2;
        double c2 = v2x2 * v2y1 - v2x1 * v2y2;
        d1 = a2 * v1x1 + b2 * v1y1 + c2;
        d2 = a2 * v1x2 + b2 * v1y2 + c2;
        if (d1 > 0.0 && d2 > 0.0) {
            return false;
        }
        if (d1 < 0.0 && d2 < 0.0) {
            return false;
        }
        return a1 * b2 - a2 * b1 != 0.0;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }
}

