/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Storable;
import com.graphhopper.util.Helper;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class StorableProperties
implements Storable<StorableProperties> {
    private final Map<String, String> map = new LinkedHashMap<String, String>();
    private final DataAccess da;

    public StorableProperties(Directory dir) {
        this.da = dir.find("properties");
        this.da.setSegmentSize(32768);
    }

    @Override
    public synchronized boolean loadExisting() {
        if (!this.da.loadExisting()) {
            return false;
        }
        int len = (int)this.da.getCapacity();
        byte[] bytes = new byte[len];
        this.da.getBytes(0L, bytes, len);
        try {
            Helper.loadProperties(this.map, new StringReader(new String(bytes, Helper.UTF_CS)));
            return true;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public synchronized void flush() {
        try {
            StringWriter sw = new StringWriter();
            Helper.saveProperties(this.map, sw);
            byte[] bytes = sw.toString().getBytes(Helper.UTF_CS);
            this.da.setBytes(0L, bytes, bytes.length);
            this.da.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized StorableProperties remove(String key) {
        this.map.remove(key);
        return this;
    }

    public synchronized StorableProperties putAll(Map<String, String> externMap) {
        this.map.putAll(externMap);
        return this;
    }

    public synchronized StorableProperties put(String key, String val) {
        this.map.put(key, val);
        return this;
    }

    public synchronized StorableProperties put(String key, Object val) {
        if (!key.equals(Helper.toLowerCase(key))) {
            throw new IllegalArgumentException("Do not use upper case keys (" + key + ") for StorableProperties since 0.7");
        }
        this.map.put(key, val.toString());
        return this;
    }

    public synchronized String get(String key) {
        if (!key.equals(Helper.toLowerCase(key))) {
            throw new IllegalArgumentException("Do not use upper case keys (" + key + ") for StorableProperties since 0.7");
        }
        String ret = this.map.get(key);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    @Override
    public synchronized void close() {
        this.da.close();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.da.isClosed();
    }

    @Override
    public synchronized StorableProperties create(long size) {
        this.da.create(size);
        return this;
    }

    @Override
    public synchronized long getCapacity() {
        return this.da.getCapacity();
    }

    public synchronized void putCurrentVersions() {
        this.put("nodes.version", 5);
        this.put("edges.version", 14);
        this.put("geometry.version", 4);
        this.put("location_index.version", 3);
        this.put("name_index.version", 3);
        this.put("shortcuts.version", 2);
    }

    public synchronized String versionsToString() {
        return this.get("nodes.version") + "," + this.get("edges.version") + "," + this.get("geometry.version") + "," + this.get("location_index.version") + "," + this.get("name_index.version");
    }

    public synchronized boolean checkVersions(boolean silent) {
        if (!this.check("nodes", 5, silent)) {
            return false;
        }
        if (!this.check("edges", 14, silent)) {
            return false;
        }
        if (!this.check("geometry", 4, silent)) {
            return false;
        }
        if (!this.check("location_index", 3, silent)) {
            return false;
        }
        if (!this.check("name_index", 3, silent)) {
            return false;
        }
        return this.check("shortcuts", 2, silent);
    }

    boolean check(String key, int vers, boolean silent) {
        String str = this.get(key + ".version");
        if (!str.equals(vers + "")) {
            if (silent) {
                return false;
            }
            throw new IllegalStateException("Version of " + key + " unsupported: " + str + ", expected:" + vers + ". Make sure you are using the same GraphHopper version for reading the files that was used for creating them. See https://discuss.graphhopper.com/t/722");
        }
        return true;
    }

    public synchronized String toString() {
        return this.da.toString();
    }
}

