/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.change;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeGraphHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Graph graph;
    private final GraphEdgeIdFinder graphBrowser;
    private boolean enableLogging = false;

    public ChangeGraphHelper(Graph graph, LocationIndex locationIndex) {
        this.graph = graph;
        this.graphBrowser = new GraphEdgeIdFinder(graph, locationIndex);
    }

    public void setLogging(boolean log) {
        this.enableLogging = log;
    }

    public long applyChanges(EncodingManager em, Collection<JsonFeature> features) {
        long updates = 0L;
        for (JsonFeature jsonFeature : features) {
            if (!jsonFeature.hasProperties()) {
                throw new IllegalArgumentException("One feature has no properties, please specify properties e.g. speed or access");
            }
            List encodersAsStr = (List)jsonFeature.getProperty("vehicles");
            if (encodersAsStr == null) {
                for (FlagEncoder encoder : em.fetchEdgeEncoders()) {
                    updates += this.applyChange(jsonFeature, encoder);
                }
                continue;
            }
            for (String encoderStr : encodersAsStr) {
                updates += this.applyChange(jsonFeature, em.getEncoder(encoderStr));
            }
        }
        return updates;
    }

    private long applyChange(JsonFeature jsonFeature, FlagEncoder encoder) {
        long updates = 0L;
        DefaultEdgeFilter filter = new DefaultEdgeFilter(encoder);
        GHIntHashSet edges = new GHIntHashSet();
        if (jsonFeature.hasGeometry()) {
            this.graphBrowser.fillEdgeIDs(edges, jsonFeature.getGeometry(), filter);
        } else if (jsonFeature.getBBox() != null) {
            this.graphBrowser.findEdgesInShape(edges, jsonFeature.getBBox(), filter);
        } else {
            throw new IllegalArgumentException("Feature " + jsonFeature.getId() + " has no geometry and no bbox");
        }
        Iterator iter = edges.iterator();
        Map<String, Object> props = jsonFeature.getProperties();
        while (iter.hasNext()) {
            int edgeId = ((IntCursor)iter.next()).value;
            EdgeIteratorState edge = this.graph.getEdgeIteratorState(edgeId, Integer.MIN_VALUE);
            if (props.containsKey("access")) {
                boolean value = (Boolean)props.get("access");
                ++updates;
                if (this.enableLogging) {
                    this.logger.info(encoder.toString() + " - access change via feature " + jsonFeature.getId());
                }
                edge.setFlags(encoder.setAccess(edge.getFlags(), value, value));
                continue;
            }
            if (!props.containsKey("speed")) continue;
            double value = ((Number)props.get("speed")).doubleValue();
            double oldSpeed = encoder.getSpeed(edge.getFlags());
            if (oldSpeed == value) continue;
            ++updates;
            if (this.enableLogging) {
                this.logger.info(encoder.toString() + " - speed change via feature " + jsonFeature.getId() + ". Old: " + oldSpeed + ", new:" + value);
            }
            edge.setFlags(encoder.setSpeed(edge.getFlags(), value));
        }
        return updates;
    }
}

