/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class AverageSpeedDetails
extends AbstractPathDetailsBuilder {
    private final FlagEncoder encoder;
    private double curAvgSpeed = -1.0;

    public AverageSpeedDetails(FlagEncoder encoder) {
        super("average_speed");
        this.encoder = encoder;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        if (Math.abs(this.encoder.getSpeed(edge.getFlags()) - this.curAvgSpeed) > 1.0E-4) {
            this.curAvgSpeed = this.encoder.getSpeed(edge.getFlags());
            return true;
        }
        return false;
    }

    @Override
    public Object getCurrentValue() {
        return this.curAvgSpeed;
    }
}

