/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.RecalculationHook;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.ConsistentWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;

public class AStarBidirection
extends AbstractBidirAlgo
implements RecalculationHook {
    private ConsistentWeightApproximator weightApprox;

    public AStarBidirection(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        BeelineWeightApproximator defaultApprox = new BeelineWeightApproximator(this.nodeAccess, weighting);
        defaultApprox.setDistanceCalc((DistanceCalc)Helper.DIST_PLANE);
        this.setApproximation(defaultApprox);
    }

    @Override
    void init(int from, double fromWeight, int to, double toWeight) {
        this.weightApprox.setFrom(from);
        this.weightApprox.setTo(to);
        super.init(from, fromWeight, to, toWeight);
    }

    @Override
    protected AStar.AStarEntry createStartEntry(int node, double weight, boolean reverse) {
        double heapWeight = weight + this.weightApprox.approximate(node, reverse);
        return new AStar.AStarEntry(-1, node, heapWeight, weight);
    }

    @Override
    protected SPTEntry createEntry(EdgeIteratorState edge, double weight, SPTEntry parent, boolean reverse) {
        int neighborNode = edge.getAdjNode();
        double heapWeight = weight + this.weightApprox.approximate(neighborNode, reverse);
        AStar.AStarEntry entry = new AStar.AStarEntry(edge.getEdge(), neighborNode, heapWeight, weight);
        entry.parent = parent;
        return entry;
    }

    @Override
    protected void updateEntry(SPTEntry entry, EdgeIteratorState edge, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge.getEdge();
        entry.weight = weight + this.weightApprox.approximate(edge.getAdjNode(), reverse);
        ((AStar.AStarEntry)entry).weightOfVisitedPath = weight;
        entry.parent = parent;
    }

    @Override
    protected double calcWeight(EdgeIteratorState iter, SPTEntry currEdge, boolean reverse) {
        return super.calcWeight(iter, currEdge, reverse);
    }

    public WeightApproximator getApproximation() {
        return this.weightApprox.getApproximation();
    }

    public AStarBidirection setApproximation(WeightApproximator approx) {
        this.weightApprox = new ConsistentWeightApproximator(approx);
        return this;
    }

    void setFromDataStructures(AStarBidirection astar) {
        super.setFromDataStructures(astar);
        this.weightApprox.setFrom(astar.currFrom.adjNode);
    }

    void setToDataStructures(AStarBidirection astar) {
        super.setToDataStructures(astar);
        this.weightApprox.setTo(astar.currTo.adjNode);
    }

    @Override
    public void afterHeuristicChange(boolean forward, boolean backward) {
        AStar.AStarEntry[] entries;
        if (forward && !this.pqOpenSetFrom.isEmpty()) {
            entries = this.pqOpenSetFrom.toArray(new AStar.AStarEntry[this.pqOpenSetFrom.size()]);
            this.pqOpenSetFrom.clear();
            for (AStar.AStarEntry value : entries) {
                value.weight = value.weightOfVisitedPath + this.weightApprox.approximate(value.adjNode, false);
                this.pqOpenSetFrom.add(value);
            }
        }
        if (backward && !this.pqOpenSetTo.isEmpty()) {
            entries = this.pqOpenSetTo.toArray(new AStar.AStarEntry[this.pqOpenSetTo.size()]);
            this.pqOpenSetTo.clear();
            for (AStar.AStarEntry value : entries) {
                value.weight = value.weightOfVisitedPath + this.weightApprox.approximate(value.adjNode, true);
                this.pqOpenSetTo.add(value);
            }
        }
    }

    @Override
    public String getName() {
        return "astarbi|" + this.weightApprox;
    }
}

