/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathBidirRef;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.PriorityQueue;

public abstract class AbstractBidirAlgo
extends AbstractRoutingAlgorithm {
    protected IntObjectMap<SPTEntry> bestWeightMapFrom;
    protected IntObjectMap<SPTEntry> bestWeightMapTo;
    protected IntObjectMap<SPTEntry> bestWeightMapOther;
    protected SPTEntry currFrom;
    protected SPTEntry currTo;
    protected PathBidirRef bestPath;
    PriorityQueue<SPTEntry> pqOpenSetFrom;
    PriorityQueue<SPTEntry> pqOpenSetTo;
    private boolean updateBestPath = true;
    protected boolean finishedFrom;
    protected boolean finishedTo;
    int visitedCountFrom;
    int visitedCountTo;

    public AbstractBidirAlgo(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        int size = Math.min(Math.max(200, graph.getNodes() / 10), 150000);
        this.initCollections(size);
    }

    protected void initCollections(int size) {
        this.pqOpenSetFrom = new PriorityQueue(size);
        this.bestWeightMapFrom = new GHIntObjectHashMap(size);
        this.pqOpenSetTo = new PriorityQueue(size);
        this.bestWeightMapTo = new GHIntObjectHashMap(size);
    }

    protected abstract SPTEntry createStartEntry(int var1, double var2, boolean var4);

    protected abstract SPTEntry createEntry(EdgeIteratorState var1, double var2, SPTEntry var4, boolean var5);

    @Override
    public Path calcPath(int from, int to) {
        this.checkAlreadyRun();
        this.createAndInitPath();
        this.init(from, 0.0, to, 0.0);
        this.runAlgo();
        return this.extractPath();
    }

    protected Path createAndInitPath() {
        this.bestPath = new PathBidirRef(this.graph, this.weighting);
        return this.bestPath;
    }

    void init(int from, double fromWeight, int to, double toWeight) {
        this.initFrom(from, fromWeight);
        this.initTo(to, toWeight);
        this.postInit(from, to);
    }

    protected void initFrom(int from, double weight) {
        this.currFrom = this.createStartEntry(from, weight, false);
        this.pqOpenSetFrom.add(this.currFrom);
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapFrom.put(from, (Object)this.currFrom);
        }
    }

    protected void initTo(int to, double weight) {
        this.currTo = this.createStartEntry(to, weight, true);
        this.pqOpenSetTo.add(this.currTo);
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapTo.put(to, (Object)this.currTo);
        }
    }

    protected void postInit(int from, int to) {
        if (!this.traversalMode.isEdgeBased()) {
            if (this.updateBestPath) {
                this.bestWeightMapOther = this.bestWeightMapFrom;
                this.updateBestPath(GHUtility.getEdge(this.graph, this.currFrom.adjNode, to), this.currFrom, to, true);
            }
        } else if (from == to) {
            this.bestPath.sptEntry = this.currFrom;
            this.bestPath.edgeTo = this.currTo;
            this.finishedFrom = true;
            this.finishedTo = true;
        }
    }

    protected void runAlgo() {
        while (!this.finished() && !this.isMaxVisitedNodesExceeded()) {
            if (!this.finishedFrom) {
                boolean bl = this.finishedFrom = !this.fillEdgesFrom();
            }
            if (this.finishedTo) continue;
            this.finishedTo = !this.fillEdgesTo();
        }
    }

    @Override
    protected boolean finished() {
        if (this.finishedFrom || this.finishedTo) {
            return true;
        }
        return this.currFrom.weight + this.currTo.weight >= this.bestPath.getWeight();
    }

    boolean fillEdgesFrom() {
        if (this.pqOpenSetFrom.isEmpty()) {
            return false;
        }
        this.currFrom = this.pqOpenSetFrom.poll();
        ++this.visitedCountFrom;
        if (this.fromEntryCanBeSkipped()) {
            return true;
        }
        if (this.fwdSearchCanBeStopped()) {
            return false;
        }
        this.bestWeightMapOther = this.bestWeightMapTo;
        this.fillEdges(this.currFrom, this.pqOpenSetFrom, this.bestWeightMapFrom, this.outEdgeExplorer, false);
        return true;
    }

    boolean fillEdgesTo() {
        if (this.pqOpenSetTo.isEmpty()) {
            return false;
        }
        this.currTo = this.pqOpenSetTo.poll();
        ++this.visitedCountTo;
        if (this.toEntryCanBeSkipped()) {
            return true;
        }
        if (this.bwdSearchCanBeStopped()) {
            return false;
        }
        this.bestWeightMapOther = this.bestWeightMapFrom;
        this.fillEdges(this.currTo, this.pqOpenSetTo, this.bestWeightMapTo, this.inEdgeExplorer, true);
        return true;
    }

    private void fillEdges(SPTEntry currEdge, PriorityQueue<SPTEntry> prioQueue, IntObjectMap<SPTEntry> bestWeightMap, EdgeExplorer explorer, boolean reverse) {
        EdgeIterator iter = explorer.setBaseNode(currEdge.adjNode);
        while (iter.next()) {
            if (!this.accept(iter, currEdge, reverse)) continue;
            int origEdgeId = this.getOrigEdgeId(iter, reverse);
            int traversalId = this.getTraversalId(iter, origEdgeId, reverse);
            double weight = this.calcWeight(iter, currEdge, reverse);
            if (Double.isInfinite(weight)) continue;
            SPTEntry entry = (SPTEntry)bestWeightMap.get(traversalId);
            if (entry == null) {
                entry = this.createEntry(iter, weight, currEdge, reverse);
                bestWeightMap.put(traversalId, (Object)entry);
                prioQueue.add(entry);
            } else {
                if (!(entry.getWeightOfVisitedPath() > weight)) continue;
                prioQueue.remove(entry);
                this.updateEntry(entry, iter, weight, currEdge, reverse);
                prioQueue.add(entry);
            }
            if (!this.updateBestPath) continue;
            this.updateBestPath(iter, entry, traversalId, reverse);
        }
    }

    protected void updateBestPath(EdgeIteratorState edgeState, SPTEntry entry, int traversalId, boolean reverse) {
        SPTEntry entryOther = (SPTEntry)this.bestWeightMapOther.get(traversalId);
        if (entryOther == null) {
            return;
        }
        double weight = entry.getWeightOfVisitedPath() + entryOther.getWeightOfVisitedPath();
        if (this.traversalMode.isEdgeBased()) {
            if (entryOther.edge != entry.edge) {
                throw new IllegalStateException("cannot happen for edge based execution of " + this.getName());
            }
            if (entryOther.adjNode != entry.adjNode) {
                entry = entry.getParent();
                weight -= this.weighting.calcWeight(edgeState, reverse, -1);
            } else if (!this.traversalMode.hasUTurnSupport()) {
                return;
            }
        }
        if (weight < this.bestPath.getWeight()) {
            this.bestPath.setSwitchToFrom(reverse);
            this.bestPath.setSPTEntry(entry);
            this.bestPath.setSPTEntryTo(entryOther);
            this.bestPath.setWeight(weight);
        }
    }

    protected void updateEntry(SPTEntry entry, EdgeIteratorState edge, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge.getEdge();
        entry.weight = weight;
        entry.parent = parent;
    }

    protected boolean accept(EdgeIteratorState edge, SPTEntry currEdge, boolean reverse) {
        return this.accept(edge, currEdge.edge);
    }

    protected int getOrigEdgeId(EdgeIteratorState edge, boolean reverse) {
        return edge.getEdge();
    }

    protected int getTraversalId(EdgeIteratorState edge, int origEdgeId, boolean reverse) {
        return this.traversalMode.createTraversalId(edge, reverse);
    }

    protected double calcWeight(EdgeIteratorState iter, SPTEntry currEdge, boolean reverse) {
        return this.weighting.calcWeight(iter, reverse, currEdge.edge) + currEdge.getWeightOfVisitedPath();
    }

    @Override
    protected Path extractPath() {
        if (this.finished()) {
            return this.bestPath.extract();
        }
        return this.bestPath;
    }

    protected boolean fromEntryCanBeSkipped() {
        return false;
    }

    protected boolean fwdSearchCanBeStopped() {
        return false;
    }

    protected boolean toEntryCanBeSkipped() {
        return false;
    }

    protected boolean bwdSearchCanBeStopped() {
        return false;
    }

    protected double getCurrentFromWeight() {
        return this.currFrom.weight;
    }

    protected double getCurrentToWeight() {
        return this.currTo.weight;
    }

    IntObjectMap<SPTEntry> getBestFromMap() {
        return this.bestWeightMapFrom;
    }

    IntObjectMap<SPTEntry> getBestToMap() {
        return this.bestWeightMapTo;
    }

    void setBestOtherMap(IntObjectMap<SPTEntry> other) {
        this.bestWeightMapOther = other;
    }

    protected void setUpdateBestPath(boolean b) {
        this.updateBestPath = b;
    }

    void setBestPath(PathBidirRef bestPath) {
        this.bestPath = bestPath;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedCountFrom + this.visitedCountTo;
    }

    void setFromDataStructures(AbstractBidirAlgo other) {
        this.pqOpenSetFrom = other.pqOpenSetFrom;
        this.bestWeightMapFrom = other.bestWeightMapFrom;
        this.finishedFrom = other.finishedFrom;
        this.currFrom = other.currFrom;
        this.visitedCountFrom = other.visitedCountFrom;
    }

    void setToDataStructures(AbstractBidirAlgo other) {
        this.pqOpenSetTo = other.pqOpenSetTo;
        this.bestWeightMapTo = other.bestWeightMapTo;
        this.finishedTo = other.finishedTo;
        this.currTo = other.currTo;
        this.visitedCountTo = other.visitedCountTo;
    }
}

