/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.CHEdgeExplorer;

abstract class AbstractNodeContractor
implements NodeContractor {
    private final GraphHopperStorage ghStorage;
    final CHGraph prepareGraph;
    final FlagEncoder encoder;
    CHEdgeExplorer inEdgeExplorer;
    CHEdgeExplorer outEdgeExplorer;
    private final DataAccess originalEdges;
    int maxLevel;
    private int maxEdgesCount;

    public AbstractNodeContractor(Directory dir, GraphHopperStorage ghStorage, CHGraph prepareGraph, Weighting weighting) {
        this.ghStorage = ghStorage;
        this.prepareGraph = prepareGraph;
        this.encoder = weighting.getFlagEncoder();
        this.originalEdges = dir.find("original_edges_" + AbstractWeighting.weightingToFileName(weighting));
        this.originalEdges.create(1000L);
    }

    @Override
    public void initFromGraph() {
        this.inEdgeExplorer = this.prepareGraph.createEdgeExplorer(DefaultEdgeFilter.inEdges(this.encoder));
        this.outEdgeExplorer = this.prepareGraph.createEdgeExplorer(DefaultEdgeFilter.outEdges(this.encoder));
        this.maxLevel = this.prepareGraph.getNodes();
        this.maxEdgesCount = this.ghStorage.getAllEdges().length();
    }

    @Override
    public void close() {
        this.originalEdges.close();
    }

    boolean isContracted(int node) {
        return this.prepareGraph.getLevel(node) != this.maxLevel;
    }

    void setOrigEdgeCount(int edgeId, int value) {
        if ((edgeId -= this.maxEdgesCount) < 0) {
            if (value != 1) {
                throw new IllegalStateException("Trying to set original edge count for normal edge to a value = " + value + ", edge:" + (edgeId + this.maxEdgesCount) + ", max:" + this.maxEdgesCount + ", graph.max:" + this.prepareGraph.getAllEdges().length());
            }
            return;
        }
        long tmp = (long)edgeId * 4L;
        this.originalEdges.ensureCapacity(tmp + 4L);
        this.originalEdges.setInt(tmp, value);
    }

    int getOrigEdgeCount(int edgeId) {
        if ((edgeId -= this.maxEdgesCount) < 0) {
            return 1;
        }
        long tmp = (long)edgeId * 4L;
        this.originalEdges.ensureCapacity(tmp + 4L);
        return this.originalEdges.getInt(tmp);
    }
}

