/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.PathBidirRef;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.CHEdgeIteratorState;

public class Path4CH
extends PathBidirRef {
    private final Graph routingGraph;

    public Path4CH(Graph routingGraph, Graph baseGraph, Weighting weighting) {
        super(baseGraph, weighting);
        this.routingGraph = routingGraph;
    }

    @Override
    protected final void processEdge(int edgeId, int endNode, int prevEdgeId) {
        this.expandEdge(this.getEdge(edgeId, endNode), false);
    }

    private void expandEdge(CHEdgeIteratorState edge, boolean reverse) {
        if (!edge.isShortcut()) {
            this.distance += edge.getDistance();
            this.time += this.weighting.calcMillis(edge, reverse, -1);
            this.addEdge(edge.getEdge());
            return;
        }
        this.expandSkippedEdges(edge.getSkippedEdge1(), edge.getSkippedEdge2(), edge.getBaseNode(), edge.getAdjNode(), reverse);
    }

    private void expandSkippedEdges(int skippedEdge1, int skippedEdge2, int from, int to, boolean reverse) {
        CHEdgeIteratorState sk2to;
        if (this.reverseOrder == reverse) {
            int tmp = from;
            from = to;
            to = tmp;
        }
        if ((sk2to = this.getEdge(skippedEdge2, to)) != null) {
            this.expandEdge(sk2to, !this.reverseOrder);
            this.expandEdge(this.getEdge(skippedEdge1, from), this.reverseOrder);
        } else {
            this.expandEdge(this.getEdge(skippedEdge1, to), !this.reverseOrder);
            this.expandEdge(this.getEdge(skippedEdge2, from), this.reverseOrder);
        }
    }

    private CHEdgeIteratorState getEdge(int edgeId, int adjNode) {
        return (CHEdgeIteratorState)this.routingGraph.getEdgeIteratorState(edgeId, adjNode);
    }
}

