/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.coll.GHTreeMapComposed;
import com.graphhopper.routing.AStarBidirectionCH;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.DijkstraBidirectionCHNoSOD;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ch.NodeBasedNodeContractor;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.PreparationWeighting;
import com.graphhopper.routing.util.AbstractAlgoPreparation;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.LevelEdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.CHGraphImpl;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.Locale;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareContractionHierarchies
extends AbstractAlgoPreparation
implements RoutingAlgorithmFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Directory dir;
    private final PreparationWeighting prepareWeighting;
    private final Weighting weighting;
    private final TraversalMode traversalMode;
    private final GraphHopperStorage ghStorage;
    private final CHGraphImpl prepareGraph;
    private final Random rand = new Random(123L);
    private final StopWatch allSW = new StopWatch();
    private final StopWatch periodicUpdateSW = new StopWatch();
    private final StopWatch lazyUpdateSW = new StopWatch();
    private final StopWatch neighborUpdateSW = new StopWatch();
    private final StopWatch contractionSW = new StopWatch();
    private final Params params;
    private NodeContractor nodeContractor;
    private CHEdgeExplorer vehicleAllExplorer;
    private CHEdgeExplorer vehicleAllTmpExplorer;
    private int maxLevel;
    private GHTreeMapComposed sortedNodes;
    private float[] oldPriorities;
    private PMap pMap = new PMap();
    private int initSize;
    private int checkCounter;

    public PrepareContractionHierarchies(Directory dir, GraphHopperStorage ghStorage, CHGraph chGraph, TraversalMode traversalMode) {
        this.dir = dir;
        this.ghStorage = ghStorage;
        this.prepareGraph = (CHGraphImpl)chGraph;
        this.traversalMode = traversalMode;
        this.weighting = ((CHGraphImpl)chGraph).getWeighting();
        this.prepareWeighting = new PreparationWeighting(this.weighting);
        this.params = Params.forTraversalMode(traversalMode);
    }

    public PrepareContractionHierarchies setParams(PMap pMap) {
        this.pMap = pMap;
        this.params.setPeriodicUpdatesPercentage(pMap.getInt("prepare.ch.updates.periodic", this.params.getPeriodicUpdatesPercentage()));
        this.params.setLastNodesLazyUpdatePercentage(pMap.getInt("prepare.ch.updates.lazy", this.params.getLastNodesLazyUpdatePercentage()));
        this.params.setNeighborUpdatePercentage(pMap.getInt("prepare.ch.updates.neighbor", this.params.getNeighborUpdatePercentage()));
        this.params.setNodesContractedPercentage(pMap.getInt("prepare.ch.contracted_nodes", this.params.getNodesContractedPercentage()));
        this.params.setLogMessagesPercentage(pMap.getInt("prepare.ch.log_messages", this.params.getLogMessagesPercentage()));
        return this;
    }

    @Override
    public void doSpecificWork() {
        this.allSW.start();
        this.initFromGraph();
        this.runGraphContraction();
        this.logger.info("took:" + (int)this.allSW.stop().getSeconds() + "s , new shortcuts: " + Helper.nf((long)this.nodeContractor.getAddedShortcutsCount()) + ", initSize:" + Helper.nf((long)this.initSize) + ", " + this.prepareWeighting + ", periodic:" + this.params.getPeriodicUpdatesPercentage() + ", lazy:" + this.params.getLastNodesLazyUpdatePercentage() + ", neighbor:" + this.params.getNeighborUpdatePercentage() + ", " + this.getTimesAsString() + ", lazy-overhead: " + (int)(100.0 * ((double)this.checkCounter / (double)this.initSize - 1.0)) + "%, " + Helper.getMemInfo());
        int edgeCount = this.ghStorage.getAllEdges().length();
        this.logger.info("graph now - num edges: {}, num nodes: {}, num shortcuts: {}", new Object[]{Helper.nf((long)edgeCount), Helper.nf((long)this.ghStorage.getNodes()), Helper.nf((long)(this.prepareGraph.getAllEdges().length() - edgeCount))});
    }

    protected void runGraphContraction() {
        if (!this.prepareNodes()) {
            return;
        }
        this.contractNodes();
    }

    @Override
    public RoutingAlgorithm createAlgo(Graph graph, AlgorithmOptions opts) {
        AbstractBidirAlgo algo = this.doCreateAlgo(graph, opts);
        algo.setEdgeFilter(new LevelEdgeFilter(this.prepareGraph));
        algo.setMaxVisitedNodes(opts.getMaxVisitedNodes());
        return algo;
    }

    private AbstractBidirAlgo doCreateAlgo(Graph graph, AlgorithmOptions opts) {
        if ("astarbi".equals(opts.getAlgorithm())) {
            return new AStarBidirectionCH(graph, this.prepareWeighting, this.traversalMode).setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts, graph.getNodeAccess()));
        }
        if ("dijkstrabi".equals(opts.getAlgorithm())) {
            if (opts.getHints().getBool("stall_on_demand", true)) {
                return new DijkstraBidirectionCH(graph, this.prepareWeighting, this.traversalMode);
            }
            return new DijkstraBidirectionCHNoSOD(graph, this.prepareWeighting, this.traversalMode);
        }
        throw new IllegalArgumentException("Algorithm " + opts.getAlgorithm() + " not supported for Contraction Hierarchies. Try with ch.disable=true");
    }

    private void initFromGraph() {
        this.ghStorage.freeze();
        FlagEncoder prepareFlagEncoder = this.prepareWeighting.getFlagEncoder();
        DefaultEdgeFilter allFilter = DefaultEdgeFilter.allEdges(prepareFlagEncoder);
        this.maxLevel = this.prepareGraph.getNodes();
        this.vehicleAllExplorer = this.prepareGraph.createEdgeExplorer(allFilter);
        this.vehicleAllTmpExplorer = this.prepareGraph.createEdgeExplorer(allFilter);
        this.sortedNodes = new GHTreeMapComposed();
        this.oldPriorities = new float[this.prepareGraph.getNodes()];
        this.nodeContractor = new NodeBasedNodeContractor(this.dir, this.ghStorage, this.prepareGraph, this.weighting, this.pMap);
        this.nodeContractor.initFromGraph();
    }

    private boolean prepareNodes() {
        int node;
        int nodes = this.prepareGraph.getNodes();
        for (node = 0; node < nodes; ++node) {
            this.prepareGraph.setLevel(node, this.maxLevel);
        }
        this.periodicUpdateSW.start();
        for (node = 0; node < nodes; ++node) {
            float priority = this.oldPriorities[node] = this.calculatePriority(node);
            this.sortedNodes.insert(node, priority);
        }
        this.periodicUpdateSW.stop();
        return !this.sortedNodes.isEmpty();
    }

    private void contractNodes() {
        this.nodeContractor.prepareContraction();
        this.initSize = this.sortedNodes.getSize();
        int level = 0;
        this.checkCounter = 0;
        long logSize = Math.round(Math.max(10.0, (double)this.initSize / 100.0 * (double)this.params.getLogMessagesPercentage()));
        if (this.params.getLogMessagesPercentage() == 0) {
            logSize = Integer.MAX_VALUE;
        }
        boolean periodicUpdate = true;
        int updateCounter = 0;
        long periodicUpdatesCount = Math.round(Math.max(10.0, (double)this.sortedNodes.getSize() / 100.0 * (double)this.params.getPeriodicUpdatesPercentage()));
        if (this.params.getPeriodicUpdatesPercentage() == 0) {
            periodicUpdate = false;
        }
        long lastNodesLazyUpdates = Math.round((double)this.sortedNodes.getSize() / 100.0 * (double)this.params.getLastNodesLazyUpdatePercentage());
        long nodesToAvoidContract = Math.round((double)(100 - this.params.getNodesContractedPercentage()) / 100.0 * (double)this.sortedNodes.getSize());
        boolean neighborUpdate = true;
        if (this.params.getNeighborUpdatePercentage() == 0) {
            neighborUpdate = false;
        }
        while (!this.sortedNodes.isEmpty()) {
            if (periodicUpdate && this.checkCounter > 0 && (long)this.checkCounter % periodicUpdatesCount == 0L) {
                this.periodicUpdateSW.start();
                this.sortedNodes.clear();
                for (int node = 0; node < this.prepareGraph.getNodes(); ++node) {
                    if (this.prepareGraph.getLevel(node) != this.maxLevel) continue;
                    float priority = this.oldPriorities[node] = this.calculatePriority(node);
                    this.sortedNodes.insert(node, priority);
                }
                this.periodicUpdateSW.stop();
                ++updateCounter;
                if (this.sortedNodes.isEmpty()) {
                    throw new IllegalStateException("Cannot prepare as no unprepared nodes where found. Called preparation twice?");
                }
            }
            if ((long)this.checkCounter % logSize == 0L) {
                this.logStats(updateCounter);
            }
            ++this.checkCounter;
            int polledNode = this.sortedNodes.pollKey();
            if (!this.sortedNodes.isEmpty() && (long)this.sortedNodes.getSize() < lastNodesLazyUpdates) {
                this.lazyUpdateSW.start();
                float priority = this.oldPriorities[polledNode] = this.calculatePriority(polledNode);
                if (priority > this.sortedNodes.peekValue()) {
                    this.sortedNodes.insert(polledNode, priority);
                    this.lazyUpdateSW.stop();
                    continue;
                }
                this.lazyUpdateSW.stop();
            }
            this.contractionSW.start();
            this.nodeContractor.contractNode(polledNode);
            this.prepareGraph.setLevel(polledNode, level);
            ++level;
            this.contractionSW.stop();
            if ((long)this.sortedNodes.getSize() < nodesToAvoidContract) break;
            CHEdgeIterator iter = this.vehicleAllExplorer.setBaseNode(polledNode);
            while (iter.next()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException("Thread was interrupted");
                }
                int nn = iter.getAdjNode();
                if (this.prepareGraph.getLevel(nn) != this.maxLevel) continue;
                if (neighborUpdate && this.rand.nextInt(100) < this.params.getNeighborUpdatePercentage()) {
                    this.neighborUpdateSW.start();
                    float oldPrio = this.oldPriorities[nn];
                    float priority = this.oldPriorities[nn] = this.calculatePriority(nn);
                    if (priority != oldPrio) {
                        this.sortedNodes.update(nn, oldPrio, priority);
                    }
                    this.neighborUpdateSW.stop();
                }
                this.prepareGraph.disconnect(this.vehicleAllTmpExplorer, iter);
            }
        }
        this.logStats(updateCounter);
        this.close();
    }

    private void close() {
        this.nodeContractor.close();
        this.sortedNodes = null;
        this.oldPriorities = null;
    }

    public long getDijkstraCount() {
        return this.nodeContractor.getDijkstraCount();
    }

    public long getShortcuts() {
        return this.nodeContractor.getAddedShortcutsCount();
    }

    public double getLazyTime() {
        return this.lazyUpdateSW.getCurrentSeconds();
    }

    public double getPeriodTime() {
        return this.periodicUpdateSW.getCurrentSeconds();
    }

    public double getNeighborTime() {
        return this.neighborUpdateSW.getCurrentSeconds();
    }

    public Weighting getWeighting() {
        return this.prepareGraph.getWeighting();
    }

    private String getTimesAsString() {
        float totalTime = this.allSW.getCurrentSeconds();
        float periodicUpdateTime = this.periodicUpdateSW.getCurrentSeconds();
        float lazyUpdateTime = this.lazyUpdateSW.getCurrentSeconds();
        float neighborUpdateTime = this.neighborUpdateSW.getCurrentSeconds();
        float contractionTime = this.contractionSW.getCurrentSeconds();
        float otherTime = totalTime - (periodicUpdateTime + lazyUpdateTime + neighborUpdateTime + contractionTime);
        float dijkstraTime = this.nodeContractor.getDijkstraSeconds();
        return String.format(Locale.ROOT, "t(total): %6.2f,  t(period): %6.2f, t(lazy): %6.2f, t(neighbor): %6.2f, t(contr): %6.2f, t(other) : %6.2f, t(dijk): %6.2f", Float.valueOf(totalTime), Float.valueOf(periodicUpdateTime), Float.valueOf(lazyUpdateTime), Float.valueOf(neighborUpdateTime), Float.valueOf(contractionTime), Float.valueOf(otherTime), Float.valueOf(dijkstraTime));
    }

    private float calculatePriority(int node) {
        return this.nodeContractor.calculatePriority(node);
    }

    public String toString() {
        return "prepare|dijkstrabi|ch";
    }

    private void logStats(int updateCounter) {
        this.logger.info(String.format(Locale.ROOT, "nodes: %10s, shortcuts: %10s, updates: %2d, checked-nodes: %10s, %s, %s, %s", Helper.nf((long)this.sortedNodes.getSize()), Helper.nf((long)this.nodeContractor.getAddedShortcutsCount()), updateCounter, Helper.nf((long)this.checkCounter), this.getTimesAsString(), this.nodeContractor.getStatisticsString(), Helper.getMemInfo()));
    }

    private static class Params {
        private int periodicUpdatesPercentage;
        private int lastNodesLazyUpdatePercentage;
        private int neighborUpdatePercentage;
        private int nodesContractedPercentage;
        private int logMessagesPercentage;

        static Params forTraversalMode(TraversalMode traversalMode) {
            if (traversalMode.isEdgeBased()) {
                throw new IllegalArgumentException("Contraction Hierarchies are not supported for edge-based traversal yet");
            }
            return new Params(20, 10, 20, 100, 20);
        }

        private Params(int periodicUpdatesPercentage, int lastNodesLazyUpdatePercentage, int neighborUpdatePercentage, int nodesContractedPercentage, int logMessagesPercentage) {
            this.setPeriodicUpdatesPercentage(periodicUpdatesPercentage);
            this.setLastNodesLazyUpdatePercentage(lastNodesLazyUpdatePercentage);
            this.setNeighborUpdatePercentage(neighborUpdatePercentage);
            this.setNodesContractedPercentage(nodesContractedPercentage);
            this.setLogMessagesPercentage(logMessagesPercentage);
        }

        int getPeriodicUpdatesPercentage() {
            return this.periodicUpdatesPercentage;
        }

        void setPeriodicUpdatesPercentage(int periodicUpdatesPercentage) {
            this.checkPercentage("prepare.ch.updates.periodic", periodicUpdatesPercentage);
            this.periodicUpdatesPercentage = periodicUpdatesPercentage;
        }

        int getLastNodesLazyUpdatePercentage() {
            return this.lastNodesLazyUpdatePercentage;
        }

        void setLastNodesLazyUpdatePercentage(int lastNodesLazyUpdatePercentage) {
            this.checkPercentage("prepare.ch.updates.lazy", lastNodesLazyUpdatePercentage);
            this.lastNodesLazyUpdatePercentage = lastNodesLazyUpdatePercentage;
        }

        int getNeighborUpdatePercentage() {
            return this.neighborUpdatePercentage;
        }

        void setNeighborUpdatePercentage(int neighborUpdatePercentage) {
            this.checkPercentage("prepare.ch.updates.neighbor", neighborUpdatePercentage);
            this.neighborUpdatePercentage = neighborUpdatePercentage;
        }

        int getNodesContractedPercentage() {
            return this.nodesContractedPercentage;
        }

        void setNodesContractedPercentage(int nodesContractedPercentage) {
            this.checkPercentage("prepare.ch.contracted_nodes", nodesContractedPercentage);
            this.nodesContractedPercentage = nodesContractedPercentage;
        }

        int getLogMessagesPercentage() {
            return this.logMessagesPercentage;
        }

        void setLogMessagesPercentage(int logMessagesPercentage) {
            this.checkPercentage("prepare.ch.log_messages", logMessagesPercentage);
            this.logMessagesPercentage = logMessagesPercentage;
        }

        private void checkPercentage(String name, int value) {
            if (value < 0 || value > 100) {
                throw new IllegalArgumentException(name + " has to be in [0, 100], to disable it use 0");
            }
        }
    }
}

