/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.template.AbstractRoutingTemplate;
import com.graphhopper.routing.template.RoutingTemplate;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.tour.MultiPointTour;
import com.graphhopper.routing.util.tour.TourStrategy;
import com.graphhopper.routing.weighting.AvoidEdgesWeighting;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.Translation;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class RoundTripRoutingTemplate
extends AbstractRoutingTemplate
implements RoutingTemplate {
    private final int maxRetries;
    private final GHRequest ghRequest;
    private final GHResponse ghResponse;
    private final LocationIndex locationIndex;
    private PathWrapper altResponse;
    private List<Path> pathList;

    public RoundTripRoutingTemplate(GHRequest request, GHResponse ghRsp, LocationIndex locationIndex, int maxRetries) {
        this.ghRequest = request;
        this.ghResponse = ghRsp;
        this.locationIndex = locationIndex;
        this.maxRetries = maxRetries;
    }

    @Override
    public List<QueryResult> lookup(List<GHPoint> points, FlagEncoder encoder) {
        if (points.size() != 1 || this.ghRequest.getPoints().size() != 1) {
            throw new IllegalArgumentException("For round trip calculation exactly one point is required");
        }
        double distanceInMeter = this.ghRequest.getHints().getDouble("round_trip.distance", 10000.0);
        long seed = this.ghRequest.getHints().getLong("round_trip.seed", 0L);
        double initialHeading = this.ghRequest.getFavoredHeading(0);
        int roundTripPointCount = Math.min(20, this.ghRequest.getHints().getInt("round_trip.points", 2 + (int)(distanceInMeter / 50000.0)));
        GHPoint start = points.get(0);
        MultiPointTour strategy = new MultiPointTour(new Random(seed), distanceInMeter, roundTripPointCount, initialHeading);
        this.queryResults = new ArrayList(2 + ((TourStrategy)strategy).getNumberOfGeneratedPoints());
        DefaultEdgeFilter edgeFilter = DefaultEdgeFilter.allEdges(encoder);
        QueryResult startQR = this.locationIndex.findClosest(start.lat, start.lon, edgeFilter);
        if (!startQR.isValid()) {
            throw new PointNotFoundException("Cannot find point 0: " + start, 0);
        }
        this.queryResults.add(startQR);
        GHPoint last = start;
        for (int i = 0; i < ((TourStrategy)strategy).getNumberOfGeneratedPoints(); ++i) {
            double heading = ((TourStrategy)strategy).getHeadingForIteration(i);
            QueryResult result = this.generateValidPoint(last, ((TourStrategy)strategy).getDistanceForIteration(i), heading, edgeFilter);
            if (result == null) {
                this.ghResponse.addError((Throwable)new IllegalStateException("Could not find a valid point after " + this.maxRetries + " tries, for the point:" + last));
                return Collections.emptyList();
            }
            last = result.getSnappedPoint();
            this.queryResults.add(result);
        }
        this.queryResults.add(startQR);
        return this.queryResults;
    }

    void setQueryResults(List<QueryResult> queryResults) {
        this.queryResults = queryResults;
    }

    @Override
    public List<Path> calcPaths(QueryGraph queryGraph, RoutingAlgorithmFactory algoFactory, AlgorithmOptions algoOpts) {
        this.pathList = new ArrayList<Path>(this.queryResults.size() - 1);
        AvoidEdgesWeighting avoidPathWeighting = new AvoidEdgesWeighting(algoOpts.getWeighting());
        avoidPathWeighting.setEdgePenaltyFactor(5.0);
        algoOpts = AlgorithmOptions.start(algoOpts).algorithm("astarbi").weighting(avoidPathWeighting).build();
        algoOpts.getHints().put("astarbi.epsilon", (Object)2);
        long visitedNodesSum = 0L;
        QueryResult start = (QueryResult)this.queryResults.get(0);
        for (int qrIndex = 1; qrIndex < this.queryResults.size(); ++qrIndex) {
            RoutingAlgorithm algo = algoFactory.createAlgo(queryGraph, algoOpts);
            QueryResult startQR = (QueryResult)this.queryResults.get(qrIndex - 1);
            int startNode = startQR == start ? startQR.getClosestNode() : startQR.getClosestEdge().getBaseNode();
            QueryResult endQR = (QueryResult)this.queryResults.get(qrIndex);
            int endNode = endQR == start ? endQR.getClosestNode() : endQR.getClosestEdge().getBaseNode();
            Path path = algo.calcPath(startNode, endNode);
            visitedNodesSum += (long)algo.getVisitedNodes();
            this.pathList.add(path);
            avoidPathWeighting.addEdges(path.calcEdges());
        }
        this.ghResponse.getHints().put("visited_nodes.sum", (Object)visitedNodesSum);
        this.ghResponse.getHints().put("visited_nodes.average", (Object)Float.valueOf((float)visitedNodesSum / (float)(this.queryResults.size() - 1)));
        return this.pathList;
    }

    public void setPaths(List<Path> pathList) {
        this.pathList = pathList;
    }

    @Override
    public boolean isReady(PathMerger pathMerger, Translation tr) {
        this.altResponse = new PathWrapper();
        this.altResponse.setWaypoints(this.getWaypoints());
        this.ghResponse.add(this.altResponse);
        pathMerger.doWork(this.altResponse, this.pathList, tr);
        return true;
    }

    private QueryResult generateValidPoint(GHPoint from, double distanceInMeters, double heading, EdgeFilter edgeFilter) {
        int tryCount = 0;
        do {
            GHPoint generatedPoint;
            QueryResult qr;
            if ((qr = this.locationIndex.findClosest((generatedPoint = Helper.DIST_EARTH.projectCoordinate(from.getLat(), from.getLon(), distanceInMeters, heading)).getLat(), generatedPoint.getLon(), edgeFilter)).isValid()) {
                return qr;
            }
            distanceInMeters *= 0.95;
        } while (++tryCount < this.maxRetries);
        return null;
    }

    @Override
    public int getMaxRetries() {
        return 1;
    }
}

