/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.template.AbstractRoutingTemplate;
import com.graphhopper.routing.template.RoutingTemplate;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.NameSimilarityEdgeFilter;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.List;

public class ViaRoutingTemplate
extends AbstractRoutingTemplate
implements RoutingTemplate {
    protected final GHRequest ghRequest;
    protected final GHResponse ghResponse;
    protected final PathWrapper altResponse = new PathWrapper();
    private final LocationIndex locationIndex;
    protected List<Path> pathList;

    public ViaRoutingTemplate(GHRequest ghRequest, GHResponse ghRsp, LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
        this.ghRequest = ghRequest;
        this.ghResponse = ghRsp;
    }

    @Override
    public List<QueryResult> lookup(List<GHPoint> points, FlagEncoder encoder) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least 2 points have to be specified, but was:" + points.size());
        }
        DefaultEdgeFilter edgeFilter = DefaultEdgeFilter.allEdges(encoder);
        this.queryResults = new ArrayList(points.size());
        for (int placeIndex = 0; placeIndex < points.size(); ++placeIndex) {
            GHPoint point = points.get(placeIndex);
            QueryResult qr = null;
            if (this.ghRequest.hasPointHints()) {
                qr = this.locationIndex.findClosest(point.lat, point.lon, new NameSimilarityEdgeFilter(edgeFilter, (String)this.ghRequest.getPointHints().get(placeIndex)));
            }
            if (qr == null || !qr.isValid()) {
                qr = this.locationIndex.findClosest(point.lat, point.lon, edgeFilter);
            }
            if (!qr.isValid()) {
                this.ghResponse.addError((Throwable)new PointNotFoundException("Cannot find point " + placeIndex + ": " + point, placeIndex));
            }
            this.queryResults.add(qr);
        }
        return this.queryResults;
    }

    @Override
    public List<Path> calcPaths(QueryGraph queryGraph, RoutingAlgorithmFactory algoFactory, AlgorithmOptions algoOpts) {
        long visitedNodesSum = 0L;
        boolean viaTurnPenalty = this.ghRequest.getHints().getBool("pass_through", false);
        int pointCounts = this.ghRequest.getPoints().size();
        this.pathList = new ArrayList<Path>(pointCounts - 1);
        QueryResult fromQResult = (QueryResult)this.queryResults.get(0);
        for (int placeIndex = 1; placeIndex < pointCounts; ++placeIndex) {
            Path prevRoute;
            if (placeIndex == 1) {
                queryGraph.enforceHeading(fromQResult.getClosestNode(), this.ghRequest.getFavoredHeading(0), false);
            } else if (viaTurnPenalty && (prevRoute = this.pathList.get(placeIndex - 2)).getEdgeCount() > 0) {
                EdgeIteratorState incomingVirtualEdge = prevRoute.getFinalEdge();
                queryGraph.unfavorVirtualEdgePair(fromQResult.getClosestNode(), incomingVirtualEdge.getEdge());
            }
            QueryResult toQResult = (QueryResult)this.queryResults.get(placeIndex);
            queryGraph.enforceHeading(toQResult.getClosestNode(), this.ghRequest.getFavoredHeading(placeIndex), true);
            StopWatch sw = new StopWatch().start();
            RoutingAlgorithm algo = algoFactory.createAlgo(queryGraph, algoOpts);
            String debug = ", algoInit:" + sw.stop().getSeconds() + "s";
            sw = new StopWatch().start();
            List<Path> tmpPathList = algo.calcPaths(fromQResult.getClosestNode(), toQResult.getClosestNode());
            debug = debug + ", " + algo.getName() + "-routing:" + sw.stop().getSeconds() + "s";
            if (tmpPathList.isEmpty()) {
                throw new IllegalStateException("At least one path has to be returned for " + fromQResult + " -> " + toQResult);
            }
            int idx = 0;
            for (Path path : tmpPathList) {
                if (path.getTime() < 0L) {
                    throw new RuntimeException("Time was negative " + path.getTime() + " for index " + idx + ". Please report as bug and include:" + this.ghRequest);
                }
                this.pathList.add(path);
                debug = debug + ", " + path.getDebugInfo();
                ++idx;
            }
            this.altResponse.addDebugInfo(debug);
            queryGraph.clearUnfavoredStatus();
            if (algo.getVisitedNodes() >= algoOpts.getMaxVisitedNodes()) {
                throw new IllegalArgumentException("No path found due to maximum nodes exceeded " + algoOpts.getMaxVisitedNodes());
            }
            this.altResponse.addDebugInfo("visited nodes sum: " + (visitedNodesSum += (long)algo.getVisitedNodes()));
            fromQResult = toQResult;
        }
        this.ghResponse.getHints().put("visited_nodes.sum", (Object)visitedNodesSum);
        this.ghResponse.getHints().put("visited_nodes.average", (Object)Float.valueOf((float)visitedNodesSum / (float)(pointCounts - 1)));
        return this.pathList;
    }

    @Override
    public boolean isReady(PathMerger pathMerger, Translation tr) {
        if (this.ghRequest.getPoints().size() - 1 != this.pathList.size()) {
            throw new RuntimeException("There should be exactly one more points than paths. points:" + this.ghRequest.getPoints().size() + ", paths:" + this.pathList.size());
        }
        this.altResponse.setWaypoints(this.getWaypoints());
        this.ghResponse.add(this.altResponse);
        pathMerger.doWork(this.altResponse, this.pathList, tr);
        return true;
    }

    @Override
    public int getMaxRetries() {
        return 1;
    }
}

