/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.EdgeIteratorState;

public class DefaultEdgeFilter
implements EdgeFilter {
    private final boolean bwd;
    private final boolean fwd;
    private FlagEncoder encoder;

    protected DefaultEdgeFilter(FlagEncoder encoder, boolean fwd, boolean bwd) {
        this.encoder = encoder;
        this.bwd = bwd;
        this.fwd = fwd;
    }

    public static DefaultEdgeFilter outEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder, true, false);
    }

    public static DefaultEdgeFilter inEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder, false, true);
    }

    public static DefaultEdgeFilter allEdges(FlagEncoder flagEncoder) {
        return new DefaultEdgeFilter(flagEncoder, true, true);
    }

    @Override
    public final boolean accept(EdgeIteratorState iter) {
        return this.fwd && iter.isForward(this.encoder) || this.bwd && iter.isBackward(this.encoder);
    }

    public boolean acceptsBackward() {
        return this.bwd;
    }

    public boolean acceptsForward() {
        return this.fwd;
    }

    public String toString() {
        return this.encoder.toString() + ", bwd:" + this.bwd + ", fwd:" + this.fwd;
    }
}

