/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.util.PMap;
import java.util.Set;
import java.util.TreeMap;

public class HikeFlagEncoder
extends FootFlagEncoder {
    public HikeFlagEncoder() {
        this(4, 1.0);
    }

    public HikeFlagEncoder(PMap properties) {
        this((int)properties.getLong("speedBits", 4L), properties.getDouble("speedFactor", 1.0));
        this.properties = properties;
        this.setBlockFords(properties.getBool("block_fords", false));
    }

    public HikeFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    public HikeFlagEncoder(int speedBits, double speedFactor) {
        super(speedBits, speedFactor);
        this.hikingNetworkToCode.put("iwn", PriorityCode.BEST.getValue());
        this.hikingNetworkToCode.put("nwn", PriorityCode.BEST.getValue());
        this.hikingNetworkToCode.put("rwn", PriorityCode.VERY_NICE.getValue());
        this.hikingNetworkToCode.put("lwn", PriorityCode.VERY_NICE.getValue());
        this.init();
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public long acceptWay(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String footTag;
            long acceptPotentially = 0L;
            if (way.hasTag("route", (Set<String>)this.ferries) && ((footTag = way.getTag("foot")) == null || "yes".equals(footTag))) {
                acceptPotentially = this.acceptBit | this.ferryBit;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                acceptPotentially = this.acceptBit;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                acceptPotentially = this.acceptBit;
            }
            if (acceptPotentially != 0L) {
                if (way.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                    return 0L;
                }
                return acceptPotentially;
            }
            return 0L;
        }
        if (way.hasTag("foot", (Set<String>)this.intendedValues)) {
            return this.acceptBit;
        }
        if (way.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
            return 0L;
        }
        if (way.hasTag("sidewalk", (Set<String>)this.sidewalkValues)) {
            return this.acceptBit;
        }
        if (!this.allowedHighwayTags.contains(highwayValue)) {
            return 0L;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return 0L;
        }
        if (this.isBlockFords() && (way.hasTag("highway", (Object)"ford") || way.hasTag("ford", new String[0]))) {
            return 0L;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return 0L;
        }
        return this.acceptBit;
    }

    @Override
    void collect(ReaderWay way, TreeMap<Double, Integer> weightToPrioMap) {
        String highway = way.getTag("highway");
        if (way.hasTag("foot", (Object)"designated")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        double maxSpeed = this.getMaxSpeed(way);
        if (this.safeHighwayTags.contains(highway) || maxSpeed > 0.0 && maxSpeed <= 20.0) {
            weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
            if (way.hasTag("tunnel", (Set<String>)this.intendedValues)) {
                if (way.hasTag("sidewalk", (Set<String>)this.sidewalksNoValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.REACH_DEST.getValue());
                } else {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if (maxSpeed > 50.0 || this.avoidHighwayTags.contains(highway)) {
            if (way.hasTag("sidewalk", (Set<String>)this.sidewalksNoValues)) {
                weightToPrioMap.put(45.0, PriorityCode.WORST.getValue());
            } else {
                weightToPrioMap.put(45.0, PriorityCode.REACH_DEST.getValue());
            }
        }
        if (way.hasTag("bicycle", (Object)"official") || way.hasTag("bicycle", (Object)"designated")) {
            weightToPrioMap.put(44.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
        }
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (super.supports(feature)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(feature);
    }

    @Override
    public String toString() {
        return "hike";
    }
}

