/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.ConstraintVertex;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.List;

public class RasterHullBuilder {
    public List<List<Double[]>> calcList(List<List<Double[]>> pointsList, int maxIsolines) {
        if (maxIsolines > pointsList.size()) {
            throw new IllegalStateException("maxIsolines can only be smaller or equals to pointsList");
        }
        ArrayList<ConstraintVertex> sites = new ArrayList<ConstraintVertex>();
        for (int i = 0; i < pointsList.size(); ++i) {
            List<Double[]> level = pointsList.get(i);
            for (Double[] xy : level) {
                ConstraintVertex site = new ConstraintVertex(new Coordinate(xy[0].doubleValue(), xy[1].doubleValue()));
                site.setZ((double)i);
                sites.add(site);
            }
        }
        ConformingDelaunayTriangulator conformingDelaunayTriangulator = new ConformingDelaunayTriangulator(sites, 0.0);
        conformingDelaunayTriangulator.setConstraints(new ArrayList(), new ArrayList());
        conformingDelaunayTriangulator.formInitialDelaunay();
        QuadEdgeSubdivision tin = conformingDelaunayTriangulator.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (!tin.isFrameVertex(vertex)) continue;
            vertex.setZ(Double.MAX_VALUE);
        }
        ArrayList<List<Double[]>> polygons = new ArrayList<List<Double[]>>();
        ContourBuilder contourBuilder = new ContourBuilder(tin);
        for (int i = 0; i < maxIsolines; ++i) {
            Geometry geometry = contourBuilder.computeIsoline((double)i + 0.5);
            ArrayList<Double[]> coords = new ArrayList<Double[]>();
            if (geometry instanceof MultiPolygon) {
                MultiPolygon mPoly = (MultiPolygon)geometry;
                int maxPoints = 0;
                Geometry maxGeo = null;
                for (int j = 0; j < mPoly.getNumGeometries(); ++j) {
                    Geometry geo = mPoly.getGeometryN(j);
                    if (geo.getNumPoints() <= maxPoints) continue;
                    maxPoints = geo.getNumPoints();
                    maxGeo = geo;
                }
                if (maxGeo == null) {
                    throw new IllegalStateException("no maximum polygon was found?");
                }
                this.fillExteriorRing(coords, maxGeo);
            } else if (geometry instanceof Polygon) {
                this.fillExteriorRing(coords, geometry);
            } else {
                throw new IllegalStateException("geometry no (multi)polygon");
            }
            polygons.add(coords);
        }
        return polygons;
    }

    private void fillExteriorRing(List<Double[]> coords, Geometry geo) {
        if (geo instanceof Polygon) {
            Polygon poly = (Polygon)geo;
            LineString ls = poly.getExteriorRing();
            for (int j = 0; j < ls.getNumPoints(); ++j) {
                Point p = ls.getPointN(j);
                coords.add(new Double[]{p.getX(), p.getY()});
            }
        } else {
            int len = geo.getCoordinates().length;
            Coordinate first = geo.getCoordinates()[0];
            for (int j = 0; j < len; ++j) {
                Coordinate coord = geo.getCoordinates()[j];
                coords.add(new Double[]{coord.x, coord.y});
                if (j <= 10 || coord.x != first.x || coord.y != first.y) {
                    continue;
                }
                break;
            }
        }
    }
}

