/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.voyager.boot;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

public class VoyagerIndexHtmlTemplate {
    private static final String CDNJS_CLOUDFLARE_COM_AJAX_LIBS = "//cdnjs.cloudflare.com/ajax/libs/";
    private static final String CDN_JSDELIVR_NET_NPM = "//cdn.jsdelivr.net/npm/";
    private static final String VOYAGER = "graphql-voyager";
    private static final String FAVICON_APIS_GURU = "//apis.guru/graphql-voyager/icons/favicon-16x16.png";
    @Value(value="${voyager.endpoint:/graphql}")
    private String graphqlEndpoint;
    @Value(value="${voyager.pageTitle:Voyager}")
    private String pageTitle;
    @Value(value="${voyager.static.basePath:/}")
    private String staticBasePath;
    @Value(value="${voyager.cdn.enabled:false}")
    private Boolean voyagerCdnEnabled;
    @Value(value="${voyager.cdn.version:1.0.0-rc.26}")
    private String voyagerCdnVersion;

    public String fillIndexTemplate(String contextPath) throws IOException {
        String template = StreamUtils.copyToString((InputStream)new ClassPathResource("voyager.html").getInputStream(), (Charset)Charset.defaultCharset());
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("graphqlEndpoint", contextPath + this.graphqlEndpoint);
        replacements.put("pageTitle", this.pageTitle);
        replacements.put("pageFavicon", this.getResourceUrl(this.staticBasePath, "favicon.ico", FAVICON_APIS_GURU));
        replacements.put("es6PromiseJsUrl", this.getResourceUrl(this.staticBasePath, "es6-promise.auto.min.js", this.joinCdnjsPath("es6-promise", "4.1.1", "es6-promise.auto.min.js")));
        replacements.put("fetchJsUrl", this.getResourceUrl(this.staticBasePath, "fetch.min.js", this.joinCdnjsPath("fetch", "2.0.4", "fetch.min.js")));
        replacements.put("reactJsUrl", this.getResourceUrl(this.staticBasePath, "react.min.js", this.joinCdnjsPath("react", "16.8.3", "umd/react.production.min.js")));
        replacements.put("reactDomJsUrl", this.getResourceUrl(this.staticBasePath, "react-dom.min.js", this.joinCdnjsPath("react-dom", "16.8.3", "umd/react-dom.production.min.js")));
        replacements.put("voyagerCssUrl", this.getResourceUrl(this.staticBasePath, "voyager.css", this.joinJsDelivrPath(VOYAGER, this.voyagerCdnVersion, "dist/voyager.css")));
        replacements.put("voyagerJsUrl", this.getResourceUrl(this.staticBasePath, "voyager.min.js", this.joinJsDelivrPath(VOYAGER, this.voyagerCdnVersion, "dist/voyager.min.js")));
        replacements.put("voyagerWorkerJsUrl", this.getResourceUrl(this.staticBasePath, "voyager.worker.js", this.joinJsDelivrPath(VOYAGER, this.voyagerCdnVersion, "dist/voyager.worker.min.js")));
        replacements.put("contextPath", contextPath);
        return StrSubstitutor.replace((Object)template, replacements);
    }

    private String getResourceUrl(String staticBasePath, String staticFileName, String cdnUrl) {
        if (this.voyagerCdnEnabled.booleanValue() && StringUtils.isNotBlank((CharSequence)cdnUrl)) {
            return cdnUrl;
        }
        return this.joinStaticPath(staticBasePath, staticFileName);
    }

    private String joinStaticPath(String staticBasePath, String staticFileName) {
        return staticBasePath + "vendor/voyager/" + staticFileName;
    }

    private String joinCdnjsPath(String library, String cdnVersion, String cdnFileName) {
        return CDNJS_CLOUDFLARE_COM_AJAX_LIBS + library + "/" + cdnVersion + "/" + cdnFileName;
    }

    private String joinJsDelivrPath(String library, String cdnVersion, String cdnFileName) {
        return CDN_JSDELIVR_NET_NPM + library + "@" + cdnVersion + "/" + cdnFileName;
    }
}

