/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.Collection;
import proguard.analysis.cpa.algorithms.CpaAlgorithm;
import proguard.analysis.cpa.defaults.BreadthFirstWaitlist;
import proguard.analysis.cpa.defaults.DefaultReachedSet;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.interfaces.Waitlist;

public abstract class CpaRun<CpaT extends ConfigurableProgramAnalysis, AbstractStateT extends AbstractState> {
    protected CpaT cpa;
    protected AbortOperator abortOperator = NeverAbortOperator.INSTANCE;

    public ReachedSet execute() {
        CpaAlgorithm cpaAlgorithm = new CpaAlgorithm((ConfigurableProgramAnalysis)this.getCpa());
        Waitlist waitList = this.createWaitlist();
        ReachedSet reachedSet = this.createReachedSet();
        Collection<AbstractStateT> initialStates = this.getInitialStates();
        waitList.addAll(initialStates);
        reachedSet.addAll(initialStates);
        cpaAlgorithm.run(reachedSet, waitList, this.getAbortOperator());
        return reachedSet;
    }

    protected ReachedSet createReachedSet() {
        return new DefaultReachedSet();
    }

    protected Waitlist createWaitlist() {
        return new BreadthFirstWaitlist();
    }

    public abstract Collection<AbstractStateT> getInitialStates();

    public CpaT getCpa() {
        return this.cpa;
    }

    public AbortOperator getAbortOperator() {
        return this.abortOperator;
    }
}

