/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.classfile.Signature;

public class JvmReturnTaintSink
extends JvmTaintSink {
    public JvmReturnTaintSink(Signature signature) {
        super(signature);
    }

    public JvmReturnTaintSink(Signature signature, Predicate<TaintSource> isValidForSource) {
        super(signature, isValidForSource);
    }

    @Override
    public Set<JvmMemoryLocation> getMemoryLocations() {
        return Collections.singleton(new JvmStackLocation(0));
    }

    @Override
    public boolean matchCfaEdge(JvmCfaEdge edge) {
        return edge instanceof JvmInstructionCfaEdge && edge.getTarget().isReturnExitNode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("[JvmReturnTaintSink] ").append(this.signature);
        if (!IS_VALID_FOR_SOURCE_DEFAULT.equals(this.isValidForSource)) {
            result.append(", filtered by source: ").append(this.isValidForSource);
        }
        return result.toString();
    }
}

