/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import proguard.analysis.cpa.domain.taint.TaintSink;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.Signature;

public abstract class JvmTaintSink
extends TaintSink {
    public JvmTaintSink(Signature signature) {
        super(signature);
    }

    public JvmTaintSink(Signature signature, Predicate<TaintSource> isValidForSource) {
        super(signature, isValidForSource);
    }

    public abstract Set<JvmMemoryLocation> getMemoryLocations();

    public abstract boolean matchCfaEdge(JvmCfaEdge var1);

    public static Map<Signature, Map<JvmTaintSink, Set<JvmMemoryLocation>>> convertSinksToMemoryLocations(Collection<? extends JvmTaintSink> taintSinks) {
        HashMap<Signature, Map<JvmTaintSink, Set<JvmMemoryLocation>>> result = new HashMap<Signature, Map<JvmTaintSink, Set<JvmMemoryLocation>>>();
        for (JvmTaintSink jvmTaintSink : taintSinks) {
            Set<JvmMemoryLocation> memoryLocations = jvmTaintSink.getMemoryLocations();
            result.computeIfAbsent(jvmTaintSink.signature, x -> new HashMap()).put(jvmTaintSink, memoryLocations);
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

