/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.util;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InstructionClassifier {
    private static final Set<Byte> returnInstructions = Stream.of((byte)-79, (byte)-84, (byte)-83, (byte)-82, (byte)-81, (byte)-80).collect(Collectors.toSet());
    private static final Set<Byte> invokeInstructions = Stream.of((byte)-70, (byte)-72, (byte)-73, (byte)-74, (byte)-71).collect(Collectors.toSet());
    private static final Set<Byte> longShiftInstructions = Stream.of((byte)121, (byte)123, (byte)125).collect(Collectors.toSet());

    public static boolean isReturn(byte opcode) {
        return returnInstructions.contains(opcode);
    }

    public static boolean isTypedReturn(byte opcode) {
        return returnInstructions.contains(opcode) && opcode != -79;
    }

    public static boolean isInvoke(byte opcode) {
        return invokeInstructions.contains(opcode);
    }

    public static boolean isLongShift(byte opcode) {
        return longShiftInstructions.contains(opcode);
    }
}

