/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.util;

import java.util.Arrays;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.BamCpaRun;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.JvmCompositeHeapReduceOperator;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceReduceOperator;
import proguard.analysis.cpa.jvm.operators.JvmDefaultReduceOperator;
import proguard.analysis.cpa.jvm.state.heap.HeapModel;
import proguard.classfile.MethodSignature;

public abstract class JvmBamCpaRun<CpaT extends ConfigurableProgramAnalysis, AbstractStateT extends LatticeAbstractState<AbstractStateT>, OuterAbstractStateT extends AbstractState>
extends BamCpaRun<CpaT, OuterAbstractStateT, JvmCfaNode, JvmCfaEdge, MethodSignature> {
    protected JvmCfa cfa;
    public final HeapModel heapModel;

    protected JvmBamCpaRun(JvmCfa cfa, int maxCallStackDepth) {
        this(cfa, maxCallStackDepth, HeapModel.FORGETFUL, NeverAbortOperator.INSTANCE, true);
    }

    protected JvmBamCpaRun(JvmCfa cfa, int maxCallStackDepth, HeapModel heapModel, AbortOperator abortOperator, boolean reduceHeap) {
        super(abortOperator, maxCallStackDepth, reduceHeap);
        this.cfa = cfa;
        this.heapModel = heapModel;
    }

    public JvmCfa getCfa() {
        return this.cfa;
    }

    @Override
    public ReduceOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> createReduceOperator() {
        JvmDefaultReduceOperator jvmReduceOperator = new JvmDefaultReduceOperator(this.reduceHeap);
        switch (this.heapModel) {
            case FORGETFUL: {
                return jvmReduceOperator;
            }
            case TREE: 
            case TAINT_TREE: {
                return new JvmCompositeHeapReduceOperator(Arrays.asList(new JvmReferenceReduceOperator(this.reduceHeap), jvmReduceOperator));
            }
        }
        throw new IllegalArgumentException("Heap model " + this.heapModel.name() + " is not supported by " + this.getClass().getName());
    }

    @Override
    protected ReachedSet createReachedSet() {
        return new ProgramLocationDependentReachedSet();
    }

    public static abstract class Builder
    extends BamCpaRun.Builder {
        protected JvmCfa cfa;
        protected HeapModel heapModel = HeapModel.FORGETFUL;

        public abstract JvmBamCpaRun<?, ?, ?> build();

        @Override
        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            return (Builder)super.setMaxCallStackDepth(maxCallStackDepth);
        }

        @Override
        public Builder setAbortOperator(AbortOperator abortOperator) {
            return (Builder)super.setAbortOperator(abortOperator);
        }

        @Override
        public Builder setReduceHeap(boolean reduceHeap) {
            return (Builder)super.setReduceHeap(reduceHeap);
        }

        public Builder setCfa(JvmCfa cfa) {
            this.cfa = cfa;
            return this;
        }

        public Builder setHeapModel(HeapModel heapModel) {
            this.heapModel = heapModel;
            return this;
        }
    }
}

